/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.aspect;

import com.digiwin.athena.atmc.application.aspect.BacklogDataModel;
import com.jugg.agile.biz.digiwin.context.ask.ASKContext;
import com.jugg.agile.biz.digiwin.context.ask.ASKContextEntity;
import java.lang.reflect.Method;
import java.time.Duration;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BacklogDataModelAspect {
    private static final Logger log = LoggerFactory.getLogger(BacklogDataModelAspect.class);
    private final ExpressionParser parser = new SpelExpressionParser();
    private final DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
    @Resource
    RedisTemplate<String, Object> redisTemplate;

    @Before(value="@annotation(com.digiwin.athena.atmc.application.aspect.BacklogDataModel)")
    public void addHeader(JoinPoint joinPoint) {
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = joinPoint.getArgs();
            BacklogDataModel annotation = method.getAnnotation(BacklogDataModel.class);
            MethodBasedEvaluationContext context = new MethodBasedEvaluationContext((Object)TypedValue.NULL, method, args, (ParameterNameDiscoverer)this.nameDiscoverer);
            Object value = this.parser.parseExpression(annotation.value()).getValue((EvaluationContext)context);
            if (ASKContext.getInstance().get().getArchiveRouteKey() != null) {
                this.redisTemplate.opsForValue().set((Object)String.valueOf(value), (Object)ASKContext.getInstance().get().getArchiveRouteKey(), Duration.ofMinutes(5L));
            } else {
                this.dealArchiveRouteKey(String.valueOf(value));
            }
        }
        catch (Exception e) {
            log.error("deal with archive-route-key failure", (Throwable)e);
        }
    }

    private void dealArchiveRouteKey(Object targetParam) {
        ASKContextEntity askContextEntity;
        Object o;
        if (targetParam != null && (o = this.redisTemplate.opsForValue().get((Object)String.valueOf(targetParam))) != null && (askContextEntity = ASKContext.getInstance().get()) != null) {
            askContextEntity.setArchiveRouteKey(o.toString());
        }
    }
}

