/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.application.service.query.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.configuration.BacklogAsyncConfig;
import com.digiwin.athena.atmc.application.dto.request.TodoBackLogNumReq;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.service.query.backlog.BpmTodoBacklogQueryCountingQryService;
import com.digiwin.athena.atmc.application.service.query.backlog.TodoBacklogQueryCountingQryService;
import com.digiwin.athena.atmc.core.concurrent.pool.DynamicThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BacklogQueryCountingQryService {
    private static final Logger log = LoggerFactory.getLogger(BacklogQueryCountingQryService.class);
    @Autowired
    private BpmTodoBacklogQueryCountingQryService bpmTodoBacklogServiceQuery;
    @Autowired
    private TodoBacklogQueryCountingQryService backlogCardQueryService;
    @Autowired
    DynamicThreadPool taskExecutor;
    @Autowired
    BacklogAsyncConfig backlogAsyncConfig;

    public List<TaskCardResp> getBacklogListByTenantIdAndUserIdAndCode(AuthoredUser user, TodoBackLogNumReq req) {
        ArrayList<TaskCardResp> backlogDTOS = new ArrayList<TaskCardResp>();
        Runnable bpmTask = () -> backlogDTOS.addAll(this.bpmTodoBacklogServiceQuery.getBacklogListByTenantIdAndUserIdAndCode(user, req.getClientId()));
        CompletableFuture<Void> bpmSubmit = this.submit(bpmTask);
        Runnable ptmTask = () -> backlogDTOS.addAll(this.backlogCardQueryService.getBacklogListByTenantIdAndUserIdAndCode(user, req.getClientId()));
        CompletableFuture<Void> ptmSubmit = this.submit(ptmTask);
        try {
            CompletableFuture.allOf(bpmSubmit, ptmSubmit).get(this.backlogAsyncConfig.getTimeOut(), this.backlogAsyncConfig.getTimeUnit());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return backlogDTOS;
    }

    private CompletableFuture<Void> submit(Runnable task) {
        return CompletableFuture.runAsync(task, (Executor)this.taskExecutor);
    }
}

