/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.ptm;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.common.dao.ptm.PtmBacklogMapper;
import com.digiwin.athena.atmc.common.dao.ptm.PtmProjectCardMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivityWorkitem;
import com.digiwin.athena.atmc.common.domain.BpmProcess;
import com.digiwin.athena.atmc.common.domain.ptm.PtmBacklog;
import com.digiwin.athena.atmc.common.domain.ptm.PtmProjectCard;
import com.digiwin.athena.atmc.common.domain.ptm.model.PtmMergeBacklogDTO;
import com.digiwin.athena.atmc.common.domain.task.BacklogDTO;
import com.digiwin.athena.atmc.common.service.tenantToken.TenantTokenService;
import com.digiwin.athena.atmc.common.util.SummaryMessagesUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.domain.Backlog;
import com.digiwin.athena.atmc.http.domain.Task;
import com.digiwin.athena.atmc.http.domain.task.ActivityDataDTO;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.eoc.EocService;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocEmployeeDTO;
import com.digiwin.athena.atmc.http.restful.ptm.PtmService;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmActivityRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardDetailDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmSolveTask;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskCardDataDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWorkItemRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskCategory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PtmTransformService {
    private static final Logger log = LoggerFactory.getLogger(PtmTransformService.class);
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private TenantTokenService tenantTokenService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private EocService eocService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private PtmProjectCardMapper ptmProjectCardMapper;

    public boolean enablePTM() {
        return StringUtils.isNotBlank((String)this.envProperties.getPtmUri());
    }

    public Map<Long, PtmMergeBacklogDTO> dealBacklogData(List<Long> backlogIdList, Boolean history) {
        if (history == null) {
            history = false;
        }
        if (CollectionUtils.isEmpty(backlogIdList)) {
            return new HashMap<Long, PtmMergeBacklogDTO>();
        }
        List ptmBacklogItemDTOList = this.ptmService.getBacklogByBacklogIds(backlogIdList);
        if (CollectionUtils.isEmpty((Collection)ptmBacklogItemDTOList)) {
            return null;
        }
        Map<Long, List<PtmBacklogItemDTO>> ptmBacklogItemMap = ptmBacklogItemDTOList.stream().collect(Collectors.groupingBy(PtmBacklogItemDTO::getBacklogId));
        HashMap<Long, PtmMergeBacklogDTO> resultMap = new HashMap<Long, PtmMergeBacklogDTO>();
        for (Map.Entry<Long, List<PtmBacklogItemDTO>> entry : ptmBacklogItemMap.entrySet()) {
            Long backlogId = entry.getKey();
            List<PtmBacklogItemDTO> itemDTOList = entry.getValue();
            List planEndTimeList = null;
            planEndTimeList = history != false ? itemDTOList.stream().sorted(Comparator.comparing(PtmBacklogItemDTO::getPlanEndTime)).map(PtmBacklogItemDTO::getPlanEndTime).collect(Collectors.toList()) : itemDTOList.stream().filter(item -> item.getClosed() == false).sorted(Comparator.comparing(PtmBacklogItemDTO::getPlanEndTime)).map(PtmBacklogItemDTO::getPlanEndTime).collect(Collectors.toList());
            List pendingList = itemDTOList.stream().filter(item -> item.getClosed() == false).collect(Collectors.toList());
            PtmMergeBacklogDTO ptmMergeBacklogDTO = new PtmMergeBacklogDTO();
            ptmMergeBacklogDTO.setBacklogId(backlogId);
            ptmMergeBacklogDTO.setTaskName(itemDTOList.get(0).getTaskName());
            if (CollectionUtils.isNotEmpty(planEndTimeList)) {
                ptmMergeBacklogDTO.setPlanEndTimeMin((LocalDateTime)planEndTimeList.get(0));
                ptmMergeBacklogDTO.setPlanEndTimeMax((LocalDateTime)planEndTimeList.get(planEndTimeList.size() - 1));
            }
            ptmMergeBacklogDTO.setClosed(CollectionUtils.isEmpty(pendingList));
            resultMap.put(backlogId, ptmMergeBacklogDTO);
        }
        return resultMap;
    }

    public List<ActivityDataDTO> getActivityDataByBacklogId(Long backlogId, Boolean isHistory) {
        ArrayList<ActivityDataDTO> result = new ArrayList<ActivityDataDTO>();
        if (!this.enablePTM()) {
            return result;
        }
        List<Object> backlogItemList = new ArrayList();
        PtmBacklog overdueBacklog = this.ptmBacklogMapper.selectOverdueById(backlogId);
        PtmBacklog dataUniformityBacklog = null;
        if (overdueBacklog != null) {
            backlogId = overdueBacklog.getOverdueBacklogId();
        } else {
            dataUniformityBacklog = this.ptmBacklogMapper.selectDataUniformityById(backlogId);
            if (dataUniformityBacklog != null) {
                backlogId = dataUniformityBacklog.getSourceBacklogId();
            }
        }
        backlogItemList = this.ptmService.getBacklogByBacklogId(backlogId);
        if (CollectionUtils.isEmpty(backlogItemList)) {
            PtmWorkItemRecordDTO workItemRecordDTO;
            Long workitemId = backlogId;
            List<PtmBacklog> backlogList = this.ptmBacklogMapper.selectByWorkItemId(backlogId);
            if (CollectionUtils.isEmpty(backlogList) && (workItemRecordDTO = this.ptmService.getWorkItemRecord(backlogId)) != null) {
                backlogList = new ArrayList<PtmBacklog>();
                PtmBacklog ptmBacklog = new PtmBacklog();
                ptmBacklog.setBacklogId(workItemRecordDTO.getBacklogId());
                backlogList.add(ptmBacklog);
            }
            if (CollectionUtils.isNotEmpty(backlogList)) {
                backlogId = backlogList.get(0).getBacklogId();
                backlogItemList = this.ptmService.getBacklogByBacklogId(backlogId);
                backlogItemList = backlogItemList.stream().filter(x -> Objects.equals(x.getWorkItemId(), workitemId)).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty(backlogItemList)) {
            PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(backlogId));
            PtmBacklogRecordDTO ptmBacklogRecord = this.ptmService.getBacklogRecord(backlogId);
            List taskCardDataList = this.ptmService.getTaskDataByBacklogId(backlogId, "");
            if (null == isHistory || BooleanUtils.isFalse((Boolean)isHistory)) {
                isHistory = BooleanUtils.isTrue((Boolean)ptmBacklogRecord.getClosed());
            }
            Map<Long, PtmMergeBacklogDTO> mergeBacklogDTOMap = this.dealBacklogData(backlogItemList.stream().map(PtmBacklogItemDTO::getBacklogId).collect(Collectors.toList()), isHistory);
            PtmBacklog finalDataUniformityBacklog = dataUniformityBacklog;
            List ptmTaskRecordList = this.ptmService.getTaskRecordByTaskIds(backlogItemList.stream().map(PtmBacklogItemDTO::getTaskId).distinct().collect(Collectors.toList()));
            Map<Long, PtmTaskRecordDTO> ptmTaskRecordMap = ptmTaskRecordList.stream().collect(Collectors.toMap(PtmTaskRecordDTO::getId, v -> v, (p1, p2) -> p1));
            List ptmActivityRecordList = this.ptmService.getActivityRecordByActivityIds(backlogItemList.stream().map(PtmBacklogItemDTO::getActivityId).distinct().collect(Collectors.toList()));
            Map<Long, PtmActivityRecordDTO> ptmActivityRecordMap = ptmActivityRecordList.stream().collect(Collectors.toMap(PtmActivityRecordDTO::getId, v -> v, (p1, p2) -> p1));
            List ptmProjectRecordList = this.ptmService.getProjectRecordByProjectIds(backlogItemList.stream().map(PtmBacklogItemDTO::getProjectId).distinct().collect(Collectors.toList()));
            Map<Long, PtmProjectRecordDTO> ptmProjectRecordMap = ptmProjectRecordList.stream().collect(Collectors.toMap(PtmProjectRecordDTO::getId, v -> v, (p1, p2) -> p1));
            List workItemRecordList = this.ptmService.getWorkItemRecordByWorkItemIds(backlogItemList.stream().map(PtmBacklogItemDTO::getWorkItemId).distinct().collect(Collectors.toList()));
            Map<Long, PtmWorkItemRecordDTO> ptmWorkItemRecordMap = workItemRecordList.stream().collect(Collectors.toMap(PtmWorkItemRecordDTO::getId, v -> v, (p1, p2) -> p1));
            List ptmSolveTasks = new ArrayList();
            BacklogDTO backlogDTO = this.selectBacklogForCard(backlogId);
            if (backlogDTO != null && org.springframework.util.StringUtils.pathEquals((String)TmTaskCategory.SOLVE.getValue(), (String)backlogDTO.getTmCategory())) {
                ptmSolveTasks = this.ptmService.getSolveTaskListV2(backlogId);
            }
            ArrayList finalPtmSolveTasks = ptmSolveTasks;
            backlogItemList.forEach(bl -> {
                PtmTaskCardDataDTO td;
                PtmTaskRecordDTO ptmTaskRecord = (PtmTaskRecordDTO)ptmTaskRecordMap.get(bl.getTaskId());
                PtmActivityRecordDTO ptmActivityRecord = (PtmActivityRecordDTO)ptmActivityRecordMap.get(bl.getActivityId());
                PtmProjectRecordDTO ptmProjectRecord = (PtmProjectRecordDTO)ptmProjectRecordMap.get(bl.getProjectId());
                PtmWorkItemRecordDTO ptmWorkItemRecord = (PtmWorkItemRecordDTO)ptmWorkItemRecordMap.get(bl.getWorkItemId());
                PtmMergeBacklogDTO ptmMergeBacklogDTO = (PtmMergeBacklogDTO)mergeBacklogDTOMap.get(ptmBacklogRecord.getId());
                ActivityDataDTO activityDataDTO = ActivityDataDTO.builder().bpmActivitySqlId(ptmTaskRecord.getId()).bpmData(null).bpmStateData(null).tmActivityId(ptmTaskRecord.getTaskDefCode()).tmPattern(ptmTaskRecord.getTaskDefPattern()).tmCategory(ptmTaskRecord.getTaskDefCategory()).bpmActivityType(ptmTaskRecord.getBpmnType()).bpmActivityId(ptmActivityRecord.getBpmActivityId()).performerIds(null).processSerialNumber(ptmProjectRecord.getProcessSerialNumber()).backlogId(ptmBacklogRecord.getId()).backlogName(ptmTaskRecord.getTaskName()).targetTenantId(ptmBacklog.getTargetTenantId()).performerId(ptmWorkItemRecord.getPerformerId()).performerName(ptmWorkItemRecord.getPerformerName()).readCount(ptmBacklog.getReadCount()).startTime(ptmTaskRecord.getCreateTime()).planEndTime(ptmTaskRecord.getPlanEndTime()).endTime(bl.getClosedTime()).taskId(ptmBacklogRecord.getProjectId()).tmTaskId(ptmProjectRecord.getProjectDefCode()).chargeId(ptmProjectRecord.getPersonInCharge()).chargeName(ptmProjectRecord.getPersonInChargeName()).tenantId(ptmProjectRecord.getTenantId()).businessUnit(JsonUtils.objectToString((Object)ptmTaskRecord.getBusinessUnit())).taskStartTime(ptmProjectRecord.getStartTime()).taskEndTime(ptmProjectRecord.getEndTime()).taskName(ptmProjectRecord.getProjectName()).tmActivityName(ptmTaskRecord.getTaskDefName()).finishedActionId(ptmBacklog.getClosed() != false ? ptmBacklog.getActionId() : null).tmShowFlow(Boolean.valueOf(false)).stepId(ptmActivityRecord.getId()).taskSourceIds(ptmProjectRecord.getSourceIds()).stepSignReason(ptmActivityRecord.getSignReason()).approvalState(ptmBacklog.getApprovalState()).backlogClosed(Boolean.valueOf(ptmBacklog.getClosed() != false || bl.getClosed() != false)).merge(ptmBacklogRecord.getMerge()).proxyToken(StringUtils.isNotBlank((String)ptmTaskRecord.getProxyToken()) ? ptmTaskRecord.getProxyToken() : ptmProjectRecord.getProxyToken()).processCreateTime(ptmProjectRecord.getCreateTime()).compositionId("").overdueWorkitemId(Long.valueOf(0L)).workItemId(ptmWorkItemRecord.getId()).taskUid(ptmTaskRecord.getBpmTaskUid()).preTaskUid(null).stepState(ptmActivityRecord.getState()).stepSubState(ptmActivityRecord.getSubState()).traceId(ptmProjectRecord.getTraceId()).eocName(ptmProjectRecord.getEocName()).dataFrom("PTM").ptmBacklogId(ptmBacklogRecord.getId()).ptmWorkItemId(ptmWorkItemRecord.getId()).type(SummaryMessagesUtils.translateBacklogType(ptmBacklog.getType())).sourceWorkitemId(ptmBacklog.getSourceBacklogId()).merge(ptmBacklog.getMerge()).build();
                if (ptmBacklog.getMerge().booleanValue() && ptmMergeBacklogDTO != null) {
                    activityDataDTO.setPlanEndTimeMin(ptmMergeBacklogDTO.getPlanEndTimeMin());
                    activityDataDTO.setPlanEndTimeMax(ptmMergeBacklogDTO.getPlanEndTimeMax());
                }
                if (StringUtils.isNotBlank((String)ptmProjectRecord.getProxyToken()) || StringUtils.isNotBlank((String)ptmTaskRecord.getProxyToken())) {
                    activityDataDTO.setProxyToken(this.tenantTokenService.queryVirtualToken(ptmProjectRecord.getTenantId()));
                }
                BpmActivityWorkitem bpmWorkitem = SummaryMessagesUtils.translatePtmWorkItem(ptmBacklog, ptmWorkItemRecord);
                activityDataDTO.setWorkitemList(JsonUtils.objectToString(Arrays.asList(bpmWorkitem)));
                Optional<PtmTaskCardDataDTO> taskData = taskCardDataList.stream().filter(t -> Objects.equals(t.getTaskId(), ptmTaskRecord.getId())).findFirst();
                if (taskData.isPresent() && (td = taskData.get()).getData() != null) {
                    Map stateData;
                    activityDataDTO.setBpmData(JsonUtils.objectToString((Object)td.getData()));
                    if (CollectionUtils.isNotEmpty((Collection)finalPtmSolveTasks) && MapUtils.isNotEmpty((Map)(stateData = this.getStateData(td.getData(), finalPtmSolveTasks, ptmActivityRecord, ptmWorkItemRecord)))) {
                        activityDataDTO.setBpmStateData(JsonUtils.objectToString((Object)stateData));
                    }
                }
                if (overdueBacklog != null) {
                    activityDataDTO.setBacklogId(overdueBacklog.getBacklogId());
                    activityDataDTO.setPtmBacklogId(overdueBacklog.getBacklogId());
                    activityDataDTO.setPtmWorkItemId(overdueBacklog.getBacklogId());
                    activityDataDTO.setWorkItemId(overdueBacklog.getBacklogId());
                    activityDataDTO.setOverdueWorkitemId(overdueBacklog.getOverdueBacklogId());
                    activityDataDTO.setBacklogClosed(overdueBacklog.getClosed());
                    activityDataDTO.setReadCount(overdueBacklog.getReadCount());
                    activityDataDTO.setPerformerId(overdueBacklog.getPerformerId());
                    activityDataDTO.setPrePerformerName(overdueBacklog.getPerformerName());
                    bpmWorkitem.setId(overdueBacklog.getBacklogId());
                    bpmWorkitem.setOverdueWorkitemId(overdueBacklog.getOverdueBacklogId());
                    activityDataDTO.setWorkitemList(JsonUtils.objectToString(Arrays.asList(bpmWorkitem)));
                }
                if (finalDataUniformityBacklog != null) {
                    activityDataDTO.setType(finalDataUniformityBacklog.getType());
                    activityDataDTO.setSourceWorkitemId(finalDataUniformityBacklog.getSourceBacklogId());
                }
                if (null != ptmProjectRecord.getData()) {
                    activityDataDTO.setProjectBpmData(JsonUtils.objectToString((Object)ptmProjectRecord.getData()));
                }
                result.add(activityDataDTO);
            });
        }
        return result;
    }

    public BacklogDTO selectBacklogForCard(Long backlogId) {
        BacklogDTO result = null;
        if (!this.enablePTM()) {
            return result;
        }
        List backlogList = this.ptmService.getBacklogByBacklogId(backlogId);
        PtmBacklog ptmOverdueBacklog = null;
        if (CollectionUtils.isEmpty((Collection)backlogList)) {
            Long workItemId;
            PtmWorkItemRecordDTO workItemRecordDTO;
            ptmOverdueBacklog = this.ptmBacklogMapper.selectOverdueById(backlogId);
            if (ptmOverdueBacklog != null) {
                backlogList = this.ptmService.getBacklogByBacklogId(ptmOverdueBacklog.getOverdueBacklogId());
            }
            if (CollectionUtils.isEmpty((Collection)backlogList) && (workItemRecordDTO = this.ptmService.getWorkItemRecord(workItemId = backlogId)) != null) {
                backlogList = this.ptmService.getBacklogByBacklogId(workItemRecordDTO.getBacklogId());
                backlogList = backlogList.stream().filter(x -> Objects.equals(x.getWorkItemId(), workItemId)).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)backlogList)) {
            PtmBacklogItemDTO ptmBacklog = (PtmBacklogItemDTO)backlogList.get(0);
            PtmTaskRecordDTO ptmTaskRecord = this.ptmService.getTaskRecord(ptmBacklog.getTaskId());
            PtmProjectRecordDTO ptmProjectRecord = this.ptmService.getProjectRecord(ptmTaskRecord.getProjectId());
            result = BacklogDTO.builder().id(backlogId).tmTaskId(ptmProjectRecord.getProjectDefCode()).tmActivityId(ptmTaskRecord.getTaskDefCode()).tmPattern(ptmTaskRecord.getTaskDefPattern()).tmCategory(ptmTaskRecord.getTaskDefCategory()).summaryLayoutCacheText(null).overdueWorkitemId(0L).approvalState(null).tmActivityName(ptmTaskRecord.getTaskDefName()).dataFrom("PTM").build();
            if (ptmOverdueBacklog != null) {
                result.setId(ptmOverdueBacklog.getBacklogId());
                result.setOverdueWorkitemId(ptmOverdueBacklog.getOverdueBacklogId());
            } else {
                PtmBacklog backlog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(backlogId));
                if (backlog != null) {
                    result.setApprovalState(backlog.getApprovalState());
                    if (StringUtils.isNotBlank((String)result.getApprovalState())) {
                        result.setApprovalState(GlobalConstant.backlogStatusMap.getOrDefault(result.getApprovalState(), ""));
                    }
                }
            }
        }
        return result;
    }

    private Map getStateData(Map taskData, List<PtmSolveTask> ptmSolveTasks, PtmActivityRecordDTO ptmActivityRecord, PtmWorkItemRecordDTO ptmWorkItemRecord) {
        if (CollectionUtils.isEmpty(ptmSolveTasks)) {
            return new HashMap();
        }
        Long ptmWorkItemId = ptmWorkItemRecord.getId();
        List unitKeys = ptmSolveTasks.get(0).getUniKeys();
        String dataKeys = ptmSolveTasks.get(0).getUniKeys().stream().collect(Collectors.joining(";"));
        HashMap<String, Object> stateData = new HashMap<String, Object>();
        stateData.put("dataKeys", dataKeys);
        stateData.put("originalQueryVariableName", "ptm_abnormal_data");
        ArrayList originalQueryVariables = new ArrayList();
        stateData.put("ptm_abnormal_data", originalQueryVariables);
        ptmSolveTasks.forEach(ptmSolveTask -> {
            if (ptmSolveTask.getData() != null) {
                ptmSolveTask.getData().forEach(dataItem -> {
                    if (ptmWorkItemId.equals(ptmSolveTask.getOriginalWorkItemId())) {
                        String serialNumber = ptmSolveTask.getSerialNumber();
                        HashMap<String, Object> instance = new HashMap<String, Object>();
                        instance.put("taskUid", ptmSolveTask.getTaskUid());
                        instance.put("processSerialNumber", serialNumber);
                        instance.put("tmActivityIds", new ArrayList());
                        instance.put("solveTaskId", ptmActivityRecord.getTaskId());
                        instance.put("solveBpmActivityId", ptmActivityRecord.getBpmActivityId());
                        instance.put("solveBpmActivityName", ptmActivityRecord.getBpmActivityName());
                        instance.put("bpmActivityId", ptmSolveTask.getTaskDefCode());
                        instance.put("bpmActivityName", ptmSolveTask.getTaskName());
                        instance.put("solveWorkItemId", ptmWorkItemRecord.getId());
                        instance.put("state", ptmSolveTask.getState());
                        Integer index = SummaryMessagesUtils.withinStateData(originalQueryVariables, dataItem, unitKeys);
                        List<HashMap<String, Object>> processInstances = new ArrayList<HashMap<String, Object>>();
                        if (index >= 0) {
                            processInstances = (List)((Map)originalQueryVariables.get(index)).get("processInstances");
                        }
                        processInstances.add(instance);
                        dataItem.put("processInstances", processInstances);
                        dataItem.put("state", ptmSolveTask.getState());
                        originalQueryVariables.add(dataItem);
                    }
                });
            }
        });
        return stateData;
    }

    public List<ActivityDataDTO> getViewActionsByProjectId(long projectId, String tmActivityId) {
        ArrayList<ActivityDataDTO> result = new ArrayList<ActivityDataDTO>();
        if (!this.enablePTM()) {
            return result;
        }
        PtmProjectCardRecordDTO projectCardRecord = this.ptmService.getProjectCardRecord(Long.valueOf(projectId));
        List backlogItemDTOList = null;
        backlogItemDTOList = projectCardRecord != null ? this.ptmService.getBacklogByProjectCardIdAndTaskCode(Long.valueOf(projectId), tmActivityId) : this.ptmService.getBacklogByProjectIdAndTaskCode(Long.valueOf(projectId), tmActivityId);
        if (CollectionUtils.isEmpty((Collection)backlogItemDTOList)) {
            return result;
        }
        ArrayList projectRecordList = new ArrayList();
        backlogItemDTOList.forEach(ptmBacklog -> {
            PtmTaskCardDataDTO taskCardDataDTO;
            PtmTaskRecordDTO ptmTaskRecord = this.ptmService.getTaskRecord(ptmBacklog.getTaskId());
            List<PtmTaskCardDataDTO> taskCardDataList = null;
            if (ptmBacklog.getActivityId() != null) {
                taskCardDataDTO = this.ptmService.getTaskDataByActivityId(ptmBacklog.getActivityId(), "data");
                if (taskCardDataDTO != null) {
                    taskCardDataList = new ArrayList();
                    taskCardDataList.add(taskCardDataDTO);
                }
            } else if (ptmBacklog.getTaskId() != null) {
                taskCardDataDTO = this.ptmService.getTaskDataByTaskId(ptmBacklog.getTaskId(), "data");
                if (taskCardDataDTO != null) {
                    taskCardDataList = new ArrayList();
                    taskCardDataList.add(taskCardDataDTO);
                }
            } else if (ptmBacklog.getBacklogId() != null) {
                taskCardDataList = this.ptmService.getTaskDataByBacklogId(ptmBacklog.getBacklogId(), "data");
            }
            PtmWorkItemRecordDTO workItemRecordDTO = this.ptmService.getWorkItemRecord(ptmBacklog.getWorkItemId());
            Optional<PtmProjectRecordDTO> optionalProject = projectRecordList.stream().filter(x -> Objects.equals(x.getId(), ptmBacklog.getProjectId())).findFirst();
            PtmProjectRecordDTO projectRecord = null;
            if (optionalProject.isPresent()) {
                projectRecord = optionalProject.get();
            } else {
                projectRecord = this.ptmService.getProjectRecord(ptmBacklog.getProjectId());
                projectRecordList.add(projectRecord);
            }
            ArrayList<BpmActivityWorkitem> workitemList = new ArrayList<BpmActivityWorkitem>();
            if (workItemRecordDTO != null) {
                EocEmployeeDTO eocEmployeeDTO = this.getEmployee(workItemRecordDTO.getPerformerId());
                BpmActivityWorkitem wi = BpmActivityWorkitem.builder().id(workItemRecordDTO.getId()).performerId(workItemRecordDTO.getPerformerId()).performerName(workItemRecordDTO.getPerformerName()).performerState(eocEmployeeDTO != null ? eocEmployeeDTO.getStatus() : null).workitemId(workItemRecordDTO.getWorkItemId()).createType(workItemRecordDTO.getCreateType()).state(workItemRecordDTO.getState()).subState(workItemRecordDTO.getSubState()).agentPerformerId(workItemRecordDTO.getAgentPerformerId()).agentPerformerName(workItemRecordDTO.getAgentPerformerName()).comment(workItemRecordDTO.getComment()).groupId(0L).build();
                workitemList.add(wi);
            }
            ActivityDataDTO data = new ActivityDataDTO();
            data.setTaskId(projectRecord.getId());
            data.setTmTaskId(projectRecord.getProjectDefCode());
            data.setTmActivityId(tmActivityId);
            data.setTenantId(projectRecord.getTenantId());
            data.setBpmActivitySqlId(ptmBacklog.getTaskId());
            if (CollectionUtils.isNotEmpty(taskCardDataList) && ((PtmTaskCardDataDTO)taskCardDataList.get(0)).getData() != null) {
                data.setBpmData(JsonUtils.objectToString((Object)((PtmTaskCardDataDTO)taskCardDataList.get(0)).getData()));
            }
            data.setBpmStateData(null);
            data.setBpmActivityId(null);
            data.setBpmActivityType(ptmBacklog.getBpmnType());
            data.setPerformerIds(null);
            data.setProcessSerialNumber(projectRecord.getProcessSerialNumber());
            data.setTmActivityName(null);
            data.setTmPattern(ptmBacklog.getTaskDefPattern());
            data.setTmCategory(ptmBacklog.getTaskDefCategory());
            data.setBacklogName(null);
            data.setStartTime(ptmBacklog.getCreateTime());
            data.setPlanEndTime(ptmBacklog.getPlanEndTime());
            data.setEndTime(ptmBacklog.getClosedTime());
            data.setWorkitemList(JsonUtils.objectToString(workitemList));
            data.setChargeId(projectRecord.getPersonInCharge());
            data.setChargeName(projectRecord.getPersonInChargeName());
            data.setBusinessUnit(JsonUtils.objectToString((Object)projectRecord.getBusinessUnit()));
            data.setEocName(projectRecord.getEocName());
            data.setTaskStartTime(projectRecord.getStartTime());
            data.setTaskEndTime(projectRecord.getEndTime());
            data.setProcessCreateTime(projectRecord.getCreateTime());
            data.setTaskName(ptmBacklog.getTaskName());
            data.setTmShowFlow(Boolean.valueOf(false));
            data.setStepId(ptmBacklog.getActivityId());
            data.setTaskSourceIds(projectRecord.getSourceIds());
            data.setStepSignReason(null);
            data.setApprovalState(null);
            data.setBacklogClosed(ptmBacklog.getClosed());
            data.setMerge(Boolean.valueOf(false));
            data.setProxyToken(projectRecord.getProxyToken());
            data.setCompositionId(null);
            data.setOverdueWorkitemId(null);
            data.setTaskUid(ptmTaskRecord.getBpmTaskUid());
            data.setPreTaskUid(null);
            data.setPrePerformerId(null);
            data.setPrePerformerName(null);
            data.setPreAgentPerformerId(null);
            data.setPreAgentPerformerName(null);
            data.setPrePerformerType(null);
            data.setStepState(null);
            data.setStepSubState(null);
            data.setTraceId(projectRecord.getTraceId());
            data.setPtmBacklogId(ptmBacklog.getBacklogId());
            data.setPtmWorkItemId(ptmBacklog.getWorkItemId());
            data.setDataFrom("PTM");
            if (CollectionUtils.isNotEmpty(workitemList)) {
                BpmActivityWorkitem workitem = (BpmActivityWorkitem)workitemList.get(0);
                data.setBacklogId(workitem.getId());
                data.setPerformerId(workitem.getPerformerId());
                data.setPerformerName(workitem.getPerformerName());
                data.setPerformerState(workitem.getPerformerState());
                data.setWorkItemId(workitem.getId());
            }
            if (null != projectRecord.getData()) {
                data.setProjectBpmData(JsonUtils.objectToString((Object)projectRecord.getData()));
            }
            result.add(data);
        });
        return result;
    }

    public EocEmployeeDTO getEmployee(String userId) {
        EocEmployeeDTO eocEmployeeDTO = null;
        try {
            eocEmployeeDTO = this.eocService.getEmployeeByUserId(userId);
        }
        catch (Exception e) {
            log.error("query eocUser(api/eoc/v2/emp/info) error:" + e.getMessage());
        }
        return eocEmployeeDTO;
    }

    public List<ActivityDataDTO> selectTaskEngineProjectCardActivityData(String projectIds, String activityPass) {
        String[] ids;
        if (!this.enablePTM()) {
            return null;
        }
        ArrayList<Long> projectIdList = new ArrayList<Long>();
        for (String id : ids = StringUtils.split((String)projectIds, (String)",")) {
            projectIdList.add(Long.valueOf(id));
        }
        List routeTaskList = this.ptmService.getProjectCardRouteTasks(projectIdList, activityPass);
        ArrayList<ActivityDataDTO> result = new ArrayList<ActivityDataDTO>();
        routeTaskList.forEach(rt -> {
            PtmProjectRecordDTO projectRecord = this.ptmService.getProjectRecord(rt.getProjectId());
            ActivityDataDTO data = new ActivityDataDTO();
            data.setTaskId(rt.getProjectId());
            data.setTmTaskId(projectRecord.getProjectDefCode());
            data.setTmActivityId(rt.getTaskDefCode());
            data.setTenantId(rt.getTenantId());
            data.setBpmActivitySqlId(rt.getId());
            data.setBpmData(JsonUtils.objectToString((Object)rt.getData()));
            data.setBpmStateData(null);
            data.setBpmActivityId(null);
            data.setBpmActivityType(rt.getBpmnType());
            data.setPerformerIds(null);
            data.setProcessSerialNumber(projectRecord.getProcessSerialNumber());
            data.setTmActivityName(null);
            data.setTmPattern(rt.getTaskDefPattern());
            data.setTmCategory(rt.getTaskDefCategory());
            data.setBacklogName(null);
            data.setStartTime(rt.getCreateTime());
            data.setPlanEndTime(rt.getPlanEndTime());
            data.setEndTime(rt.getClosedTime());
            data.setWorkitemList(JsonUtils.objectToString((Object)rt.getBacklogs()));
            data.setChargeId(projectRecord.getPersonInCharge());
            data.setChargeName(projectRecord.getPersonInChargeName());
            data.setBusinessUnit(projectRecord.getBusinessUnit() == null ? null : JsonUtils.objectToString((Object)projectRecord.getBusinessUnit()));
            data.setEocName(projectRecord.getEocName());
            data.setTaskStartTime(projectRecord.getStartTime());
            data.setTaskEndTime(projectRecord.getEndTime());
            data.setProcessCreateTime(projectRecord.getCreateTime());
            data.setTaskName(rt.getTaskName());
            data.setTmShowFlow(Boolean.valueOf(false));
            data.setStepId(rt.getActivityId());
            data.setTaskSourceIds(projectRecord.getSourceIds());
            data.setStepSignReason(null);
            data.setApprovalState(null);
            data.setBacklogClosed(Boolean.valueOf(rt.getState() == 3));
            data.setMerge(Boolean.valueOf(false));
            data.setProxyToken(projectRecord.getProxyToken());
            data.setCompositionId(null);
            data.setOverdueWorkitemId(null);
            data.setPreTaskUid(rt.getPreTaskUid());
            data.setPrePerformerId(null);
            data.setPrePerformerName(null);
            data.setPreAgentPerformerId(null);
            data.setPreAgentPerformerName(null);
            data.setPrePerformerType(null);
            data.setStepState(null);
            data.setStepSubState(null);
            data.setTraceId(projectRecord.getTraceId());
            if (CollectionUtils.isNotEmpty((Collection)rt.getBacklogs())) {
                rt.getBacklogs().forEach(bl -> {
                    if (!Objects.equals(bl.getType(), 2)) {
                        EocEmployeeDTO eocEmployeeDTO = this.eocService.getEmployeeByUserId(bl.getPerformerId());
                        ActivityDataDTO data1 = (ActivityDataDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)data), ActivityDataDTO.class);
                        data1.setBacklogId(bl.getId());
                        data1.setPerformerId(bl.getPerformerId());
                        data1.setPerformerName(bl.getPerformerName());
                        data1.setPerformerState(eocEmployeeDTO.getStatus());
                        data1.setWorkItemId(bl.getWorkItemKey());
                        result.add(data1);
                    }
                });
            } else {
                result.add(data);
            }
        });
        return result;
    }

    public Task getTask(Long projectCardId) {
        if (!this.enablePTM()) {
            return null;
        }
        PtmProjectCardDetailDTO projectCardDetailDTO = this.ptmService.getProjectCardDetail(projectCardId);
        if (projectCardDetailDTO != null) {
            Task task = Task.builder().id(projectCardDetailDTO.getId()).mainTaskId(projectCardDetailDTO.getId()).name(projectCardDetailDTO.getProjectCardName()).startTime(projectCardDetailDTO.getStartTime()).endTime(projectCardDetailDTO.getEndTime()).personInCharge(projectCardDetailDTO.getPersonInCharge()).personInChargeName(projectCardDetailDTO.getPersonInChargeName()).tmTaskId(projectCardDetailDTO.getProjectDefCode()).build();
            return task;
        }
        return null;
    }

    public List<BpmProcess> getProjectByProjectCardId(Long projectCardId) {
        ArrayList<BpmProcess> result = new ArrayList<BpmProcess>();
        if (!this.enablePTM()) {
            return result;
        }
        PtmProjectCardDetailDTO projectCardDetailDTO = this.ptmService.getProjectCardDetail(projectCardId);
        if (projectCardDetailDTO != null && CollectionUtils.isNotEmpty((Collection)projectCardDetailDTO.getProjects())) {
            projectCardDetailDTO.getProjects().forEach(p -> {
                PtmProjectRecordDTO ptmProjectRecord = this.ptmService.getProjectRecord(p.getProjectId());
                BpmProcess bpmProcess = BpmProcess.builder().processSerialNumber(ptmProjectRecord.getProcessSerialNumber()).data(JSONObject.fromObject((Object)ptmProjectRecord.getData())).businessUnit(JSONObject.fromObject((Object)ptmProjectRecord.getBusinessUnit())).proxyToken(ptmProjectRecord.getProxyToken()).build();
                result.add(bpmProcess);
            });
        }
        return result;
    }

    public BpmActivityWorkitem getReapprovalInfoById(long backlogId) {
        BpmActivityWorkitem result = null;
        if (!this.enablePTM()) {
            return result;
        }
        PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(Long.valueOf(backlogId)));
        if (ptmBacklog == null) {
            return result;
        }
        PtmWorkItemRecordDTO ptmWorkItemRecord = null;
        PtmTaskRecordDTO ptmTaskRecordDTO = this.ptmService.getTaskRecord(ptmBacklog.getTaskId());
        if (Objects.isNull(ptmTaskRecordDTO)) {
            throw ErrorCodeEnum.PTM_QUERY_PTM_GET_TASK_RECORD.getBusinessExceptionWithArgs(new Object[]{ptmBacklog.getTaskId()});
        }
        if (SummaryMessagesUtils.isApprovalTask(ptmTaskRecordDTO.getTaskDefPattern(), ptmTaskRecordDTO.getTaskDefCategory()).booleanValue()) {
            ptmWorkItemRecord = this.ptmService.getReExecuteWorkItem(Integer.valueOf(0), ptmBacklog.getWorkItemId(), ptmTaskRecordDTO.getTaskDefCode());
        } else {
            PtmProjectCard projectCard = (PtmProjectCard)((Object)this.ptmProjectCardMapper.selectById(ptmBacklog.getProjectCardId()));
            if (Objects.isNull((Object)projectCard)) {
                throw ErrorCodeEnum.PTM_QUERY_PTM_PROJECT_CARD_RETURN_EMPTY.getBusinessExceptionWithArgs(new Object[]{ptmBacklog.getProjectCardId()});
            }
            String targetApproveActivity = this.themeMapService.getActivityTargetCode(projectCard.getProjectCode(), ptmTaskRecordDTO.getTaskDefCode(), TmPageName.TASK_CARD_NAME.getValue());
            ptmWorkItemRecord = this.ptmService.getReExecuteWorkItem(Integer.valueOf(1), ptmBacklog.getWorkItemId(), targetApproveActivity);
        }
        if (ptmWorkItemRecord != null) {
            result = BpmActivityWorkitem.builder().performerName(ptmWorkItemRecord.getPerformerName()).closedTime(ptmWorkItemRecord.getClosedTime()).comment(ptmWorkItemRecord.getComment()).state(ptmWorkItemRecord.getState()).subState(ptmWorkItemRecord.getSubState()).groupId(0L).build();
        }
        return result;
    }

    public String getExecuteComment(Long backlogId) {
        if (!this.enablePTM()) {
            return null;
        }
        BpmActivityWorkitem bpmActivityWorkitem = this.getReapprovalInfoById(backlogId);
        if (bpmActivityWorkitem != null && StringUtils.isNotBlank((String)bpmActivityWorkitem.getComment())) {
            return bpmActivityWorkitem.getComment();
        }
        return null;
    }

    public Backlog translateBacklogById(Long backlogId) {
        if (!this.enablePTM()) {
            return null;
        }
        PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(backlogId));
        if (ptmBacklog != null) {
            Backlog backlog = Backlog.builder().id(ptmBacklog.getBacklogId()).name(ptmBacklog.getTaskName()).endTime(ptmBacklog.getPlanEndTime()).startTime(ptmBacklog.getCreateTime()).performerId(ptmBacklog.getPerformerId()).importance(ptmBacklog.getFavorite()).content(ptmBacklog.getTaskDefName()).activityCode(ptmBacklog.getTaskDefCode()).build();
            return backlog;
        }
        return null;
    }
}

