/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BKUtils.class);
    private static final String KEY_VALUE_SPLIT = ":";
    private static final String INDEX_STR = "index";

    private BKUtils() {
    }

    public static TreeMap sortMap(Map map) {
        TreeMap treeMap = new TreeMap();
        map.forEach((k, v) -> treeMap.put(k, v));
        return treeMap;
    }

    public static TreeMap recursionToTreeMap(Map<String, Object> map) {
        TreeMap<String, Object> tempTreeMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                tempTreeMap.put(entry.getKey(), BKUtils.sortMap((Map)entry.getValue()));
                continue;
            }
            tempTreeMap.put(entry.getKey(), entry.getValue());
        }
        return tempTreeMap;
    }

    public static List<Map<String, Object>> convertBkIndex(Map<String, Object> bkObject) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!MapUtils.isEmpty(bkObject)) {
            for (Map.Entry<String, Object> entry : bkObject.entrySet()) {
                if (entry.getValue() instanceof Collection || entry.getValue() instanceof Map) continue;
                HashMap<String, String> tempMap = new HashMap<String, String>(1);
                tempMap.put(INDEX_STR, entry.getKey() + KEY_VALUE_SPLIT + entry.getValue());
                list.add(tempMap);
            }
        }
        return list;
    }

    public static List<Map<String, Object>> convertBkIndexSimple(Object object) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (null != object) {
            HashMap<String, String> tempMap = new HashMap<String, String>(1);
            tempMap.put(INDEX_STR, String.valueOf(object));
            list.add(tempMap);
        }
        return list;
    }

    public static boolean checkJsonStr(String jsonStr) {
        if (jsonStr.startsWith("{") && jsonStr.endsWith("}")) {
            try {
                JSONObject.fromObject((Object)jsonStr);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("string :{}is not json", (Object)jsonStr, (Object)e);
                return false;
            }
        }
        return false;
    }

    public static List<String> bkObjectToIndex(Map<String, Object> param) {
        if (param.isEmpty()) {
            LOGGER.warn("bk object is empty with initial param:{}", param);
            return Collections.emptyList();
        }
        ArrayList<String> indexList = new ArrayList<String>();
        param.forEach((key, value) -> indexList.add(key + KEY_VALUE_SPLIT + value));
        return indexList;
    }

    public static List<List<String>> bkObjectToIndexList(List<Map> bkList) {
        if (null == bkList || bkList.isEmpty()) {
            LOGGER.warn("bk object list is empty with initial param:{}", bkList);
            return Collections.emptyList();
        }
        ArrayList<List<String>> bkIndexList = new ArrayList<List<String>>();
        for (Map map : bkList) {
            List<String> tempList = BKUtils.bkObjectToIndex(map);
            if (tempList.isEmpty()) continue;
            bkIndexList.add(tempList);
        }
        return bkIndexList;
    }
}

