/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.bk.parser.event;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.bk.parser.event.IEvent;
import java.util.Map;
import net.sf.json.JSONObject;

public class TaskEvent
implements IEvent {
    private static final String MESSAGE_DATA = "messageData";
    private static final String BUSINESS_UNIT = "businessUnit";
    private static final String EOC_COMPANY_ID = "eoc_company_id";
    private static final String EOC_SITE_ID = "eoc_site_id";
    private static final String TENANT_ID = "tenantId";
    private static final String ACTIVITY_ID = "activityId";
    private static final String ACTIVITY_TEMPLATE_ID = "activityTemplateId";
    private static final String SUB_TASK_ID = "subTaskId";
    private static final String SUB_TASK_TEMPLATE_ID = "subTaskTemplateId";
    private static final String STATE = "state";
    public static final String PROCESS_VAR = "processVar";
    public static final String TASK_TYPE = "activity";
    public static final String SUB_TASK_TYPE = "task";
    public static final String TYPE = "type";
    public static final int TASK_FINISH = 3;
    public static final int TASK_CREATE = 0;
    private String companyId;
    private String siteId;
    private String tenantId;
    private JSONObject bkData;
    private String instanceId;
    private String tempId;
    private Integer state;
    private String type;
    private String projectId;

    public TaskEvent(JSONObject msgObj) {
        this.constructEvent(msgObj);
    }

    private void constructEvent(JSONObject msgObj) {
        JSONObject messageData = msgObj.getJSONObject(MESSAGE_DATA);
        if (CollectionUtils.isNotEmpty((Map)messageData.getJSONObject(BUSINESS_UNIT))) {
            if (messageData.getJSONObject(BUSINESS_UNIT).containsKey((Object)EOC_COMPANY_ID)) {
                this.companyId = messageData.getJSONObject(BUSINESS_UNIT).getString(EOC_COMPANY_ID);
            }
            if (messageData.getJSONObject(BUSINESS_UNIT).containsKey((Object)EOC_SITE_ID)) {
                this.siteId = messageData.getJSONObject(BUSINESS_UNIT).getString(EOC_SITE_ID);
            }
        }
        this.bkData = messageData;
        this.tenantId = msgObj.getString(TENANT_ID);
        this.state = msgObj.getInt(STATE);
        this.type = msgObj.getString(TYPE);
        if (TASK_TYPE.equalsIgnoreCase(this.type)) {
            this.instanceId = msgObj.getString(ACTIVITY_ID);
            this.tempId = msgObj.getString(ACTIVITY_TEMPLATE_ID);
            this.projectId = msgObj.getString(SUB_TASK_ID);
        } else {
            this.instanceId = msgObj.getString(SUB_TASK_ID);
            this.tempId = msgObj.getString(SUB_TASK_TEMPLATE_ID);
        }
    }

    public String toString() {
        return JsonUtils.objectToString((Object)this);
    }

    public static void main(String[] args) {
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public JSONObject getBkData() {
        return this.bkData;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getTempId() {
        return this.tempId;
    }

    public Integer getState() {
        return this.state;
    }

    public String getType() {
        return this.type;
    }

    public String getProjectId() {
        return this.projectId;
    }
}

