/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.bk.parser.metadata;

import com.digiwin.athena.atmc.common.bk.parser.dto.BkNode;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.MetadataUnit;
import com.digiwin.athena.atmc.common.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class AbstractBkMetadataParser {
    public static MetadataUnit constructMetadata(JSONObject metaObj, String rootName) {
        String entityName = metaObj.getString("entity_name");
        String source = "";
        if (metaObj.containsKey((Object)source)) {
            source = metaObj.getString("source");
        }
        JSONArray bks = metaObj.getJSONArray("bk");
        boolean isRoot = false;
        LinkedHashMap<String, BkNode> bkFields = new LinkedHashMap<String, BkNode>(8);
        for (Object bk : bks) {
            JSONObject tempBk = (JSONObject)bk;
            if ("object".equals(tempBk.getString("data_type"))) {
                String parentPath = tempBk.getString("data_name") + ".";
                JSONArray fieldBks = tempBk.getJSONArray("field");
                fieldBks.forEach(fieldBk -> AbstractBkMetadataParser.recursion((JSONObject)fieldBk, bkFields, parentPath, tempBk.getBoolean("is_array")));
            }
            if ("object".equals(tempBk.getString("data_type"))) continue;
            String bkName = null;
            if (tempBk.containsKey((Object)"bk_name")) {
                bkName = tempBk.getString("bk_name");
            }
            bkName = StringUtil.isBlank(bkName) ? tempBk.getString("data_name") : tempBk.getString("bk_name");
            bkFields.put(bkName, new BkNode(bkName, rootName, bkName, tempBk.getBoolean("is_array")));
            isRoot = true;
        }
        return new MetadataUnit(source, entityName, bkFields, isRoot);
    }

    private static void recursion(JSONObject tempBk, Map<String, BkNode> bkFields, String parentPath, boolean parentIsArray) {
        if ("object".equals(tempBk.getString("data_type"))) {
            String tempParentPath = parentPath + tempBk.getString("data_name") + ".";
            JSONArray fieldBks = tempBk.getJSONArray("field");
            fieldBks.forEach(fieldBk -> AbstractBkMetadataParser.recursion((JSONObject)fieldBk, bkFields, tempParentPath, tempBk.getBoolean("is_array")));
        }
        if (!"object".equals(tempBk.getString("data_type"))) {
            String bkName = null;
            if (tempBk.containsKey((Object)"bk_name")) {
                bkName = tempBk.getString("bk_name");
            }
            bkName = StringUtil.isBlank(bkName) ? tempBk.getString("data_name") : tempBk.getString("bk_name");
            String nodePath = parentPath + tempBk.getString("data_name");
            String parentRealPath = parentPath.substring(0, parentPath.length() - 1);
            bkFields.put(bkName, new BkNode(bkName, parentRealPath, nodePath, parentIsArray));
        }
    }
}

