/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.domain;

public class DapResponse<T> {
    private Integer duration;
    private String statusDescription;
    private T response;
    private String uuid;
    private Integer status;
    private String errorMessage;

    public static DapResponse ok() {
        return DapResponse.builder().status(200).build();
    }

    public static <T> DapResponse ok(T data) {
        return DapResponse.builder().status(200).response(data).build();
    }

    public static DapResponse failed(String msg) {
        return DapResponse.builder().status(500).statusDescription(msg).build();
    }

    public static <T> DapResponseBuilder<T> builder() {
        return new DapResponseBuilder();
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public T getResponse() {
        return this.response;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DapResponse)) {
            return false;
        }
        DapResponse other = (DapResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        String this$statusDescription = this.getStatusDescription();
        String other$statusDescription = other.getStatusDescription();
        if (this$statusDescription == null ? other$statusDescription != null : !this$statusDescription.equals(other$statusDescription)) {
            return false;
        }
        T this$response = this.getResponse();
        T other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DapResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        String $statusDescription = this.getStatusDescription();
        result = result * 59 + ($statusDescription == null ? 43 : $statusDescription.hashCode());
        T $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "DapResponse(duration=" + this.getDuration() + ", statusDescription=" + this.getStatusDescription() + ", response=" + this.getResponse() + ", uuid=" + this.getUuid() + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public DapResponse(Integer duration, String statusDescription, T response, String uuid, Integer status, String errorMessage) {
        this.duration = duration;
        this.statusDescription = statusDescription;
        this.response = response;
        this.uuid = uuid;
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public DapResponse() {
    }

    public static class DapResponseBuilder<T> {
        private Integer duration;
        private String statusDescription;
        private T response;
        private String uuid;
        private Integer status;
        private String errorMessage;

        DapResponseBuilder() {
        }

        public DapResponseBuilder<T> duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public DapResponseBuilder<T> statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public DapResponseBuilder<T> response(T response) {
            this.response = response;
            return this;
        }

        public DapResponseBuilder<T> uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public DapResponseBuilder<T> status(Integer status) {
            this.status = status;
            return this;
        }

        public DapResponseBuilder<T> errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public DapResponse<T> build() {
            return new DapResponse<T>(this.duration, this.statusDescription, this.response, this.uuid, this.status, this.errorMessage);
        }

        public String toString() {
            return "DapResponse.DapResponseBuilder(duration=" + this.duration + ", statusDescription=" + this.statusDescription + ", response=" + this.response + ", uuid=" + this.uuid + ", status=" + this.status + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

