/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.domain.backlog;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnRuleDTO {
    private String taskDefCode;
    private List<Rule> columns;

    public List<ColumnRuleDTO> buildColumnRuleDTOList(Object obj, String locale) {
        try {
            JSONArray jsonArray = JSONUtil.parseArray((Object)obj);
            List columnRuleDTOS = JSONUtil.toList((JSONArray)jsonArray, ColumnRuleDTO.class);
            columnRuleDTOS.forEach(e -> e.getColumns().stream().forEach(p -> this.dealLang((Rule)p, locale)));
            return columnRuleDTOS;
        }
        catch (ClassCastException e2) {
            return new ArrayList<ColumnRuleDTO>();
        }
    }

    public void removeSystemKey(List<ColumnRuleDTO> list) {
        for (ColumnRuleDTO next : list) {
            next.getColumns().removeIf(next1 -> !"businessKey".equals(next1.getType()));
        }
    }

    private void dealLang(Rule rule, String locale) {
        String name = (String)((Map)rule.getLang().get("name")).get(locale);
        rule.setName(name);
        rule.setLang(null);
        rule.setLanguage(null);
    }

    public String getTaskDefCode() {
        return this.taskDefCode;
    }

    public void setTaskDefCode(String taskDefCode) {
        this.taskDefCode = taskDefCode;
    }

    public List<Rule> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Rule> columns) {
        this.columns = columns;
    }

    private class Rule {
        private String key;
        private String name;
        private String order;
        private String isShow;
        private Map language;
        private Map lang;
        private String type;

        private Rule() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getIsShow() {
            return this.isShow;
        }

        public void setIsShow(String isShow) {
            this.isShow = isShow;
        }

        public Map getLanguage() {
            return this.language;
        }

        public void setLanguage(Map language) {
            this.language = language;
        }

        public Map getLang() {
            return this.lang;
        }

        public void setLang(Map lang) {
            this.lang = lang;
        }
    }
}

