/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.mongodb.impl;

import com.digiwin.athena.atmc.common.mongodb.MongoDbQueryService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MongoDbQueryServiceImpl
implements MongoDbQueryService {
    private static final Logger log = LoggerFactory.getLogger(MongoDbQueryServiceImpl.class);

    @Override
    public Map getExecuteQueryCommand(String collectionName, Map filterMap) {
        return this.getExecuteQueryCommand(collectionName, filterMap, null);
    }

    @Override
    public Map getExecuteQueryCommand(String collectionName, Map filterMap, Map projectionMap) {
        LinkedHashMap<String, Object> command = new LinkedHashMap<String, Object>();
        command.put("find", collectionName);
        if (filterMap != null && !filterMap.isEmpty()) {
            command.put("filter", filterMap);
        }
        if (projectionMap != null && !projectionMap.isEmpty()) {
            command.put("projection", projectionMap);
        }
        command.put("batchSize", 10000);
        command.put("singleBatch", true);
        return command;
    }

    @Override
    public Map tileMap(String prefix, Map oldMap) {
        HashMap newMap = new HashMap();
        this.tileMap(prefix, oldMap, newMap);
        return newMap;
    }

    private void tileMap(String prefix, Map oldMap, Map newMap) {
        for (Object o : oldMap.keySet()) {
            if (oldMap.get(o) instanceof Map) {
                this.tileMap(prefix + "." + o.toString(), (Map)oldMap.get(o), newMap);
                continue;
            }
            newMap.put(prefix + "." + o.toString(), oldMap.get(o));
        }
    }
}

