/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.application.service.query.commontype.CardPresentConfigQryService;
import com.digiwin.athena.atmc.common.dao.BpmActivityMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.dao.TaskWorkitemMessageMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivity;
import com.digiwin.athena.atmc.common.domain.TaskWorkitemMessage;
import com.digiwin.athena.atmc.common.domain.backlog.ReplyTaskMessageDTO;
import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.mock.MockData;
import com.digiwin.athena.atmc.common.service.backlog.BpmBacklogActionCreateService;
import com.digiwin.athena.atmc.common.service.bpmworkitemappendix.BpmWorkitemAppendixService;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.common.util.ActivityUtils;
import com.digiwin.athena.atmc.common.util.ManualTaskUtil;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActionDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActionParameterDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmReasonDTO;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.Backlog;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class BpmCommonBacklogAbstractService {
    private static final Logger log = LoggerFactory.getLogger(BpmCommonBacklogAbstractService.class);
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AglieService aglieService;
    @Autowired
    private BpmBacklogActionCreateService bpmBacklogActionCreateService;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private BpmActivityMapper bpmActivityMapper;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    TaskWorkitemMessageMapper taskWorkitemMessageMapper;
    private static final String SUMMARY_LAYOUT_STR = "summaryLayoutStr";
    private static final String BACKLOG_OVERDUE_TASK_MSG = "backlog.overdue.task.msg";
    public static final String PTM_BACKLOG = "ptmBacklog";
    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;

    public TmActivityResponseDTO getTaskCardPageDefineByWorkItemId(long workItemId) {
        BacklogBO backlogBO = this.backlogMapper.selectBacklogForCard(workItemId);
        if (null == backlogBO) {
            backlogBO = this.commonPtmTransformService.selectBacklogForCard(workItemId);
            if (null == backlogBO) {
                return null;
            }
            backlogBO.setDataFrom("PTM");
        }
        if ("__uibot__".equals(backlogBO.getTmTaskId())) {
            String tmActivityId;
            String bpmData = backlogBO.getBpmData();
            if (StringUtils.isEmpty((String)bpmData)) {
                return null;
            }
            JSONObject bpmDataObj = JSONObject.fromObject((Object)bpmData);
            if (!bpmDataObj.containsKey((Object)"taskCode") && !bpmDataObj.containsKey((Object)"tmActivityId")) {
                return null;
            }
            String string = tmActivityId = StringUtils.isEmpty((String)bpmDataObj.getString("taskCode")) ? bpmDataObj.getString("tmActivityId") : bpmDataObj.getString("taskCode");
            if ("uibotManualTask".equals(tmActivityId)) {
                return null;
            }
            backlogBO.setCalendar(Boolean.valueOf(true));
            backlogBO.setTmActivityId(tmActivityId);
        }
        if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0L) {
            backlogBO.setTmTaskId("__uibot__");
            backlogBO.setTmActivityId("uibot_overdue_task");
        }
        return this.themeMapService.getActivityAction(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
    }

    @MockData(type="detail")
    public Map getBacklogCardAbstractById(long workItemId, AuthoredUser user, boolean needHistoryInfo) {
        boolean isApproval;
        BacklogBO backlogBO = this.backlogMapper.selectBacklogForCard(workItemId);
        if (null == backlogBO) {
            backlogBO = this.commonPtmTransformService.selectBacklogForCard(workItemId);
            backlogBO.setDataFrom("PTM");
        }
        if ("__uibot__".equals(backlogBO.getTmTaskId())) {
            String tmActivityId;
            boolean hasTmActivityId;
            String bpmData = backlogBO.getBpmData();
            if (StringUtils.isEmpty((String)bpmData)) {
                return Collections.emptyMap();
            }
            JSONObject bpmDataObj = JSONObject.fromObject((Object)bpmData);
            boolean hasTaskCode = bpmDataObj.containsKey((Object)"taskCode") && !StringUtils.isEmpty((String)bpmDataObj.getString("taskCode"));
            boolean bl = hasTmActivityId = bpmDataObj.containsKey((Object)"tmActivityId") && !StringUtils.isEmpty((String)bpmDataObj.getString("tmActivityId"));
            if (!hasTaskCode && !hasTmActivityId) {
                return Collections.emptyMap();
            }
            String string = tmActivityId = StringUtils.isEmpty((String)bpmDataObj.getString("taskCode")) ? bpmDataObj.getString("tmActivityId") : bpmDataObj.getString("taskCode");
            if ("uibotManualTask".equals(tmActivityId)) {
                return Collections.emptyMap();
            }
            backlogBO.setCalendar(Boolean.valueOf(true));
            backlogBO.setTmActivityId(tmActivityId);
        }
        HashMap<String, String> checkItems_map = new HashMap<String, String>();
        if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0L) {
            backlogBO.setName("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}");
            backlogBO.setTmTaskId("__uibot__");
            backlogBO.setTmActivityId("uibot_overdue_task");
            backlogBO.setTmPattern("UIBOT");
            backlogBO.setTmCategory("UIBOT");
            Backlog originalBacklog = this.getOriginalBacklog(backlogBO.getOverdueWorkitemId());
            ArrayList<HashMap<String, String>> checkItems = new ArrayList<HashMap<String, String>>();
            backlogBO.setCheckItems(checkItems);
            checkItems_map.put("item", this.messageUtils.getMessageWithFormat(BACKLOG_OVERDUE_TASK_MSG, new Object[]{MessageUtils.getMessageByCurrentLanguage((Object)originalBacklog.getName()), TimeUtils.dateInterval((LocalDateTime)originalBacklog.getEndTime(), (LocalDateTime)LocalDateTime.now())}));
            checkItems.add(checkItems_map);
            backlogBO.setOperation(MessageUtils.getMessageByCurrentLanguage((Object)"{\"zh_TW\":\"\u8acb\u9078\u64c7\u8655\u7406\u65b9\u6848\",\"en_US\":\"Please choose a solution\",\"zh_CN\":\"\u8bf7\u9009\u62e9\u5904\u7406\u65b9\u6848\"}"));
        }
        if (GlobalConstant.DATA_UNIFORMITY_BACKLOG_TYPE.equals(backlogBO.getType())) {
            backlogBO.setName("{\"zh_TW\":\"\u696d\u52d9\u6578\u64da\u4e0d\u4e00\u81f4\u7570\u5e38\u6392\u9664\",\"en_US\":\"Abnormal Exclude\",\"zh_CN\":\"\u4e1a\u52a1\u6570\u636e\u4e0d\u4e00\u81f4\u5f02\u5e38\u6392\u9664\"}");
        }
        this.setCheckItems(user, backlogBO);
        Map summaryLayoutStr = this.setSummaryLayoutStr(user, backlogBO, needHistoryInfo);
        String reapprovalInfoComment = "";
        boolean isAbnormal = org.springframework.util.StringUtils.pathEquals((String)TmTaskPatternEnum.BUSINESS.getValue(), (String)backlogBO.getTmPattern()) && org.springframework.util.StringUtils.pathEquals((String)TmTaskCategoryEnum.SOLVE.getValue(), (String)backlogBO.getTmCategory());
        String targetApproveActivity = this.themeMapService.getActivityTargetCode(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
        boolean bl = isApproval = Objects.equals(backlogBO.getTmPattern(), TmTaskPatternEnum.BUSINESS.getValue()) && Objects.equals(backlogBO.getTmCategory(), TmTaskCategoryEnum.APPROVAL.getValue());
        if (!(isAbnormal || StringUtils.isEmpty((String)targetApproveActivity) && !isApproval)) {
            BpmActivityWorkitem bpmWorkitem = this.bpmActivityWorkitemMapper.selectReapprovalInfoById(workItemId);
            if (bpmWorkitem != null) {
                reapprovalInfoComment = this.messageUtils.getMessage("reapproval.info.comment") + bpmWorkitem.getComment();
            } else {
                String comment = this.commonPtmTransformService.getExecuteComment(workItemId);
                if (!StringUtils.isEmpty((String)comment)) {
                    reapprovalInfoComment = this.messageUtils.getMessage("reapproval.info.comment") + comment;
                }
            }
        }
        HashMap checkItemsMap = new HashMap();
        if (summaryLayoutStr != null) {
            if (summaryLayoutStr.containsKey(SUMMARY_LAYOUT_STR) && !StringUtils.isEmpty((String)summaryLayoutStr.get(SUMMARY_LAYOUT_STR).toString())) {
                if (!StringUtils.isEmpty((String)reapprovalInfoComment)) {
                    String summaryLayout = reapprovalInfoComment + "<br>" + summaryLayoutStr.get(SUMMARY_LAYOUT_STR).toString();
                    summaryLayoutStr.put(SUMMARY_LAYOUT_STR, summaryLayout);
                }
            } else {
                summaryLayoutStr.put(SUMMARY_LAYOUT_STR, reapprovalInfoComment);
            }
            checkItemsMap.put("summaryLayout", summaryLayoutStr.get(SUMMARY_LAYOUT_STR));
            checkItemsMap.put("historyMessage", summaryLayoutStr.get("historyMessage"));
            checkItemsMap.put("searchMessage", summaryLayoutStr.get("searchMessage"));
            checkItemsMap.put("cardState", summaryLayoutStr.get("cardState"));
        } else if (!StringUtils.isEmpty((String)reapprovalInfoComment)) {
            checkItemsMap.put("summaryLayout", reapprovalInfoComment);
        }
        String checkItemsStr = "";
        if (backlogBO.getCheckItems() != null) {
            int value_i;
            checkItemsStr = ((Map)backlogBO.getCheckItems().get(0)).get("item").toString();
            if (((Map)backlogBO.getCheckItems().get(0)).get("value") != null && (value_i = Integer.parseInt(((Map)backlogBO.getCheckItems().get(0)).get("value").toString())) != 0) {
                checkItemsStr = checkItemsStr + ((Map)backlogBO.getCheckItems().get(0)).get("value").toString();
            }
            checkItemsMap.put("checkItems", checkItemsStr);
        }
        if (backlogBO.getOperation() != null) {
            String operationStr = backlogBO.getOperation();
            checkItemsMap.put("operation", operationStr);
        }
        if (!CollectionUtils.isEmpty((Collection)backlogBO.getTodoItems())) {
            String todoItemStr = ((Map)backlogBO.getTodoItems().get(0)).get("item").toString();
            checkItemsMap.put("todoItems", todoItemStr);
        }
        if (backlogBO.getError() != null) {
            checkItemsMap.put("error", backlogBO.getError().get("error").toString());
        }
        this.cardPresentConfigQryService.setCardPresentConfigs(checkItemsMap, TmPageName.TASK_CARD_NAME.getValue());
        return checkItemsMap;
    }

    private Map setSummaryLayoutStr(AuthoredUser authoredUserm, BacklogBO backlogBO, boolean needHistoryInfo) {
        Map<String, Object> activityData;
        Map<String, Object> activityDataMap = activityData = this.bpmBacklogActionCreateService.getEditActions(authoredUserm, backlogBO.getId(), null);
        activityDataMap.put("needHistoryInfo", needHistoryInfo);
        activityDataMap.put("calendar", backlogBO.getCalendar());
        List tasks = (List)activityDataMap.get("tasks");
        try {
            ReplyTaskMessageDTO message;
            Map task;
            BaseResultDTO actionResponse = this.aglieService.getTaskCardAbstractStr(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(), backlogBO.getId(), activityDataMap, null, null);
            HashMap<String, String> pageDataMap = (HashMap<String, String>)actionResponse.getResponse();
            if (pageDataMap == null) {
                pageDataMap = new HashMap<String, String>();
            }
            if (!CollectionUtils.isEmpty((Collection)tasks) && (task = (Map)tasks.get(0)).containsKey("replyInvite") && (message = this.bpmWorkitemAppendixService.getReplyTaskMessage(backlogBO.getId())) != null && !Objects.equals(message.getCode(), WorkitemAppendixType.ReSend.getValue())) {
                pageDataMap.put(SUMMARY_LAYOUT_STR, message.getMessage());
            }
            return pageDataMap;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getMessage());
            backlogBO.setError(error);
            return null;
        }
    }

    public Backlog getOriginalBacklog(Long overdueWorkitemId) {
        BpmActivityWorkitem originalWorkitem = (BpmActivityWorkitem)this.bpmActivityWorkitemMapper.selectById(overdueWorkitemId);
        if (originalWorkitem != null) {
            Backlog backlog = this.backlogMapper.selectFirstByActivityStepId(originalWorkitem.getActivityStepId());
            return backlog;
        }
        return this.commonPtmTransformService.translateBacklogById(overdueWorkitemId);
    }

    public void setCheckItems(AuthoredUser authoredUser, BacklogBO backlogBO) {
        if (Objects.equals("UIBOT", backlogBO.getTmPattern()) && Objects.equals("UIBOT", backlogBO.getTmCategory())) {
            return;
        }
        String tmTaskId = backlogBO.getTmTaskId();
        TmActivityResponseDTO themeActivity = this.themeMapService.getActivityAction(tmTaskId, backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
        backlogBO.setSubName(themeActivity.getStartApproveActivityName());
        if (Objects.equals("MECHANISM", backlogBO.getTmPattern()) && Objects.equals("SUGGESTION", backlogBO.getTmCategory())) {
            this.setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        if (Objects.equals("MECHANISM", backlogBO.getTmPattern()) && Objects.equals("APPROVAL", backlogBO.getTmCategory())) {
            this.setMechanismAppovalCheckItems(backlogBO, themeActivity);
            return;
        }
        if (Objects.equals("ADJUSTMENT", backlogBO.getTmPattern()) && Objects.equals("ADJUSTMENT", backlogBO.getTmCategory())) {
            this.setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        if (Objects.equals("MECHANISM", backlogBO.getTmPattern()) && Objects.equals("POSITIONSUGGESTION", backlogBO.getTmCategory())) {
            this.setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        if (Objects.equals("MECHANISM", backlogBO.getTmPattern()) && Objects.equals("POSITIONAPPROVAL", backlogBO.getTmCategory())) {
            this.setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }
        boolean needCountData = true;
        if (themeActivity.hasCheckItems()) {
            backlogBO.setCheckItems(ActivityUtils.getCheckItemsResult(themeActivity.getCheckItems(), 0));
            needCountData = false;
        }
        if (themeActivity.hasOperations()) {
            Optional tmOperation = themeActivity.getPages().getOperations().stream().findFirst();
            tmOperation.ifPresent(tmOperationDTO -> backlogBO.setOperation(tmOperationDTO.getDescription()));
            needCountData = false;
        }
        if (themeActivity.existSummaryFields()) {
            needCountData = false;
        }
        if (needCountData) {
            this.setTodo(authoredUser, backlogBO);
        }
        backlogBO.setBpmActivityId(null);
    }

    public void setReasonToCheckItems(BacklogBO backlogBO, TmActivityResponseDTO tmActivityResponseDTO) {
        if (tmActivityResponseDTO.getPages() == null || tmActivityResponseDTO.getPages().getReason() == null) {
            return;
        }
        TmReasonDTO reasonDTO = tmActivityResponseDTO.getPages().getReason();
        ArrayList checkItems = new ArrayList();
        backlogBO.setCheckItems(checkItems);
        HashMap<String, String> checkItemMap = new HashMap<String, String>();
        checkItemMap.put("item", MessageUtils.getMessageByCurrentLanguage((Object)reasonDTO.getTitle()));
        checkItems.add(checkItemMap);
        if (!"ADJUSTMENT".equals(tmActivityResponseDTO.getPattern()) && reasonDTO.getContent() != null) {
            backlogBO.setOperation(MessageUtils.getMessageByCurrentLanguage((Object)reasonDTO.getContent().getText()));
        }
    }

    public void setMechanismAppovalCheckItems(BacklogBO backlogBO, TmActivityResponseDTO tmActivityResponseDTO) {
        String formulaId;
        Map formulaMap;
        Map dataSources = tmActivityResponseDTO.getDataSources();
        if (MapUtils.isEmpty((Map)dataSources) || !dataSources.containsKey("newFormulaData")) {
            return;
        }
        TmActionDTO newFormulaAction = (TmActionDTO)dataSources.get("newFormulaData");
        List paras = newFormulaAction.getActionParams();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)paras)) {
            return;
        }
        BpmActivity bpmActivity = (BpmActivity)((Object)this.bpmActivityMapper.selectById(backlogBO.getBpmActivityId()));
        if (bpmActivity == null || bpmActivity.getData() == null) {
            return;
        }
        Optional formulaIdNameOption = paras.stream().findFirst();
        String formulaIdName = "";
        if (formulaIdNameOption.isPresent()) {
            formulaIdName = ((TmActionParameterDTO)formulaIdNameOption.get()).getValue();
        }
        if (!(formulaMap = this.themeMapService.executeFormula(formulaId = bpmActivity.getData().getString(formulaIdName))).containsKey("formulaVariables")) {
            return;
        }
        List formulaVariables = (List)formulaMap.get("formulaVariables");
        ArrayList checkItems = new ArrayList();
        backlogBO.setCheckItems(checkItems);
        for (Map m : formulaVariables) {
            HashMap map = new HashMap();
            map.put("item", m.get("name"));
            map.put("value", m.get("value"));
            checkItems.add(map);
        }
    }

    public void setTodo(AuthoredUser authoredUser, BacklogBO backlogBO) {
        if (ManualTaskUtil.isManualTask(backlogBO.getTmTaskId(), backlogBO.getTmActivityId())) {
            return;
        }
        Map<String, Object> activityData = this.bpmBacklogActionCreateService.getEditActions(authoredUser, backlogBO.getId(), null);
        try {
            BaseResultDTO actionResponse = this.aglieService.getTaskCardDataSize(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(), activityData);
            HashMap data = (HashMap)actionResponse.getResponse();
            if (data == null || data.size() == 0 || !data.containsKey("title")) {
                return;
            }
            ArrayList todo = new ArrayList();
            HashMap<String, String> ci = new HashMap<String, String>();
            String langName = this.getLangName(authoredUser.getUserId(), authoredUser.getToken());
            Map<String, Object> activityDataMap = activityData;
            if (activityDataMap.get("type") != null && Integer.parseInt(activityDataMap.get("type").toString()) == 89) {
                ci.put("item", String.format(this.messageUtils.getMessageByLangName("data.uniformity.exception.size", langName), data.get("size")));
            } else {
                String item = MessageFormat.format("{0}{1}{2}", data.get("title"), data.get("size"), this.messageUtils.getMessageByLangName("data.summary.term", langName));
                if (data.containsKey("abnormalSize") && Integer.parseInt(data.get("abnormalSize").toString()) > 0) {
                    item = item + "\uff0c" + String.format(this.messageUtils.getMessageByLangName("data.uniformity.abnormal.size", langName), data.get("abnormalSize"));
                }
                ci.put("item", item);
            }
            todo.add(ci);
            backlogBO.setTodoItems(todo);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getMessage());
            backlogBO.setError(error);
        }
    }

    private String getLangName(String userId, String token) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String locale = httpServletRequest.getHeader("Locale");
        if (StringUtils.isNotBlank((String)locale)) {
            return locale;
        }
        String langName = this.userService.getUserLangMetadataAllTenant(userId, token);
        if (StringUtils.isNotBlank((String)langName)) {
            return langName;
        }
        return "zh_TW";
    }

    public void resetTaskWorkItem(AuthoredUser user, PtmBacklogRecordDTO ptmBacklogRecord, String dataVariableKey) {
        Map<String, Object> activityData;
        Map<String, Object> activityDataMap = activityData = this.bpmBacklogActionCreateService.getEditActions(user, ptmBacklogRecord.getId(), null);
        activityDataMap.put("needHistoryInfo", false);
        activityDataMap.put("calendar", false);
        activityDataMap.put("dataVariableKey", dataVariableKey);
        try {
            BaseResultDTO actionResponse = this.aglieService.getTaskCardLayoutAbstractUpToDate(ptmBacklogRecord.getProjectDefCode(), ptmBacklogRecord.getTaskDefCode(), ptmBacklogRecord.getId(), activityDataMap, null);
            Map pageDataMap = (Map)actionResponse.getResponse();
            String summaryLayout = "";
            String historyMessage = "";
            String searchMessage = "";
            if (MapUtils.isNotEmpty((Map)pageDataMap)) {
                summaryLayout = pageDataMap.get(SUMMARY_LAYOUT_STR).toString();
                historyMessage = pageDataMap.get("historyMessage").toString();
                searchMessage = pageDataMap.get("searchMessage").toString();
            }
            TaskWorkitemMessage taskWorkitemMessage = new TaskWorkitemMessage();
            taskWorkitemMessage.setId(SnowflakeIdWorker.getInstance().newId());
            taskWorkitemMessage.setTenantId(user.getTenantId());
            taskWorkitemMessage.setCardId(ptmBacklogRecord.getId());
            taskWorkitemMessage.setCreateDate(LocalDateTime.now());
            taskWorkitemMessage.setModifyDate(LocalDateTime.now());
            taskWorkitemMessage.setSummary(summaryLayout);
            taskWorkitemMessage.setHistoryMessage(historyMessage);
            taskWorkitemMessage.setSearchMessage(searchMessage);
            taskWorkitemMessage.setCardType(PTM_BACKLOG);
            this.taskWorkitemMessageMapper.insertOrUpdateMessage(taskWorkitemMessage);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ErrorCodeEnum.RESET_TASK_WORKITEM_ERORR.getBusinessException();
        }
    }
}

