/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.bpm;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.domain.bpm.BpmActivityStepDTO;
import com.digiwin.athena.atmc.common.domain.bpm.BpmStepWorkitemDTO;
import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.enums.WorkitemState;
import com.digiwin.athena.atmc.http.restful.cac.CacService;
import com.digiwin.athena.atmc.http.restful.cac.model.AppAuthDTO;
import com.digiwin.athena.atmc.http.restful.iam.BossIamService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamAddUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamCheckUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.InnerExistDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAppDTO;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmActivityService {
    private static final Logger log = LoggerFactory.getLogger(BpmActivityService.class);
    private static String APP_NAME = "athena";
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private BossIamService bossIamService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private CacService cacService;
    @Autowired
    private UserService userService;

    public void closedBackLogByBpmStepId(long bpmStepId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"bpm_activity_step_id", (Object)bpmStepId)).eq((Object)"closed", (Object)0)).select(new String[]{"id,closed"});
        List backlogList = this.backlogMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)backlogList)) {
            this.backlogMapper.batchCloseBacklog(backlogList);
        }
    }

    public void closeSpecialWorkitemByBpmStepId(long bpmStepId) {
        List<BpmActivityWorkitem> workitemList = this.bpmActivityWorkitemMapper.selectSpecialByStepSqlId(bpmStepId);
        for (BpmActivityWorkitem bpmActivityWorkitem : workitemList) {
            if (Objects.equals(bpmActivityWorkitem.getState(), WorkitemState.COMPLETED.getValue()) || this.bpmActivityWorkitemMapper.selectChildCount(bpmActivityWorkitem.getId()) > 0) continue;
            bpmActivityWorkitem.setState(WorkitemState.COMPLETED.getValue());
            bpmActivityWorkitem.setClosedTime(LocalDateTime.now());
            this.bpmActivityWorkitemMapper.updateById(bpmActivityWorkitem);
        }
    }

    public String registerUser(String targetTenantId, String email) {
        try {
            BossIamCheckUserResultDTO checkUserResultDTO = this.bossIamService.checkTenantUser(targetTenantId, APP_NAME, email);
            if (checkUserResultDTO != null && Objects.equals(checkUserResultDTO.getUserExisted(), Boolean.TRUE)) {
                return checkUserResultDTO.getUserId();
            }
            BossIamAddUserResultDTO result = this.bossIamService.addTenantUser(targetTenantId, email, "digiwinAthena", APP_NAME);
            return result.getData().getUserId();
        }
        catch (Exception e) {
            log.warn("\u6ce8\u518c\u4f01\u4e1a\u7528\u6237\u5931\u8d25 {}", (Throwable)e);
            return null;
        }
    }

    public void updateEmailPerformerId(BpmActivityStepDTO activityStepDTO, String commonTenantUserId) {
        if (activityStepDTO == null || CollectionUtils.isEmpty(activityStepDTO.getWorkitemList())) {
            return;
        }
        for (BpmStepWorkitemDTO bpmStepWorkitemDTO : activityStepDTO.getWorkitemList()) {
            if (bpmStepWorkitemDTO.getState() >= WorkitemState.COMPLETED.getValue() || Objects.equals(commonTenantUserId, bpmStepWorkitemDTO.getPerformerId())) continue;
            bpmStepWorkitemDTO.setCommonPerformerId(commonTenantUserId);
        }
    }

    public Map<String, String> getTargetTenantAndUser(AuthoredUser authoredUser, String email, String phone) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Map tenantAuthMap = this.bossIamService.getTenantAuth(authoredUser, email, phone, "Athena", Integer.valueOf(0));
        if (tenantAuthMap == null) {
            return Collections.emptyMap();
        }
        Integer status = Integer.valueOf(tenantAuthMap.get("status").toString());
        if (status == -1) {
            return Collections.emptyMap();
        }
        if (status == 0) {
            Map registerMap = this.bossIamService.registerTenant(authoredUser, email, phone, "Athena", "", "athena_light_01");
            if (registerMap != null && registerMap.size() > 0) {
                resultMap.put("workItemToTenantId", (String)registerMap.get("id"));
                resultMap.put("commonTenantUserId", (String)registerMap.get("userId"));
            }
        } else if (status == 1) {
            Boolean isTenantAuth = Boolean.valueOf(tenantAuthMap.get("isTenantAuth").toString());
            Boolean authorizeUserResult = this.bossIamService.authorizeUser(authoredUser, tenantAuthMap.get("tenantId").toString(), email, phone, "Athena", "", "athena_light_01", isTenantAuth);
            if (authorizeUserResult.booleanValue()) {
                resultMap.put("workItemToTenantId", tenantAuthMap.get("tenantId").toString());
                resultMap.put("commonTenantUserId", tenantAuthMap.get("userId").toString());
            }
        } else if (status == 2) {
            resultMap.put("workItemToTenantId", tenantAuthMap.get("tenantId").toString());
            resultMap.put("commonTenantUserId", tenantAuthMap.get("userId").toString());
        }
        return resultMap;
    }

    public WorkitemAppendixType getContactsType(String tenantId, JSONObject contactMessage, String tmProjectCode) {
        String email = (String)contactMessage.get("contacts");
        String phone = (String)contactMessage.get("contactPhone");
        WorkitemAppendixType resultType = this.getMobileType(tenantId, phone, tmProjectCode);
        if (resultType != WorkitemAppendixType.Normal) {
            resultType = this.getEmailType(tenantId, email, tmProjectCode);
        }
        return resultType;
    }

    public WorkitemAppendixType getMobileType(String tenantId, String phone, String tmProjectCode) {
        try {
            if (StringUtils.isBlank((String)phone)) {
                return WorkitemAppendixType.NoPhone;
            }
            InnerExistDTO innerExistDTO = this.userService.phoneInnerExist(phone);
            if (innerExistDTO == null || !Objects.equals(innerExistDTO.getIsRegister(), true)) {
                return WorkitemAppendixType.NoRegister;
            }
            String performerId = null;
            UserDTO userDTO = this.userService.queryByPhone(phone);
            if (userDTO != null && StringUtils.isNotBlank((String)userDTO.getId())) {
                performerId = userDTO.getId();
            }
            if (StringUtils.isBlank(performerId)) {
                return WorkitemAppendixType.NoRegister;
            }
            List appList = this.themeMapService.getAppsByProjectIdForFlowEngine(tmProjectCode);
            if (CollectionUtils.isEmpty((Collection)appList)) {
                return WorkitemAppendixType.NoPermission;
            }
            String appCode = ((TmAppDTO)appList.get(0)).getAppCode();
            userDTO = this.userService.queryByPhone(phone, tenantId);
            if (userDTO == null) {
                return WorkitemAppendixType.NoTenant;
            }
            AppAuthDTO appAuthDTO = this.cacService.queryAppAuth(performerId, appCode);
            if (appAuthDTO == null || !Objects.equals(appAuthDTO.getIsSuccess(), true)) {
                return WorkitemAppendixType.NoPermission;
            }
        }
        catch (Exception ex) {
            log.warn("getEmailType \u83b7\u53d6\u7528\u6237\u6ce8\u518c\u3001\u6388\u6743\u4fe1\u606f\u5f02\u5e38\uff1a  {}", (Throwable)ex);
            return WorkitemAppendixType.NoRegister;
        }
        return WorkitemAppendixType.Normal;
    }

    public WorkitemAppendixType getEmailType(String tenantId, String email, String tmProjectCode) {
        try {
            if (StringUtils.isBlank((String)email)) {
                return WorkitemAppendixType.NoEmail;
            }
            InnerExistDTO innerExistDTO = this.userService.emailInnerExist(email);
            if (innerExistDTO == null || !Objects.equals(innerExistDTO.getIsRegister(), true)) {
                return WorkitemAppendixType.NoRegister;
            }
            String performerId = null;
            UserDTO userDTO = this.userService.queryByEmail(email);
            if (userDTO != null && StringUtils.isNotBlank((String)userDTO.getId())) {
                performerId = userDTO.getId();
            }
            if (StringUtils.isBlank(performerId)) {
                return WorkitemAppendixType.NoRegister;
            }
            List appList = this.themeMapService.getAppsByProjectIdForFlowEngine(tmProjectCode);
            if (CollectionUtils.isEmpty((Collection)appList)) {
                return WorkitemAppendixType.NoPermission;
            }
            String appCode = ((TmAppDTO)appList.get(0)).getAppCode();
            userDTO = this.userService.queryByEmail(email, tenantId);
            if (userDTO == null) {
                return WorkitemAppendixType.NoTenant;
            }
            AppAuthDTO appAuthDTO = this.cacService.queryAppAuth(performerId, appCode);
            if (appAuthDTO == null || !Objects.equals(appAuthDTO.getIsSuccess(), true)) {
                return WorkitemAppendixType.NoPermission;
            }
        }
        catch (Exception ex) {
            log.warn("getEmailType \u83b7\u53d6\u7528\u6237\u6ce8\u518c\u3001\u6388\u6743\u4fe1\u606f\u5f02\u5e38\uff1a  {}", (Throwable)ex);
            return WorkitemAppendixType.NoRegister;
        }
        return WorkitemAppendixType.Normal;
    }

    public String getSupplierName(JSONObject bpmData) {
        JSONObject data;
        JSONObject message;
        JSONObject emailMessage;
        String result = "\u672a\u77e5\u4f9b\u5e94\u5546";
        if (bpmData != null && bpmData.containsKey((Object)"emailMessage") && (emailMessage = bpmData.getJSONObject("emailMessage")) != null && emailMessage.containsKey((Object)"message") && (message = emailMessage.getJSONObject("message")) != null && message.containsKey((Object)"data") && (data = message.getJSONObject("data")) != null && data.containsKey((Object)"supplier_name")) {
            result = data.getString("supplier_name");
        }
        return result;
    }

    public String getEmail(JSONObject bpmData) {
        JSONObject emailMessage;
        String result = null;
        if (bpmData != null && bpmData.containsKey((Object)"emailMessage") && (emailMessage = bpmData.getJSONObject("emailMessage")) != null && emailMessage.containsKey((Object)"contacts")) {
            result = emailMessage.getString("contacts");
        }
        return result;
    }

    public String getContact(JSONObject bpmData) {
        String result = null;
        if (bpmData != null && bpmData.containsKey((Object)"emailMessage")) {
            JSONObject emailMessage = bpmData.getJSONObject("emailMessage");
            if (emailMessage != null && emailMessage.containsKey((Object)"contactPhone")) {
                result = emailMessage.getString("contactPhone");
            }
            if (emailMessage != null && emailMessage.containsKey((Object)"contacts")) {
                result = StringUtils.isNotEmpty((String)emailMessage.getString("contacts")) ? emailMessage.getString("contacts") : result;
            }
        }
        return result;
    }
}

