/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.workflow;

import com.digiwin.athena.atmc.common.domain.WorkflowInstance;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalStepDTO;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalWorkItemDTO;
import com.digiwin.athena.atmc.http.restful.bpm.WorkflowService;
import com.digiwin.athena.atmc.http.restful.bpm.model.WorkflowProcess;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import java.util.ArrayList;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTransformService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowTransformService.class);
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private UserService userService;

    private String getUserName(Map<String, String> nameMap, String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            if (nameMap.containsKey(userId)) {
                return nameMap.get(userId);
            }
            UserDTO userDTO = this.userService.query(userId);
            String userName = null;
            if (userDTO != null) {
                userName = userDTO.getName();
            }
            nameMap.put(userId, userName);
            return userName;
        }
        return null;
    }

    private ApprovalStepDTO builderSignInformer(WorkflowProcess signProcess, JSONObject informer, String noticeType) {
        if (signProcess == null || informer == null) {
            return null;
        }
        if (informer.containsKey((Object)noticeType)) {
            JSONArray noticeArray = JSONArray.fromObject((Object)informer.get(noticeType));
            if (noticeArray == null || noticeArray.isEmpty()) {
                return null;
            }
            ApprovalStepDTO step = ApprovalStepDTO.builder().id(0L).bpmActivityId(signProcess.getActivityId()).bpmActivityName(signProcess.getActivityName()).state(3).isReassign(false).isReexecute(false).build();
            ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
            for (Object sn : noticeArray) {
                JSONObject noticeObject = JSONObject.fromObject(sn);
                if (!noticeObject.containsKey((Object)"userId") || StringUtils.isBlank((String)noticeObject.getString("userId"))) continue;
                ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().performerId(noticeObject.getString("userId")).build();
                if (noticeObject.containsKey((Object)"userName") && StringUtils.isNotBlank((String)noticeObject.getString("userName"))) {
                    workItem.setPerformerName(noticeObject.getString("userName"));
                }
                if (noticeObject.containsKey((Object)"sendTime") && StringUtils.isNotBlank((String)noticeObject.getString("sendTime"))) {
                    workItem.setClosedTime(null);
                }
                workItemList.add(workItem);
            }
            step.setWorkitemList(workItemList);
            return step;
        }
        return null;
    }

    public Map<String, Object> getWorkflowHistory(WorkflowInstance workflowInstance) {
        return this.workflowService.getWorkflowProcess(workflowInstance.getSerialNumber(), workflowInstance.getWorkItemId());
    }
}

