/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.util;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.domain.CardActivityDto;
import com.digiwin.athena.atmc.common.domain.CardInfoDto;
import com.digiwin.athena.atmc.common.domain.CardItemDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final String SUMMARY_LAYOUT = "summaryLayout";
    public static final String HISTORY_MESSAGE = "historyMessage";
    public static final String SEARCH_MESSAGE = "searchMessage";

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<T>> rows = new ArrayList<List<T>>(splitSize);
        for (int i = 0; i < count; ++i) {
            List<T> cols = datas.subList(i * splitSize, i == count - 1 ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto) {
        return CommonUtils.getActivityMessageStr(cardInfoDto, Maps.newHashMap());
    }

    public static String getActivityMessageStr(CardInfoDto cardInfoDto, Map<Long, Map<String, Set<String>>> activityMsg) {
        List<CardItemDto> cardItemList = cardInfoDto.getCardItemList();
        if (CollectionUtils.isEmpty(cardItemList) || activityMsg == null) {
            return null;
        }
        for (CardItemDto cardItemDto : cardItemList) {
            Long activityId = cardItemDto.getActivityId();
            if (activityId == null) continue;
            Map map = activityMsg.computeIfAbsent(cardItemDto.getActivityId(), e -> new HashMap());
            Map<String, Object> cardInfo = cardItemDto.getCardInfo();
            CommonUtils.addCardText(map, cardInfo, SUMMARY_LAYOUT);
            CommonUtils.addCardText(map, cardInfo, HISTORY_MESSAGE);
            CommonUtils.addCardText(map, cardInfo, SEARCH_MESSAGE);
        }
        CardActivityDto cardActivityDto = new CardActivityDto();
        cardActivityDto.setActivityMsg(activityMsg);
        return JsonUtils.objectToString((Object)cardActivityDto);
    }

    public static String getActivityMessageStr(Long activityId, Map<String, Object> cardData) {
        if (activityId != null && cardData != null) {
            CardInfoDto cardInfoDto = new CardInfoDto();
            cardInfoDto.setCardItemList(Lists.newArrayList((Object[])new CardItemDto[]{new CardItemDto(activityId, cardData)}));
            return CommonUtils.getActivityMessageStr(cardInfoDto);
        }
        return null;
    }

    public static Map<String, Object> getCardMap(String summary, String history, String search) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put(SUMMARY_LAYOUT, summary);
        map.put(HISTORY_MESSAGE, history);
        map.put(SEARCH_MESSAGE, search);
        return map;
    }

    public static String getActivityMessageStr(String activityMessage, Long activityId, Map<String, Object> cardData) {
        if (activityId == null || cardData == null) {
            return activityMessage;
        }
        CardActivityDto cardActivity = CommonUtils.getCardActivity(activityMessage);
        CardInfoDto cardInfoDto = new CardInfoDto();
        cardInfoDto.setCardItemList(Lists.newArrayList((Object[])new CardItemDto[]{new CardItemDto(activityId, cardData)}));
        if (cardActivity == null) {
            return CommonUtils.getActivityMessageStr(cardInfoDto);
        }
        return CommonUtils.getActivityMessageStr(cardInfoDto, cardActivity.getActivityMsg());
    }

    public static CardActivityDto getCardActivity(String activityMessage) {
        if (StringUtils.isNotEmpty((String)activityMessage)) {
            try {
                return (CardActivityDto)JsonUtils.jsonToObject((String)activityMessage, CardActivityDto.class);
            }
            catch (Exception e) {
                log.warn("\u8f6c\u6362\u6d3b\u52a8\u7ea7\u6458\u8981\u4fe1\u606f\u9519\u8bef:{},\u539f:{}", (Object)e.getMessage(), (Object)activityMessage);
            }
        }
        return null;
    }

    public static Map<String, Set<String>> getCardInfoMap(String activityMessage, Long activityId) {
        Map<Long, Map<String, Set<String>>> activityMsg;
        CardActivityDto cardActivity;
        if (activityId != null && (cardActivity = CommonUtils.getCardActivity(activityMessage)) != null && (activityMsg = cardActivity.getActivityMsg()) != null) {
            return activityMsg.getOrDefault(activityId, Collections.emptyMap());
        }
        return null;
    }

    private static void addCardText(Map<String, Set<String>> map, Map<String, Object> cardInfo, String key) {
        Set textList = map.computeIfAbsent(key, e -> new HashSet());
        String summaryText = MapUtils.getString(cardInfo, (Object)key);
        if (StringUtils.isNotBlank((String)summaryText)) {
            String[] split;
            for (String s : split = summaryText.split("<br>")) {
                String[] dataSplit;
                String[] rowSplit = s.split("\uff1a");
                if (rowSplit.length > 1) {
                    dataSplit = rowSplit[1].split(",");
                    textList.add(rowSplit[0]);
                } else {
                    dataSplit = rowSplit[0].split(",");
                }
                textList.addAll(Arrays.asList(dataSplit));
            }
        }
    }

    public static void main(String[] args) {
        String activityMessageStr = CommonUtils.getActivityMessageStr(484371628597376L, CommonUtils.getCardMap("\u7528\u6237123\uff1a202409191253281,202409191253282 N<br>\u7528\u6237\u540d22\uff1a\u5f20\u6d69\u6668,\u5e38\u6da6\u838e<br>\u72b6\u600122\uff1aN", "", "\u7528\u6237\uff1a202409191253281,202409191253282"));
        System.out.println(activityMessageStr);
    }
}

