/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.util.engine;

import com.digiwin.athena.atmc.common.domain.engine.SplitEngine;
import com.digiwin.athena.atmc.common.enums.FlowEngineTableEnum;
import com.digiwin.athena.atmc.common.util.engine.FlowEngineBeanUtils;
import com.digiwin.athena.atmc.common.util.engine.FlowEngineDataRedisUtils;
import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class AnalysisEngineKeyUtils {
    public static SplitEngine splitActivityId(List<Long> ids, FlowEngineTableEnum tableName) {
        SplitEngine splitEngine = new SplitEngine();
        if (CollectionUtils.isEmpty(ids)) {
            return splitEngine;
        }
        ArrayList<Long> flowEngineIds = new ArrayList<Long>();
        ids.forEach(t -> {
            if (FlowEngineDataRedisUtils.getFlowEngineIdFromRedis(t).booleanValue()) {
                flowEngineIds.add((Long)t);
            }
        });
        ids.removeAll(flowEngineIds);
        if (CollectionUtils.isNotEmpty(ids)) {
            AnalysisEngineKeyUtils.getBpmActivityWorkitemIds(tableName, ids, flowEngineIds);
            AnalysisEngineKeyUtils.getBacklogIds(tableName, ids, flowEngineIds);
            AnalysisEngineKeyUtils.getBpmActivityIds(tableName, ids, flowEngineIds);
            AnalysisEngineKeyUtils.getBpmActivityStepIds(tableName, ids, flowEngineIds);
            AnalysisEngineKeyUtils.getActivityIds(tableName, ids, flowEngineIds);
            AnalysisEngineKeyUtils.getTaskIds(tableName, ids, flowEngineIds);
            AnalysisEngineKeyUtils.getBpmProcessIds(tableName, ids, flowEngineIds);
        }
        flowEngineIds.forEach(id -> FlowEngineDataRedisUtils.insertFlowEngineIdToRedis(tableName.getValue(), id));
        ids.removeAll(flowEngineIds);
        splitEngine.setFlowEngineIds(flowEngineIds);
        splitEngine.setPtmIds(ids);
        return splitEngine;
    }

    public static Long getActivityIdFromAction(SubmitActionDTO submitAction) {
        Long backlogId = null;
        if (submitAction != null && submitAction.getAction() != null && submitAction.getAction().getExecuteContext() != null) {
            backlogId = submitAction.getAction().getExecuteContext().getAbnormalWorkitemId();
        }
        return backlogId;
    }

    public static String getProcessNumberFromAction(SubmitActionDTO submitAction) {
        String processSerialNumber = null;
        if (submitAction != null && submitAction.getAction() != null && submitAction.getAction().getExecuteContext() != null) {
            processSerialNumber = submitAction.getAction().getExecuteContext().getProcessSerialNumber();
        }
        return processSerialNumber;
    }

    public static String getProjectCodeFromAction(SubmitActionDTO submitAction) {
        String projectCode = null;
        if (submitAction != null && submitAction.getAction() != null && submitAction.getAction().getExecuteContext() != null) {
            projectCode = submitAction.getAction().getExecuteContext().getTmProjectId();
        }
        return projectCode;
    }

    public static Long getActivityIdFromRowData(Map<String, Object> rowDataMap) {
        Long workitemId = null;
        if (rowDataMap != null && rowDataMap.containsKey("activity__backLog__data") && null != rowDataMap.get("activity__backLog__data")) {
            Map backlogMap = (Map)rowDataMap.get("activity__backLog__data");
            workitemId = Long.valueOf(backlogMap.get("backlogId").toString());
            if (backlogMap.containsKey("ptmBacklogId") && null != backlogMap.get("ptmBacklogId")) {
                workitemId = Long.valueOf(backlogMap.get("ptmBacklogId").toString());
            }
        }
        return workitemId;
    }

    public static Long getActivityIdFromMap(Map map, String key) {
        if (MapUtils.isEmpty((Map)map)) {
            return 0L;
        }
        if (!map.containsKey(key)) {
            return 0L;
        }
        return MapUtils.getLong((Map)map, (Object)key, (Long)0L);
    }

    private static void getBpmActivityWorkitemIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmActivityWorkitem.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmActivityWorkitemMapper().queryByIds(originalIds));
    }

    private static void getBacklogIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.backlog.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBacklogMapper().queryByIds(originalIds));
    }

    private static void getBpmActivityStepIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmActivityStep.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmActivityStepMapper().queryByIds(originalIds));
    }

    private static void getBpmActivityIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmActivity.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmActivityMapper().queryByIds(originalIds));
    }

    private static void getActivityIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.activity.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getActivityMapper().queryByIds(originalIds));
    }

    private static void getTaskIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.task.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getTaskMapper().queryByIds(originalIds));
    }

    private static void getBpmProcessIds(FlowEngineTableEnum tableName, List<Long> originalIds, List<Long> flowEngineIds) {
        if (!FlowEngineTableEnum.bpmProcess.equals((Object)tableName)) {
            return;
        }
        flowEngineIds.addAll(FlowEngineBeanUtils.getBpmProcessMapper().queryByIds(originalIds));
    }
}

