/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.util.engine;

import com.digiwin.athena.appcore.util.SpringUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class FlowEngineDataRedisUtils {
    private static final String redisKeyPreFix = "atmc:cache:flow:engine:";
    private static StringRedisTemplate stringRedisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringRedisTemplate getStringRedisTemplate() {
        if (!Objects.isNull(stringRedisTemplate)) return stringRedisTemplate;
        Class<FlowEngineDataRedisUtils> clazz = FlowEngineDataRedisUtils.class;
        synchronized (FlowEngineDataRedisUtils.class) {
            if (!Objects.isNull(stringRedisTemplate)) return stringRedisTemplate;
            stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean(StringRedisTemplate.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return stringRedisTemplate;
        }
    }

    public static void insertFlowEngineIdToRedis(String tableName, Long id) {
        FlowEngineDataRedisUtils.getStringRedisTemplate().opsForValue().setIfAbsent((Object)(redisKeyPreFix + id), (Object)tableName, 15L, TimeUnit.MINUTES);
    }

    public static Boolean getFlowEngineIdFromRedis(Long id) {
        return FlowEngineDataRedisUtils.getStringRedisTemplate().hasKey((Object)(redisKeyPreFix + id));
    }
}

