/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.xiaohui.impl;

import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.xiaohui.SendMessageXhService;
import com.digiwin.athena.atmc.http.restful.xiaohui.model.MessageDTO;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SendMessageXhServiceImpl
implements SendMessageXhService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageXhServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void send(MessageDTO messageDTO) {
        String url = this.envProperties.getXiaohuiUri() + "api/SetPushHData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)messageDTO, (MultiValueMap)headers);
        log.info("[SendMessageServiceImpl] SetPushHData message is : {}", (Object)messageDTO);
        this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
    }

    @Override
    public void send(JSONObject messageDTO) {
        String url = this.envProperties.getXiaohuiUri() + "api/SetPushHData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)messageDTO, (MultiValueMap)headers);
        this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
    }
}

