package com.digiwin.athena.atmc.http.constant;

/**
 * @Author wuzq
 * @Date 2023/5/25 13:26
 * @Description: eoc API
 * @Version 1.0
 */
public class EocApiConstant {
    private EocApiConstant() {
    }

    /**
     * 根据empId获取员工详情
     */
    public static final String EMP_INFO = "api/eoc/v2/emp/info";

    /**
     * 根据token，获取租户所属集团下所有公司
     */
    public static final String CORP_COMPANY = "api/eoc/v2/corp/company";

    /**
     * 根据token，获取租户下的所有工厂信息
     */
    public static final String CORP_FACTORY = "api/eoc/v2/corp/factory";

    /**
     * 查询运营单元名称接口URL
     */
    public static final String QRY_BIZ_UNIT_NAME_URL = "api/eoc/v2/corp/company/factory/name";

    /**
     * 根据部门id获取所有员工列表
     */
    public static final String DEPT_EMPS = "api/eoc/v2/dept/emps";

    /**
     * 根据职责ID获取该职责下的所有员工信息
     */
    public static final String DUTY_EMPS = "api/eoc/v2/duty/emps";

    /**
     * 根据部门id获取该部门的主管信息
     */
    public static final String DEPT_DIRECTO = "api/eoc/v2/dept/directo";

    /**
     * 获取当前租户下的所有用户
     */
    public static final String PAGE_EMP = "api/eoc/v2/emp?pageNum=1&pageSize=200";

    /**
     * 根据 userId 获取该人员部门的主管信息
     */
    public static final String EMP_DIRECTOR = "/api/eoc/v2/emp/director";

    /**
     * 查找指定直属主管所属的人员列表
     */
    public static final String PAGE_EMP_SIMPLE = "api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";

    /**
     * 查找指定直属主管所属的人员列表（排序）
     */
    public static final String PAGE_EMP_SIMPLE_ORDER_BY = "api/eoc/v2/emp/simple?pageNum={pageNum}&pageSize={pageSize}&orderBy={orderBy}&params={params}";

    /**
     * 查询所有部门信息以及部门下所有员工的信息【4.10】
     */
    public static final String PAGE_DEPT_CASCADE = "api/eoc/v2/dept/cascade?pageNum=1&pageSize={pageSize}";

    /**
     * 根据部门Sid获取部门下的人员
     */
    public static final String PAGE_DEPT_DEPARTMENT_SID_EMPS = "api/eoc/v2/dept/{departmentSid}/emps?pageNum=1&pageSize={pageSize}";

    /**
     * 根据token获取对应租户的所有部门及子部门
     */
    public static final String PAGE_DEPT_LIST = "api/eoc/v2/dept/list?pageNum=1&pageSize={pageSize}";

    /**
     * 根据用户查询用户所属部门以及子部门的员工列表
     */
    public static final String EMP_SUBORDINATE = "api/eoc/v2/emp/subordinate";

    /**
     * 通过用户ID获取员工ID
     */
    public static final String EMP_ID = "/api/eoc/v2/emp/id";

    /**
     * 通过员工ID获取用户ID
     */
    public static final String EMP_USER_ID = "/api/eoc/v2/emp/user/id";

    /**
     * 获取指定用户的代理用户
     */
    public static final String EMP_AGENT = "api/eoc/v2/emp/agent";

    /**
     * 获取指定用户代理的所有目标用户列表
     */
    public static final String EMP_AGENT_TARGET = "api/eoc/v2/emp/agent/target";

    /**
     * 通过用户ID 获取部门所有员工
     */
    public static final String EMP_MAIN_EMPS = "api/eoc/v2/dept/main/emps";

    /**
     * 获取部门直属领导
     */
    public static final String DEPT_DIRECTOR = "/api/eoc/v2/dept/director";

    /**
     * 根据租户Sid和用户id获取EOC员工信息
     */
    public static final String EMP_TENANT_USER_ID_INFO = "/api/eoc/v2/emp/tenant/user/id/info";

}
