package com.digiwin.athena.atmc.http.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.appcore.domain.LanguageMark;
import com.digiwin.athena.atmc.http.handler.MySqlJsonHandler;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONObject;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class Task extends BaseEntity<Task> implements Serializable {
    @TableId()
    private Long id;

    /**
     * 可能是themeMap中的项目名称，也可能是bpm推过来的自定义项目名称
     */
    @LanguageMark
    private String name;
    private String targetId;

    @LanguageMark
    private String targetName;
    private String tmTaskId;
    private String personInCharge;
    private String tenantId;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Integer importance;
    private Long mainTaskId;

    @LanguageMark
    private String sourceName;
    private String sourceIds;
    private LocalDateTime createTime;
    /**
     * 進行中1
     * 暫停2
     * 順利完成的3
     * 撤銷4
     * 關閉5
     */
    private Integer state;
    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject businessUnit;
    private Boolean completedReport;
    private LocalDateTime closedTime;
    private LocalDateTime dueDate;

    @LanguageMark
    private String dueDateName;
    private Integer sourceCount;
    @JsonIgnore
    @TableField(exist = false)
    private Map dueDateTimeDistance;
    /**
     * 当责者姓名
     **/
    private String personInChargeName;

    private int emergency;

    /**
     * 是否在项目列表显示
     * 0-显示，1-不显示
     */
    private Boolean hide;

    /**
     * 此值不为null或0，表示当前任务有变更
     * 此值表示发起变更的子任务Id
     */
    private Long startChangedSubTaskId;

    /**
     * 已读次数，目前仅适用于主项目
     */
    private Integer readCount = 0;

    /**
     * 营运单元code，由公司id、工厂id等单元拼接而成
     */
    private String eocCode;

    /**
     * 营运单元name，由公司名称、工厂名称等单元拼接而成
     */
    private String eocName;

    /**
     * 营运单元最小指示维度，如：公司：1，工厂：2
     */
    private Integer eocType;

    /**
     * 动态任务的id,参与项目卡合并计算
     */
    private String compositionId;

    /**
     * 项目的来源实体名称
     */
    private String sourceEntityName;

    /**
     * 永远使用themeMap中的项目名称
     */
    @LanguageMark
    private String projectName;

    /**
     * 项目卡合并条件
     */
    private String mergeData;

    /**
     * 项目的pattern，
     * 目前只有唯一值business，表示该项目卡的呈现的数据来自业务数据
     * 为空或activity，表示按照之前的逻辑
     */
    private String tmPattern;

    /**
     * 备注
     */
    private String remark;

    /**
     * 0-未开始、进行中、已暂停
     * 10-关闭—正常結束
     * 20-关闭—終止而結束
     * 30-关闭—撤銷而結束
     * 40-关闭—第三方強制終止而結束
     */
    private Integer subState;

    /**
     * 引擎类型
     * FlowEngine BP
     * TaskEngine 任务引擎
     */
    private String engineType;

    /**
     * 项目来源：PTM表示来源于PTM，其他表示ATMC
     * 不存mysql
     * <p>参考：BpmConstant.DATA_FROM_PTM</p>
     */
    @JsonIgnore
    @TableField(exist = false)
    private String dataFrom;

    /**
     * 是否钉选
     */
    private Boolean pinning;

}