package com.digiwin.athena.atmc.http.restful.abt.impl;

import com.digiwin.athena.atmc.http.constant.AbtApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.HttpAssistantServiceImpl;
import com.digiwin.athena.atmc.http.restful.abt.AbtService;
import com.digiwin.athena.atmc.http.restful.abt.model.RefreshCardMessageDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/**
 * AbtServiceImpl Description
 *
 * @author majianfu
 * @date 2023/4/7
 * @since
 */
@Slf4j
@Service
public class AbtServiceImpl implements AbtService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;

    /**
     * {@inheritDoc}
     */
    @Override
    public void createRefreshCardMessageJob(RefreshCardMessageDTO refreshCardMessageDTO) {
        String url = envProperties.getAbtUri() + AbtApiConstant.REFRESH_CARD_MESSAGE_JOB_CREATE_IF_ABSENT;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        log.info("create refresh card message job{}, {}", refreshCardMessageDTO.getId(), refreshCardMessageDTO);
        Boolean success = httpAssistantService.post(new TypeReference<Boolean>() {
        }, url, headers, refreshCardMessageDTO);
        log.info("create refresh card message job{}, {}, ret{}", refreshCardMessageDTO.getId(), refreshCardMessageDTO, success);
    }
}
