package com.digiwin.athena.atmc.http.restful.atdm;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import com.digiwin.athena.atmc.http.restful.aglie.model.QueryDataByActionVO;
import com.digiwin.athena.atmc.http.restful.atdm.model.RecycleRecordStateChangeDTO;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

public interface AtdmService {

    /**
     * 提交
     *
     * @param submitAction
     * @return
     */
    Map submitTask(SubmitActionDTO submitAction);

    /**
     * 执行
     *
     * @param submitAction
     * @return
     */
    Map executeTask(SubmitActionDTO submitAction);

    /**
     * 根据actionId查询
     *
     * @param action
     * @return
     */
    BaseResultDTO queryByActionId(Map action);

    /**
     * 提交合并的任务
     *
     * @param mergeActionList
     * @return
     */
    List<Map> submitMergeTask(List<SubmitActionDTO> mergeActionList);

    /**
     * 将回收站记录标记为过期状态
     *
     * @param recycleRecordStateChangeDTO
     * @return
     */
    void markRecycleRecordExpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO);

    /**
     * 将回收站记录标记为未过期状态
     *
     * @param recycleRecordStateChangeDTO
     * @return
     */
    void markRecycleRecordUnexpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO);

    /**
     * 将回收站记录标记为删除状态（硬删除）
     *
     * @param recycleRecordStateChangeDTO
     * @return
     */
    void markRecycleRecordDeleted(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO);

    /**
     * 获取任务卡CheckItems等数
     *
     * @return
     */
    BaseResultDTO<JSONObject> getDataByAction(QueryDataByActionVO queryDataByActionVO);

}
