package com.digiwin.athena.atmc.http.restful.cac.impl;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.CacApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.cac.model.AppAuthDTO;
import com.digiwin.athena.atmc.http.restful.cac.CacService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

@Service
public class CacServiceImpl implements CacService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    /**
     * 检查指定用户的指定应用 在当前租户是否有授权
     * @param userId
     * @param appCode
     * @return
     */
    @Override
    public AppAuthDTO queryAppAuth(String userId, String appCode){
        AppAuthDTO result = null;

        String uri = envProperties.getIamCacUri() + CacApiConstant.AUTHORIZATIONS_CURRENT_TENANT_USERS_USER_ID_GOODS_APP_CODE_BY_USER;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        param.put("appCode", appCode);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<AppAuthDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<AppAuthDTO>() {
                }, param);
        result = responseEntity.getBody();
        return result;
    }

}
