package com.digiwin.athena.atmc.http.restful.emc;

import net.sf.json.JSONObject;

import java.util.Map;

/**
 * 发送email
 *
 * @author majfa
 * @date 2021年2月18日 17:00:00
 */
public interface SendEmailService {
    /**
     * 发送模板邮件，要发送的邮件内容已组装好
     *
     * @param content 邮件内容
     */
    void sendEmail(JSONObject content);

    /**
     * 发送模板邮件，邮件模板需要根据入参组装
     *
     * @param templateId 模板ID
     * @param contacts   收件人
     * @param emailData  邮件内容数据
     */
    void sendEmailWithTemplate(String templateId, String contacts, Map emailData);
}
