package com.digiwin.athena.atmc.http.restful.eoc;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.restful.eoc.model.*;
import com.digiwin.athena.atmc.http.restful.iam.model.BizUnitInfoDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.EocUserDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.ProxyUserDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.TenantBizUnitDTO;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.util.Collection;
import java.util.List;

public interface EocService {

    /**
     * 根据userId获取员工详情
     *
     * @param userId
     * @return
     */
    EocEmployeeDTO getEmployeeByUserId(String userId);

    /**
     * 根据empId获取员工详情
     *
     * @param empId
     * @return
     */
    EocEmployeeDTO getEmployeeByEmpId(String empId);

    /**
     * 根据部门id获取所有员工列表
     *
     * @param deptId
     * @return
     */
    List<EocDeptEmployeeDTO> getDepartEmployees(String deptId);


    /**
     * 根据职责ID获取该职责下的所有员工信息
     *
     * @param dutyId     职责id
     * @param deptId     部门id
     * @param empContent 员工编号Id或员工名称
     * @return 查询结果
     */
    List<EocDutyEmployeeDTO> getDutyEmployees(String dutyId, String deptId, String empContent);

    /**
     * 根据部门id获取该部门的主管信息
     *
     * @param deptId 部门id
     * @return 查询结果
     */
    EocDirectEmployeeDTO getDirectorEmployee(String deptId);

    /**
     * 获取当前租户下的所有用户
     *
     * @return
     */
    List<EocTenantAllUserDTO.EocUserDTO> getAllUserByTenant();

    /**
     * 根据 userId 获取该人员部门的主管信息
     *
     * @param userId 部门id
     * @return 查询结果
     */
    EocDirectEmployeeDTO getDirectorEmployeeByUserId(String userId);

    /**
     * 判断指定 userId 是否是部门主管
     *
     * @param userId
     * @return
     */
    Boolean isDeptDirector(String userId);

    /**
     * 获取指定人员主管部门的人员列表
     *
     * @param userId
     * @return
     */
    List<EocDeptEmployeeDTO> getDeptDirectorEmployees(String userId);

    /**
     * 查找指定直属主管所属的人员列表
     *
     * @param directorId 要查询的直属主管userId
     * @param size       获取几个人
     * @return
     */
    List<EocTenantAllUserDTO.EocUserDTO> getAllUserByDirectorId(String directorId, Integer size);

    /**
     * 查询指定一批用户的员工信息
     *
     * @param userIds
     * @return
     */
    List<EocTenantAllUserDTO.EocUserDTO> getEmployeeInfoByUserId(Collection<String> userIds);

    /**
     * 查找指定人员作为直属主管其所有下属成员列表
     * 包括其作为某部门直属主管其部门内所有成员，以及eoc中设置其为直属主管的
     * 包括 getDeptDirectorEmployees 和 getAllUserByDirectorId 的集合
     *
     * @param userId
     * @return
     */
    List<EocDeptEmployeeDTO> getUserByDirectorId(String userId);

    /**
     * 查询所有部门信息以及部门下所有员工的信息【4.10】
     *
     * @return
     */
    List<EocDeptDTO.Dept> queryAllDeptAndEmployee();

    /**
     * 根据部门Sid获取部门下的人员
     *
     * @param departmentSid 部门Sid
     * @return
     */
    JSONArray queryMembersOfTheDepartment(String departmentSid);

    /**
     * 根据token获取对应租户的所有部门及子部门
     *
     * @return
     */
    JSONArray queryCurrentTenantAllDepartment();

    /**
     * 根据用户查询用户所属部门以及子部门的员工列表
     *
     * @param userId 用户id
     * @return JSONArray
     */
    JSONArray queryUserDepartmentInfo(String userId);

    /**
     * 通过用户ID获取员工ID
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    String getEmpIdByUserId(String userId, String token);

    /**
     * 通过员工ID获取用户ID
     *
     * @param empId 用户id
     * @return 用户基本信息
     */
    String getUserIdByEmpId(String empId, String token);

    /**
     * 获取指定用户的代理用户
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    ProxyUserDTO getProxyUser(String userId, String token);

    /**
     * 获取指定用户代理的所有目标用户列表
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    List<ProxyUserDTO> getProxyTargetUsers(String userId, String token);

    /**
     * 通过用户ID 获取部门所有员工
     *
     * @param userId
     * @param token
     * @return
     */
    List<EocUserDTO> getEocUserListByUserId(String userId, String token);

    /**
     * 获取用户直属领导
     *
     * @param userId
     * @param token
     * @return
     */
    EocUserDTO getUserLeader(String userId, String token);


    /**
     * 获取部门直属领导/api/eoc/v2/dept/director
     *
     * @param userId
     * @param token
     * @return
     */
    EocUserDTO getDeptLeader(String userId, String token);

    /**
     * 根据租户Sid和用户id获取EOC员工信息
     *
     * @Author：SYQ
     * @Date：2021/7/5 16:44
     */
    String getEocByTenantAndUser(AuthoredUser user, String tenantSid, String userId);

    /**
     * 获取EOC用户信息
     *
     * @Author：SYQ
     * @Date：2021/6/15 17:07
     */
    String getEocEmpInfo(String userId, AuthoredUser user);

    /**
     * 根据营运单元code获取营运单元信息
     *
     * @param bizUnitCodeJSONObj
     * @return
     */
    BizUnitInfoDTO getBizUnitInfo(JSONObject bizUnitCodeJSONObj);


    /**
     * 根据token，获取租户所属公司的运营单元信息
     *
     * @return
     */
    TenantBizUnitDTO getCompanyInfoForTenant();

    /**
     * 根据token，获取租户下的所有工厂信息
     *
     * @return
     */
    TenantBizUnitDTO getFactoryInfoForTenant();
}
