package com.digiwin.athena.atmc.http.restful.iam;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.tenant.TenantBaseRespDto;
import com.digiwin.athena.atmc.http.restful.iam.model.IamTenantSimpleDTO;
import net.sf.json.JSONObject;

import java.util.List;

public interface TenantService {
    boolean isTest(String token, String id);

    /**
     * 根据租户id，名称或者统编号查询租户信息
     *
     * @param content 租户id或者名称
     * @param taxNo   统编号码
     * @param user    用户信息
     * @return 租户信息集合
     */
    List<TenantBaseRespDto> queryTenant(String content, String taxNo, AuthoredUser user);

    /**
     * 获取租户简单信息
     *
     * @param tenantId
     * @return
     */
    IamTenantSimpleDTO getTenantSimple(String tenantId);

    /**
     * 从api中获取租户的虚拟token
     *
     * @param tenantId 租户id
     * @return token信息
     */
    JSONObject queryApiVirtualToken(String tenantId);
}
