package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.IamApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.iam.model.RoleDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserRoleDTO;
import com.digiwin.athena.atmc.http.restful.iam.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<RoleDTO> queryUserRoles(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> param = new HashMap<>();
        param.put("id",userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(param,headers);

        String url = envProperties.getIamUri() + "/api/iam/v2/user/role";
        ResponseEntity<UserRoleDTO> roleResponseEntity =  restTemplate.postForEntity(url,httpEntity,UserRoleDTO.class);
        if (roleResponseEntity.getBody()==null){
            return new ArrayList<>();
        }else {
            return roleResponseEntity.getBody().getRoles();
        }
    }

    @Override
    public List<RoleDTO> queryUserRoles(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        Map<String, String> param = new HashMap<>();
        param.put("id",userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(param,headers);

        String url = envProperties.getIamUri() + IamApiConstant.USER_ROLE;
        ResponseEntity<UserRoleDTO> roleResponseEntity =  restTemplate.postForEntity(url,httpEntity,UserRoleDTO.class);
        if (roleResponseEntity.getBody()==null){
            return new ArrayList<>();
        }else {
            return roleResponseEntity.getBody().getRoles();
        }
    }

   /* @Override
    public RoleDTO query(String id, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        Map<String, String> param = new HashMap<>();
        param.put("id",id);
        HttpEntity httpEntity = new HttpEntity<>(param,headers);

        String url = envProperties.getIamUri() + IamApi.ROLE;
        ResponseEntity<RoleDTO> roleResponseEntity =  restTemplate.postForEntity(url,httpEntity,RoleDTO.class);
        if (roleResponseEntity.getBody()==null){
            return null;
        }else {
            return roleResponseEntity.getBody();
        }
    }
    @Override
    public RoleDTO query(String id) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> param = new HashMap<>();
        param.put("id",id);
        HttpEntity httpEntity = new HttpEntity<>(param,headers);

        String url = envProperties.getIamUri() + IamApi.ROLE;
        ResponseEntity<RoleDTO> roleResponseEntity =  restTemplate.postForEntity(url,httpEntity,RoleDTO.class);
        if (roleResponseEntity.getBody()==null){
            return null;
        }else {
            return roleResponseEntity.getBody();
        }
    }*/
}
