package com.digiwin.athena.atmc.http.restful.iam.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mchange.v2.util.CollectionUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TenantBizUnitDTO extends BaseResult {
    private List<BizUnitDTO> data;

    /**
     * 租户所属公司是否有且仅有一个运营单元
     *
     * @return
     */
    @JsonIgnore
    public boolean isTenantHasOnlyOneBizUnit() {
        return CollectionUtils.size(data) == 1;
    }
}
