package com.digiwin.athena.atmc.http.restful.ptm.controller;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.KgApiConstant;
import com.digiwin.athena.atmc.http.constant.ManualTaskConstant;
import com.digiwin.athena.atmc.http.restful.HttpAssistantServiceImpl;
import com.digiwin.athena.atmc.http.restful.ptm.model.ProjectCardItemSimpleInfoDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: xusj
 * @date: 2023/6/27 13:42
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/atmc/v1/test")
public class TestController {

    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;

    @Autowired
    RestTemplate restTemplate;

    /**
     * 获取PTM-Data，专用于PTM的 submit-data Action
     * @return
     */
    @GetMapping("/errorCode")
    ResponseEntity<?> getPtmData(
            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        String uri = "http://localhost:22100/api/ai/v1/bot/template/task/show/PWD_purchaseChangeOrder_userProject/ReplyPurchaseChangeDeliveryDate/321214502461568";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        Map<String, String> param = new HashMap<>();
        param.put("taskId", "PWD_purchaseChangeOrder_userProject");
        param.put("activityId", "ReplyPurchaseChangeDeliveryDate");
        param.put("pageCode", "task-detail");
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<BaseResultDTO<TmActivityResponseDTO>> responseEntity = null;

        return responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<TmActivityResponseDTO>>() {
                }, param);
//        throw new ResourceAccessException("测试网络异常");

    }
}
