package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 待办数据类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmBacklogItemDTO {

    private Long backlogId;
    private Long workItemId;
    /**
     * 相当于 bpm_activity_step.id
     */
    private Long activityId;
    /**
     * 相当于 bpm_activity.id
     */
    private Long taskId;
    /**
     * 相当于 bpm_process.id
     */
    private Long projectId;
    /**
     * 相当于 task.id
     */
    private Long projectCardId;
    private String taskName;
    private String performerId;
    private String performerName;
    private Boolean exception;
    private String taskDefCode;
    private String taskDefName;
    private String taskDefCategory;
    private String taskDefPattern;
    private String taskDefExecuteType;
    private String bpmnType;
    private LocalDateTime createTime;
    private LocalDateTime planEndTime;
    private LocalDateTime closedTime;
    private String signReason;
    private Integer state;
    private Boolean closed;
    private Map data;
    private Map businessUnit;
}
