package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * PTM 任务卡列表 中的 任务卡数据
 * @author zhujg
 * @date 2022-01-28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmTaskCardItemDTO {

    private Long backlogId;
    private Long workItemId;
    private Long activityId;
    private Long taskId;
    private Long projectId;
    private Long projectCardId;
    private String performerId;
    private String performerName;
    private Integer performerType;
    /**
     * 是否是合并任务
     */
    private Boolean merge;

    private LocalDateTime createTime;

    /**
     * 待办所属租户id，这个待办是发给哪个租户的。
     */
    private String tenantId;

    /**
     * 待办的来源租户id。主要适用于跨租户的待办
     * <br>其他待办，这个值应该同 tenantId
     */
    private String fromTenantId;

    private String projectDefCode;
    private String projectDefName;
    private String projectName;

    private String taskName;
    private String taskType;
    private String taskDefPattern;
    private String taskDefCategory;
    private String taskDefExecuteType;
    private String taskDefCode;
    private String taskDefName;
    private LocalDateTime taskCreateTime;

    private String signReason;
    private LocalDateTime planEndTime;
    private String proxyToken;
    private String activityName;
    private String signType;
    private String bpmnType;
    private String bpmActivityId;
    private String bpmActivityName;

    private String targetTenantId;

    private Boolean closed;

    /**
     * 任务卡关闭时间
     */
    private LocalDateTime closedTime;
    /**
     * 任务卡所属任务关闭时间
     */
    private LocalDateTime taskClosedTime;

}
