package com.digiwin.athena.atmc.http.restful.thememap.model;

import com.digiwin.athena.atmc.http.domain.action.SubmitType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * @description: ThemeMap任务定义Page中的dataState，用于替换以前的TmPage内容
 * @author: zhujg
 * @create: 2021-03-02 14:31
 **/
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TmDataState {

    /**
     * 主键，必须有
     */
    private String code;

    /**
     * P4S1配置设计器结构调整至DataState
     * 是否缓存summaryLayout，默认为true
     */
    private Boolean cardCache;

    /**
     * 是否需要起定时任务刷新任务卡message
     */
    private Boolean scheduleRefreshCardMessage;

    /**
     * P4S1配置设计器结构调整至DataState
     * 自定义标签
     */
    private List<TmSummaryFieldDTO> summaryFields;

    /**
     * P4S1配置设计器结构调整至DataState
     * 项目卡通过API获取项目是否逾期时，API表示逾期的字段名
     */
    private String overduePropertyName;


    /**
     * 扩展字段，临时存放
     * 目前在模板中使用，以后需要重新定义结构
     */
    private Map<String,Object> extendedFields;

    /**
     * 提交的逻辑家，是否多选，以及提交的数据源
     */
    private SubmitType submitType;


    /**
     * 勾选是否合并选择
     * 老表格的合并单元格的功能。。。。。。待废弃
     * 就是有合併單元格的時候
     * 勾選欄要不要合併
     */
    private Boolean multipleSelectMerge;

    /**
     * table 分组设置
     */
    private JSONObject settings;


    /**
     * 提交的数据schema集合，不指定表示提交全部数据
     * <br>指定后，提交时只提交指定的数据
     */
    private List<String> submitSchemas;

    /**
     * 是否合并查询所有的任务数据,主要是项目卡里需要显示n个任务的数据，合并查询提高效率
     */
    private Boolean mergeQuery;

    /**
     * 启用分页
     */
    private Boolean enablePaging;

    /**
     * 分页是否启用后端分页true：使用后端  false或者为null。使用前端分页
     */
    private Boolean enableBackEndPaging;

    /**
     *  是否增量地提交，如果不是增量，name提交的是全部数据
     */
    private Boolean enableCombinedPost;

}
