package com.digiwin.athena.atmc.http.restful.thememap.model;

import com.baomidou.mybatisplus.core.enums.IEnum;

/**
 * themeMap 任务、项目定义中 page 名称的枚举
 */
public enum TmPageName implements IEnum<String> {

    /**
     * 项目卡
     */
    PROJECT_CARD_NAME("project-card"),

    /**
     * 项目详情
     */
    PROJECT_DETAIL_NAME("project-detail"),

    /**
     * 任务卡
     */
    TASK_CARD_NAME("task-card"),

    /**
     * 任务详情
     */
    TASK_DETAIL_NAME("task-detail");

    private String category;

    TmPageName(String category){
        this.category = category;
    }

    public String getCategory(){
        return getValue();
    }

    @Override
    public String getValue() {
        return category;
    }
}
