/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.abt.impl;

import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.HttpAssistantServiceImpl;
import com.digiwin.athena.atmc.http.restful.abt.AbtService;
import com.digiwin.athena.atmc.http.restful.abt.model.RefreshCardMessageDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class AbtServiceImpl
implements AbtService {
    private static final Logger log = LoggerFactory.getLogger(AbtServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;

    @Override
    public void createRefreshCardMessageJob(RefreshCardMessageDTO refreshCardMessageDTO) {
        String url = this.envProperties.getAbtUri() + "/api/abt/v1/refresh/card/message/job/createIfAbsent";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        log.info("create refresh card message job{}, {}", (Object)refreshCardMessageDTO.getId(), (Object)refreshCardMessageDTO);
        Boolean success = this.httpAssistantService.post(new TypeReference<Boolean>(){}, url, headers, refreshCardMessageDTO);
        log.info("create refresh card message job{}, {}, ret{}", new Object[]{refreshCardMessageDTO.getId(), refreshCardMessageDTO, success});
    }
}

