/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.audc.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.audc.AudcService;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesAccessibleDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AudcServiceImpl
implements AudcService {
    private static final Logger log = LoggerFactory.getLogger(AudcServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public Map<String, Object> deleteByTenantId(AuthoredUser authoredUser, String tenantId) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtil.isEmpty((String)tenantId)) {
            return resultMap;
        }
        String uri = this.envProperties.getAudcUri() + AtmcStrUtil.format("/api/audc/v1/cofw/deleteByTenant/{tenantId}", tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultMap = (Map)((BaseResultDTO)responseEntity.getBody()).getResponse();
            } else {
                log.error(this.messageUtils.getMessage("exception.audc.delete.snapshot.fail"), (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error(this.messageUtils.getMessage("exception.audc.delete.snapshot.fail"), (Object)e.getMessage());
        }
        return resultMap;
    }

    @Override
    public void clearCache() {
        String url = this.envProperties.getAudcUri() + "/api/cache/reset";
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<TypeActivitiesAccessibleDTO> checkAccessActivity(AuthoredUser authoredUser, List<TypeActivitiesDTO> typeActivitiesList) {
        List resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(typeActivitiesList)) {
            return resultList;
        }
        String uri = this.envProperties.getAudcUri() + "/api/audc/v1/check/activity/accessible";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString(typeActivitiesList), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TypeActivitiesAccessibleDTO>>>(){}, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultList = (List)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponse();
            } else {
                log.error(this.messageUtils.getMessage("exception.audc.delete.snapshot.fail"), (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error(this.messageUtils.getMessage("exception.audc.delete.snapshot.fail"), (Object)e.getMessage());
        }
        return resultList;
    }
}

