/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.tenant.WithTenantRespDto;
import com.digiwin.athena.atmc.http.domain.usersetting.BaseUserSettingDto;
import com.digiwin.athena.atmc.http.domain.usersetting.PersonalizedDto;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.eoc.EocService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.InnerExistDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.ProxyUserDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.ReplyInviteResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserAcceptContactsDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTOWithCode;
import com.digiwin.athena.atmc.http.restful.iam.model.UserLangMetadataDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserMetadataDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.sf.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private EocService eocService;
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    public static final String CATALOG_ID = "basic";
    public static final String MESSAGE_NOTICE_TYPE_KEY = "MessageSendType";

    @Override
    public UserDTO query(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/full";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTO.class, new Object[0]);
        return (UserDTO)responseEntity.getBody();
    }

    @Override
    public UserDTO query(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/full";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTO.class, new Object[0]);
        UserDTO userDTO = (UserDTO)responseEntity.getBody();
        if (userDTO == null || StringUtils.isEmpty((Object)userDTO.getId())) {
            log.error("[IAM] \u67e5\u8be2 " + userId + " \u7684\u7528\u6237\u4fe1\u606f\u5931\u8d25,  {}", (Object)userDTO);
            userDTO = null;
        }
        return userDTO;
    }

    @Override
    public UserDTO queryByEmail(String email) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("email", email);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/email";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTOWithCode.class, new Object[0]);
        if (responseEntity.getBody() != null && ((UserDTOWithCode)responseEntity.getBody()).getCode() == 200) {
            return ((UserDTOWithCode)responseEntity.getBody()).getData();
        }
        return null;
    }

    @Override
    public UserDTO queryByPhone(String phone) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("telephone", phone);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/telephone";
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTOWithCode.class, new Object[0]);
            if (responseEntity.getBody() != null && ((UserDTOWithCode)responseEntity.getBody()).getCode() == 200) {
                return ((UserDTOWithCode)responseEntity.getBody()).getData();
            }
        }
        catch (Exception e) {
            logger.error("queryByPhone error params:{}", param, (Object)e);
            return null;
        }
        return null;
    }

    @Override
    public UserDTO queryByEmail(String email, String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("email", email);
        param.put("tenantId", tenantId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/email";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTOWithCode.class, new Object[0]);
        if (responseEntity.getBody() != null && ((UserDTOWithCode)responseEntity.getBody()).getCode() == 200) {
            return ((UserDTOWithCode)responseEntity.getBody()).getData();
        }
        return null;
    }

    @Override
    public UserDTO queryByPhone(String phone, String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("telephone", phone);
        param.put("tenantId", tenantId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/telephone";
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserDTOWithCode.class, new Object[0]);
            if (responseEntity.getBody() != null && ((UserDTOWithCode)responseEntity.getBody()).getCode() == 200) {
                return ((UserDTOWithCode)responseEntity.getBody()).getData();
            }
        }
        catch (Exception e) {
            logger.error("queryByPhone error params:{}", param, (Object)e);
            return null;
        }
        return null;
    }

    @Override
    public UserDTO query(String mappingApp, String account, String verifyUserId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("identityId", mappingApp);
        param.put("verifyUserId", verifyUserId);
        if (!StringUtils.isEmpty((Object)account)) {
            param.put("account", account);
        }
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/mapping/query/appuser";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (body == null) {
            return null;
        }
        String userId = body.get("userId").toString();
        return this.query(userId, token);
    }

    @Override
    public String getUserLangNameByUserId(String userId, String tenantId, String token) {
        return this.getUserLangMetadataAllTenant(userId, token);
    }

    @Override
    public boolean getMessageDoNotDisturbUserId(String userId, String tenantId, String token) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", token);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("userId", userId);
            param.put("catalogId", CATALOG_ID);
            param.put("key", "doNotDisturb");
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            String url = this.envProperties.getIamUri() + "/api/iam/v2/user/metadata/value";
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            Map result = (Map)responseEntity.getBody();
            if (result.containsKey("data")) {
                return "1".equals(result.get("data").toString());
            }
            return false;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    @Override
    public UserDTO getTargetUser(String userId, String token) {
        UserDTO targetUser = null;
        ProxyUserDTO proxyUserDTO = this.eocService.getProxyUser(userId, token);
        if (proxyUserDTO != null && StringUtils.hasText((String)proxyUserDTO.getUserId())) {
            targetUser = this.query(proxyUserDTO.getUserId(), token);
        }
        if (targetUser == null) {
            targetUser = this.query(userId, token);
        }
        return targetUser;
    }

    @Override
    public String getUserAcceptContacts(String userId, Long tenantSid, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("tenantSid", tenantSid);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/acceptcontacts/get";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserAcceptContactsDTO.class, new Object[0]);
        UserAcceptContactsDTO baseResult = (UserAcceptContactsDTO)responseEntity.getBody();
        if (baseResult.getCode() == 200) {
            return baseResult.getData();
        }
        return null;
    }

    @Override
    public UserMetadataDTO getUserMetadataAllTenant(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/current";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserMetadataDTO.class, new Object[0]);
        return (UserMetadataDTO)responseEntity.getBody();
    }

    @Override
    public String getUserLangMetadataAllTenant(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        log.info("getUserLangMetadataAllTenant-userId:{}", (Object)userId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("catalogId", CATALOG_ID);
        params.put("key", "dapAcceptLanguage");
        params.put("userId", userId);
        params.put("tenantSid", 0);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        log.info("{}.{}", (Object)token, (Object)JsonUtils.objectToString(params));
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get";
        try {
            UserLangMetadataDTO baseResult;
            ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserLangMetadataDTO.class, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && null != (baseResult = (UserLangMetadataDTO)respEntity.getBody()) && HttpStatus.OK.value() == baseResult.getCode().intValue()) {
                Optional<Object> langOpt = Optional.ofNullable(baseResult.getData()).map(data -> data.get("value"));
                return langOpt.isPresent() ? String.valueOf(langOpt.get()) : this.defaultLanguage();
            }
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)JsonUtils.objectToString((Object)respEntity.getBody()));
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42body\u4f53\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a", new Object[]{ErrorCodeEnum.IAM_GET_USERMETADATA_FAIL.getErrCode(), JsonUtils.objectToString(params), ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.IAM_GET_USERMETADATA_FAIL.getErrCode(), (Exception)ex);
        }
    }

    private String defaultLanguage() {
        return org.apache.commons.lang.StringUtils.equals((String)"SIMPLIFIED_CHINESE", (String)this.envProperties.getDefaultLanguage()) ? Locale.SIMPLIFIED_CHINESE.toString() : Locale.TRADITIONAL_CHINESE.toString();
    }

    @Override
    public UserMetadataDTO getUserMetadataInAllTenant(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/all";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserMetadataDTO.class, new Object[0]);
        return (UserMetadataDTO)responseEntity.getBody();
    }

    @Override
    public ReplyInviteResultDTO replyInvite(String email, String tenantId, String appCode, String locale) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (locale != null) {
            headers.add("locale", locale);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userEmail", email);
        params.put("tenantId", tenantId);
        params.put("inviteApp", appCode);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/user/invite/new";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ReplyInviteResultDTO.class, new Object[0]);
        return (ReplyInviteResultDTO)responseEntity.getBody();
    }

    @Override
    public InnerExistDTO emailInnerExist(String email) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/email/without/inner/exist";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, InnerExistDTO.class, new Object[0]);
        return (InnerExistDTO)responseEntity.getBody();
    }

    @Override
    public InnerExistDTO phoneInnerExist(String phone) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("telephone", phone);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/mobilephone/without/inner/exist";
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, InnerExistDTO.class, new Object[0]);
        InnerExistDTO baseResult = (InnerExistDTO)responseEntity.getBody();
        try {
            this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("getUserPhoneIsExit error params:{}", params, (Object)e);
            return baseResult;
        }
        return baseResult;
    }

    @Override
    public PersonalizedDto queryPersonalizedInfo(Long tenantSid, String userId, String key, String catalogId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantSid", tenantSid);
        param.put("userId", userId);
        param.put("catalogId", catalogId);
        param.put("key", key);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        log.info("[UserServiceImpl.queryPersonalizedInfo],param :{},headers :{}", param, (Object)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get";
        ResponseEntity dataEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, BaseUserSettingDto.class, new Object[0]);
        if (dataEntity.getBody() == null) {
            logger.error("can not find user meta response body  with:{}", param);
            return null;
        }
        if (((BaseUserSettingDto)dataEntity.getBody()).getData() == null) {
            logger.error("can not find user meta response data  with:{}", param);
            return null;
        }
        BaseUserSettingDto baseDto = (BaseUserSettingDto)dataEntity.getBody();
        return (PersonalizedDto)JsonUtils.jsonToObject((String)JsonUtils.objectToString(baseDto.getData()), PersonalizedDto.class);
    }

    @Override
    public int updatePersonalizedInfo(String userId, List<Object> metaList) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", userId);
        param.put("metadata", metaList);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/update";
        try {
            this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("update user meta data error with param:{}", param, (Object)e);
            return -1;
        }
        return 0;
    }

    @Override
    public String queryUserEmail(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/withtenant";
        try {
            ResponseEntity dataEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, WithTenantRespDto.class, new Object[0]);
            if (dataEntity.getBody() != null) {
                WithTenantRespDto baseDto = (WithTenantRespDto)dataEntity.getBody();
                if (null == baseDto || null == baseDto.getEmail()) {
                    logger.error("Query user email with no data return:{}", (Object)userId);
                    return null;
                }
                return baseDto.getEmail();
            }
        }
        catch (Exception e) {
            logger.error("Query User Email info Error error with param:{}", (Object)userId, (Object)e);
            return null;
        }
        return null;
    }

    @Override
    public String getActualPerformId(String tenantId, String emailAddress, AuthoredUser user) {
        Object response;
        String actualPerformId = "";
        if (StringUtils.isEmpty((Object)emailAddress)) {
            return actualPerformId;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/email";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantId", tenantId);
        paramMap.put("email", emailAddress);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        if (responseEntity.getStatusCode() == HttpStatus.OK && (response = ((Map)responseEntity.getBody()).get("data")) != null && response != "") {
            Map resultMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response), Map.class);
            actualPerformId = (String)resultMap.get("id");
        }
        return actualPerformId;
    }

    @Override
    public ResponseEntity<Map> invoiceTaxno(String unifyNumber, AuthoredUser user) {
        if (StringUtils.isEmpty((Object)unifyNumber)) {
            return null;
        }
        String url = this.envProperties.getIamUri() + AtmcStrUtil.format("/api/iam/v3/invoice/taxno/{unifyNumber}", unifyNumber);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity httpEntity = new HttpEntity(new HashMap(), (MultiValueMap)headers);
        return this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
    }

    @Override
    public List<String> getEmployee(List<String> userList, AuthoredUser user) {
        ArrayList<String> memberList = new ArrayList<String>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/list";
        HttpEntity httpEntity = new HttpEntity(userList, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        if (responseEntity.getStatusCode() == HttpStatus.OK && ((Map)responseEntity.getBody()).get("data") != null) {
            JSONArray jsonArray = JSONArray.fromObject(((Map)responseEntity.getBody()).get("data"));
            for (Object object : jsonArray) {
                Map map = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(object), Map.class);
                if (!"0".equals(map.get("type").toString())) continue;
                String id = this.eocService.getEocEmpInfo(map.get("id").toString(), user);
                memberList.add(id);
            }
        }
        return memberList;
    }
}

