/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.ptm.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.backlog.TerminateTaskDataDTO;
import com.digiwin.athena.atmc.http.domain.task.TaskExceptionDTO;
import com.digiwin.athena.atmc.http.domain.task.mobile.MobileBacklogGroupDTO;
import com.digiwin.athena.atmc.http.domain.task.mobile.MobileProjectGroupDTO;
import com.digiwin.athena.atmc.http.domain.task.mobile.MobilePtmBacklogDTO;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.HttpAssistantServiceImpl;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveRequestDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApprovelDTO;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.ptm.PtmService;
import com.digiwin.athena.atmc.http.restful.ptm.model.BacklogItemSimpleInfoDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.ProjectCardItemSimpleInfoDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmActWithTaskAndProjectDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmActivityRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmActivitySignInformerDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmAgentPerformerDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmAssistBacklogRequestDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogApprovalDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogForProjectCardDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogPartialDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogReassignRequestDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmCheckSupportCrossBkWithdrawReqDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmCheckSupportCrossBkWithdrawRespDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmCheckSupportReturnReqDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmCheckSupportWithdrawReqDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmEmailBacklogRequestDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmLineBacklogDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmLineParamDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectBusinessDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardDetailDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardPanelDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardReassignRequestDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardRouteDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardRouteTaskDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardTaskDetailDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectReportItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmRessignTrace;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmSolveTask;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmSpecialBacklogDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmSubProjectResponseDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskCardDataDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskCardItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskReportItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskWorkItemDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTerminateTaskResultDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWorkItemRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWorkItemV2DTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class PtmServiceImpl
implements PtmService {
    private static final Logger log = LoggerFactory.getLogger(PtmServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    UserService userService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private HttpAssistantServiceImpl httpAssistantService;

    @Override
    public List<PtmProjectCardItemDTO> queryProjectCardList(List<String> userIds) {
        return this.queryProjectCard(userIds, null, null);
    }

    @Override
    public List<PtmProjectCardItemDTO> queryProjectCardListByProjectCardId(List<Long> projectCardIdList, String autherUserId) {
        return this.queryProjectCard(null, projectCardIdList, autherUserId);
    }

    @Override
    public List<ProjectCardItemSimpleInfoDTO> queryProjectCardSimpleInfo(List<String> userIds, Collection<Long> projectCardIds, String authoredUserId) {
        ArrayList projectCards;
        String url = this.envProperties.getPtmUri() + "v2/api/project/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        String userId = StringUtils.isBlank((String)authoredUserId) ? authoredUser.getUserId() : authoredUserId;
        HashMap<String, Collection<Object>> rootPara = new HashMap<String, Collection<Object>>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            rootPara.put("userIds", userIds);
        }
        if (CollectionUtils.isNotEmpty(projectCardIds)) {
            rootPara.put("projectCardIds", projectCardIds);
        }
        return Objects.nonNull(projectCards = this.httpAssistantService.post(new TypeReference<List<ProjectCardItemSimpleInfoDTO>>(){}, url, headers, rootPara)) ? projectCards : Lists.newArrayList();
    }

    @Override
    public List<BacklogItemSimpleInfoDTO> queryBackCardSimpleInfo(List<String> userIds, List<Long> backlogIds, String authoredUserId) {
        ArrayList backlogCards;
        String url = this.envProperties.getPtmUri() + "v2/api/task/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        String userId = StringUtils.isBlank((String)authoredUserId) ? authoredUser.getUserId() : authoredUserId;
        HashMap<String, List<Object>> rootPara = new HashMap<String, List<Object>>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            rootPara.put("userIds", userIds);
        }
        if (CollectionUtils.isNotEmpty(backlogIds)) {
            rootPara.put("backlogIds", backlogIds);
        }
        return Objects.nonNull(backlogCards = this.httpAssistantService.post(new TypeReference<List<BacklogItemSimpleInfoDTO>>(){}, url, headers, rootPara)) ? backlogCards : Lists.newArrayList();
    }

    private List<PtmProjectCardItemDTO> queryProjectCard(List<String> userIds, List<Long> projectCardIdList, String autherUserId) {
        List<PtmProjectCardItemDTO> result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        log.info("queryProjectCard-authoredUser:{}", (Object)JsonUtils.objectToString((Object)authoredUser));
        headers.add("token", authoredUser.getToken());
        String userId = StringUtils.isBlank((String)autherUserId) ? authoredUser.getUserId() : autherUserId;
        HashMap<String, List<Object>> rootPara = new HashMap<String, List<Object>>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            rootPara.put("userIds", userIds);
        }
        if (CollectionUtils.isNotEmpty(projectCardIdList)) {
            rootPara.put("projectCardIds", projectCardIdList);
        }
        if ((result = this.httpAssistantService.post(new TypeReference<List<PtmProjectCardItemDTO>>(){}, url, headers, rootPara)) == null) {
            result = new ArrayList<PtmProjectCardItemDTO>();
        }
        return result;
    }

    @Override
    public PtmProjectCardDetailDTO getProjectCardDetail(Long projectCardId) {
        PtmProjectCardDetailDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/detail?id={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardDetailDTO>>(){}, param);
        result = (PtmProjectCardDetailDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardTaskDetailDTO> getProjectCardDetail(Long projectCardId, String taskDefCode) {
        ArrayList result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/detail";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("projectCardId", projectCardId);
        rootPara.put("taskDefCode", taskDefCode);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardTaskDetailDTO>>>(){}, rootPara);
        result = (ArrayList)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    @Override
    public List<PtmProjectCardRouteDTO> getProjectCardRoutes(Long projectCardId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/routes?projectCardId={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardRouteDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmProjectCardRouteDTO getProjectRoute(Long projectId) {
        PtmProjectCardRouteDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/project/routes?id={projectId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectId", projectId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardRouteDTO>>(){}, param);
        result = (PtmProjectCardRouteDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardRouteTaskDTO> getProjectCardRouteTasks(List<Long> projectIds, String routeTasks) {
        ArrayList result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/route-tasks";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("projectIds", projectIds);
        rootPara.put("routeTasks", routeTasks);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardRouteTaskDTO>>>(){}, rootPara);
        result = (ArrayList)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    @Override
    public Boolean setDefaultRoute(Long defaultRouteId) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/route/selected?id={defaultRouteId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("defaultRouteId", defaultRouteId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, param);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardItemDTO> queryTaskCardList(List<String> userIds) {
        List<PtmTaskCardItemDTO> result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, List<String>> rootPara = new HashMap<String, List<String>>();
        rootPara.put("userIds", userIds);
        result = this.httpAssistantService.post(new TypeReference<List<PtmTaskCardItemDTO>>(){}, url, headers, rootPara);
        if (result == null) {
            result = new ArrayList<PtmTaskCardItemDTO>();
        }
        return result;
    }

    @Override
    public List<PtmTaskCardItemDTO> queryTaskCardListByBacklogId(List<Long> backlogIdList) {
        ArrayList result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/processing/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("backlogIds", backlogIdList);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardItemDTO>>>(){}, rootPara);
        result = (ArrayList)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    @Override
    public List<PtmBacklogItemDTO> getBacklogByProjectIdAndTaskCode(Long projectId, String taskDefCode) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task-by-condition/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("projectId", projectId);
        rootPara.put("taskDefCode", taskDefCode);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogItemDTO> getBacklogByProjectCardIdAndTaskCode(Long projectCardId, String taskDefCode) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task-by-condition/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("projectCardId", projectCardId);
        rootPara.put("taskDefCode", taskDefCode);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogItemDTO> getBacklogByBacklogId(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task/list?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogItemDTO> getBacklogByBacklogIds(List<Long> backlogIdList) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/task/list/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("backlogIds", backlogIdList);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogItemDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean reassignProjectCard(PtmProjectCardReassignRequestDTO requestDTO) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/reassign";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("projectCardId", requestDTO.getProjectCardId());
        rootPara.put("newPersonInCharge", requestDTO.getNewPersonInCharge());
        rootPara.put("newPersonInChargeName", requestDTO.getNewPersonInChargeName());
        rootPara.put("comment", requestDTO.getComment());
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean reassignBacklog(PtmBacklogReassignRequestDTO requestDTO) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/reassign";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("backlogId", requestDTO.getBacklogId());
        rootPara.put("newPerformerId", requestDTO.getNewPerformerId());
        rootPara.put("newPerformerName", requestDTO.getNewPerformerName());
        rootPara.put("comment", requestDTO.getComment());
        log.info("reassignBacklog\uff0cdata\uff1a{}", (Object)JsonUtils.objectToString(rootPara));
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmProjectCardRecordDTO getProjectCardRecord(Long projectCardId) {
        PtmProjectCardRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/project/card?id={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardRecordDTO>>(){}, param);
        result = (PtmProjectCardRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardRecordDTO> getProjectCardRecordByProjectCardIds(List<Long> projectCardIds) {
        ArrayList<PtmProjectCardRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/project/card/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("idList", projectCardIds);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardRecordDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardRecordDTO> getProjectCardByCondition(Map condition) {
        ArrayList<PtmProjectCardRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "v2/api/data/sub-project-card/list-by-condition";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)condition, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardRecordDTO>>>(){}, condition);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectRecordDTO> getLastProjectRecordByProjectCardIds(List<Long> projectCardIds) {
        ArrayList<PtmProjectRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/project/card/processing/latest-project/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("projectCardIds", projectCardIds);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmProjectRecordDTO getProjectRecord(Long projectId) {
        PtmProjectRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/project?id={projectId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectId", projectId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectRecordDTO>>(){}, param);
        result = (PtmProjectRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectRecordDTO> getProjectRecordByProjectIds(List<Long> projectIds) {
        return this.getProjectRecordByProjectIdsV2(projectIds, true);
    }

    @Override
    public List<PtmProjectRecordDTO> getProjectRecordByProjectIdsV2(List<Long> projectIds, boolean needData) {
        String url = this.envProperties.getPtmUri() + "api/data/project/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", projectIds);
        rootPara.put("needData", needData);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectRecordDTO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmTaskRecordDTO getTaskRecord(Long taskId) {
        PtmTaskRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task?id={taskId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("taskId", taskId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmTaskRecordDTO>>(){}, param);
        result = (PtmTaskRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskRecordDTO> getTaskRecordByTaskIds(List<Long> taskIds) {
        String url = this.envProperties.getPtmUri() + "api/data/task/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", taskIds);
        rootPara.put("needData", false);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskRecordDTO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskRecordDTO> getTaskRecordByTaskIds(List<Long> taskIds, boolean needData) {
        String url = this.envProperties.getPtmUri() + "api/data/task/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("idList", taskIds);
        rootPara.put("needData", needData);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskRecordDTO>>>(){}, rootPara);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmActivityRecordDTO getActivityRecord(Long activityId) {
        PtmActivityRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/activity?id={activityId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("activityId", activityId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmActivityRecordDTO>>(){}, param);
        result = (PtmActivityRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmActivityRecordDTO> getActivityRecordByActivityIds(List<Long> activityIds) {
        ArrayList<PtmActivityRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("idList", activityIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmActivityRecordDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmWorkItemRecordDTO getWorkItemRecord(Long workItemId) {
        PtmWorkItemRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item?id={workItemId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("workItemId", workItemId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmWorkItemRecordDTO>>(){}, param);
        result = (PtmWorkItemRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmWorkItemRecordDTO> getWorkItemRecordByWorkItemIds(List<Long> workItemIds) {
        ArrayList<PtmWorkItemRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("idList", workItemIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmWorkItemRecordDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmWorkItemRecordDTO getReExecuteWorkItem(Integer type, Long workItemId, String approvalTaskCode) {
        PtmWorkItemRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/previous/item";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("id", workItemId);
        rootPara.put("type", type);
        if (StringUtils.isNotBlank((String)approvalTaskCode)) {
            rootPara.put("taskDefCode", approvalTaskCode);
        }
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmWorkItemRecordDTO>>(){}, rootPara);
        result = (PtmWorkItemRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmBacklogRecordDTO getBacklogRecord(Long backlogId) {
        PtmBacklogRecordDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item/backlog?id={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmBacklogRecordDTO>>(){}, param);
        result = (PtmBacklogRecordDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogRecordDTO> getBacklogRecordByBacklogIds(List<Long> backlogIds) {
        ArrayList<PtmBacklogRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/task/activity/item/backlog/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("idList", backlogIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogRecordDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardDataDTO> getTaskDataByBacklogId(Long backlogId, String type) {
        return this.getTaskData(backlogId, null, null, type);
    }

    public List<PtmTaskCardDataDTO> getTaskData(Long backlogId, Long activityId, Long taskId, String type) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/data";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        if (Objects.nonNull(backlogId)) {
            rootPara.put("backlogId", backlogId);
        }
        if (Objects.nonNull(activityId)) {
            rootPara.put("activityId", activityId);
        }
        if (Objects.nonNull(taskId)) {
            rootPara.put("taskId", taskId);
        }
        rootPara.put("type", type);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardDataDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmTaskCardDataDTO getTaskDataByActivityId(Long activityId, String type) {
        List<PtmTaskCardDataDTO> result = this.getTaskData(null, activityId, null, type);
        if (CollectionUtils.isNotEmpty(result)) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public PtmTaskCardDataDTO getTaskDataByTaskId(Long taskId, String type) {
        List<PtmTaskCardDataDTO> result = this.getTaskData(null, null, taskId, type);
        if (CollectionUtils.isNotEmpty(result)) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public Boolean updateStateData(Long activityId, Object stateData) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/data-state/update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("activityId", activityId);
        rootPara.put("dataState", stateData);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean updateData(Long activityId, Object data) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/data/update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("activityId", activityId);
        rootPara.put("data", data);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public void resetBpmDataForTerminateTaskData(Map data) {
        this.resetBpmData("TerminateTaskData", data);
    }

    @Override
    public void resetBpmDataForReassignTaskData(Map data) {
        this.resetBpmData("ReassignTaskData", data);
    }

    private void resetBpmData(String action, Map data) {
        String url = this.envProperties.getPtmUri() + AtmcStrUtil.format("api/business/execute/{action}", action);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, data);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public LocalDateTime getProjectCardLastModifyTime(String userId) {
        LocalDateTime result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/processing/latest-time?userId={userId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<LocalDateTime>>(){}, param);
        result = (LocalDateTime)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public LocalDateTime getBacklogLastModifyTime(String userId) {
        LocalDateTime result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/processing/latest-time?userId={userId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<LocalDateTime>>(){}, param);
        result = (LocalDateTime)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean addCrossTenantBacklog(PtmEmailBacklogRequestDTO emailRequest) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/cross-tenant/add";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("workItemId", emailRequest.getWorkItemId());
        rootPara.put("performerId", emailRequest.getPerformerId());
        rootPara.put("performerName", emailRequest.getPerformerName());
        rootPara.put("tenantId", emailRequest.getTenantId());
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean addAssistBacklog(PtmAssistBacklogRequestDTO assistRequest) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/assist/add";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("workItemId", assistRequest.getWorkItemId());
        rootPara.put("performerId", assistRequest.getPerformerId());
        rootPara.put("performerName", assistRequest.getPerformerName());
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean batchUpdateProjectInfo(Map param) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/data/project/update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, param);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean batchUpdateBacklogInfo(Map param) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, param);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean closeProjectCard(Map<String, Object> map) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/close";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.putAll(map);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean batchTerminateTask(Map param) {
        Boolean result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/terminate";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmTerminateTaskResultDTO>>(){}, param);
        result = ((PtmTerminateTaskResultDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("")).getSuccess();
        return result;
    }

    @Override
    public List<PtmBacklogPartialDTO> queryBacklogPartialByTaskIds(List<Long> taskIds) {
        ArrayList<PtmBacklogPartialDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/task/backlog/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("taskIds", taskIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogPartialDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectReportItemDTO> queryProjectReport(Map<String, Object> param) {
        ArrayList<PtmProjectReportItemDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/task/card/item/report";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectReportItemDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskReportItemDTO> queryProjectTaskReport(Map<String, Object> param) {
        ArrayList<PtmTaskReportItemDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/task/card/project/report";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskReportItemDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<Map> getSolveTaskList(List<Long> originalBacklogIds) {
        ArrayList<Map> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/task/card/solve/task-list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("originalBacklogIds", originalBacklogIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public void updateSignInformNotice(Long activityId, Map informer) {
        String url = this.envProperties.getPtmUri() + "api/task/card/approve/informer/update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("activityId", activityId);
        param.put("informer", informer);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, param);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<PtmActivitySignInformerDTO> getSignInformer(List<String> bpmActivityUids) {
        ArrayList<PtmActivitySignInformerDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/task/card/approve/informer";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("bpmActivityUids", bpmActivityUids);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmActivitySignInformerDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogApprovalDTO> queryApproval(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/sign/process?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogApprovalDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new ArrayList() : result;
    }

    @Override
    public List<PtmBacklogApprovalDTO> queryApprovalNew(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/backlog/sign/process?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogApprovalDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new ArrayList() : result;
    }

    @Override
    public List<PtmBacklogApprovalDTO> queryApprovalByWorkItemId(Long workItemId) {
        ResponseEntity responseEntity;
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/approve/process?workItemId={workItemId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("workItemId", workItemId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogApprovalDTO>>>(){}, param);
        }
        catch (Exception e) {
            log.error("[atmc\u8bbf\u95eePTM\u83b7\u53d6 \u7b7e\u6838\u5386\u7a0b] error:{}, stack:{}, workItemId:{}", new Object[]{e, e.getStackTrace(), workItemId});
            String message = MessageFormat.format(this.messageUtils.getMessage("exception.ptm.find.sign.process.by.workitemid"), workItemId);
            throw BusinessException.create((Integer)599, (String)"599", (Object)message, (String)e.getMessage(), (String)this.messageUtils.getMessage("exception.ptm.find.sign.process.by.workitemid"), (Throwable)e);
        }
        List<PtmBacklogApprovalDTO> result = ((BaseResultDTO)responseEntity.getBody()).isOK() && ((BaseResultDTO)responseEntity.getBody()).getResponse() != null ? (List)((BaseResultDTO)responseEntity.getBody()).getResponse() : new ArrayList<PtmBacklogApprovalDTO>();
        return result;
    }

    @Override
    public List<PtmSubProjectResponseDTO> getSubProject(Long projectId, List<String> taskCodes) {
        List result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/business/execute/query-subProject-by-projectCardId-taskCode";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("projectCardId", projectId);
        p.put("taskCodes", taskCodes);
        HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>();
        param.put("data", p);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmSubProjectResponseDTO>>>(){}, new HashMap());
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new ArrayList() : result;
    }

    @Override
    public List<Long> getCompleteAgentBacklog(String agentPerformerId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "api/task/card/agent/backlog?agentPerformId={agentPerformId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("agentPerformId", agentPerformerId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Long>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result == null ? new ArrayList() : result;
    }

    @Override
    public PtmProjectCardPanelDTO getProjectCardPanel(Long projectCardId) {
        PtmProjectCardPanelDTO result = null;
        String url = this.envProperties.getPtmUri() + "api/project/card/panel?id={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectCardPanelDTO>>(){}, param);
        result = (PtmProjectCardPanelDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public void checkTaskSupportWithdraw(PtmCheckSupportWithdrawReqDTO allowRetrieveReqDTO) {
        String url = this.envProperties.getPtmUri() + "api/task/card/is-taskWithdraw";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)allowRetrieveReqDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Integer>>(){}, new Object[0]);
            if (HttpStatus.OK.value() != respEntity.getStatusCodeValue() || null == respEntity.getBody() || !((BaseResultDTO)respEntity.getBody()).isOK()) {
                log.error("[ptm-task-withdraw-{}] atmc\u8bbf\u95eePTM\u5224\u65ad\u4efb\u52a1\u662f\u5426\u652f\u6301\u64a4\u56de\u51fa\u73b0\u5f02\u5e38, data: {}, \u54cd\u5e94\u5185\u5bb9: {}", new Object[]{allowRetrieveReqDTO.getBacklogId(), JsonUtils.objectToString((Object)allowRetrieveReqDTO), JsonUtils.objectToString((Object)respEntity.getBody())});
                String message = this.messageUtils.getMessage("exception.ptm.is.allow.withdraw");
                BusinessException ex = BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)ErrorCodeEnum.CHECK_TASK_WITHDRAW_ERROR.getErrCode(), (String)message);
                ex.setDescription(JsonUtils.objectToString((Object)respEntity.getBody()));
                throw ex;
            }
        }
        catch (HttpServerErrorException ex) {
            if (HttpStatus.INTERNAL_SERVER_ERROR.value() == ex.getStatusCode().value()) {
                BaseResultDTO baseResultDTO = null;
                try {
                    baseResultDTO = (BaseResultDTO)JsonUtils.jsonToObject((String)ex.getResponseBodyAsString(), (TypeReference)new TypeReference<BaseResultDTO>(){});
                }
                catch (Exception exception) {
                    baseResultDTO = null;
                }
                if (null != baseResultDTO) {
                    throw BusinessException.create((Integer)baseResultDTO.getStatus(), (String)baseResultDTO.getErrorCode(), (Object)baseResultDTO.getErrorMessage(), (String)baseResultDTO.getDescription(), (String)baseResultDTO.getStatusDescription(), (String)ErrorTypeEnum.BUSINESS.getValue(), (Throwable)ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public PtmCheckSupportCrossBkWithdrawRespDTO checkTaskSupportCrossBkWithdraw(List<PtmCheckSupportCrossBkWithdrawReqDTO> allowRetrieveReqDTOList) {
        PtmCheckSupportCrossBkWithdrawRespDTO result = new PtmCheckSupportCrossBkWithdrawRespDTO();
        String url = this.envProperties.getPtmUri() + "api/task/card/data/revoke/validate";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<PtmCheckSupportCrossBkWithdrawReqDTO>> paramMap = new HashMap<String, List<PtmCheckSupportCrossBkWithdrawReqDTO>>();
        paramMap.put("params", allowRetrieveReqDTOList);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmCheckSupportCrossBkWithdrawRespDTO>>(){}, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
                result = (PtmCheckSupportCrossBkWithdrawRespDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
                return result;
            }
            log.error("[ptm-task-crossbk-withdraw] atmc\u8bbf\u95eePTM\u5224\u65ad\u4efb\u52a1\u662f\u5426\u652f\u6301\u8de8BK\u64a4\u56de\u51fa\u73b0\u5f02\u5e38, data: {}, \u54cd\u5e94\u5185\u5bb9: {}", (Object)JsonUtils.objectToString(allowRetrieveReqDTOList), (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
            String message = this.messageUtils.getMessage("exception.ptm.is.allow.withdraw");
            BusinessException ex = BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)ErrorCodeEnum.CHECK_TASK_WITHDRAW_ERROR.getErrCode(), (String)message);
            ex.setDescription(JsonUtils.objectToString((Object)respEntity.getBody()));
            throw ex;
        }
        catch (HttpServerErrorException ex) {
            if (HttpStatus.INTERNAL_SERVER_ERROR.value() == ex.getStatusCode().value()) {
                BaseResultDTO baseResultDTO = null;
                try {
                    baseResultDTO = (BaseResultDTO)JsonUtils.jsonToObject((String)ex.getResponseBodyAsString(), (TypeReference)new TypeReference<BaseResultDTO>(){});
                }
                catch (Exception exception) {
                    baseResultDTO = null;
                }
                if (null != baseResultDTO) {
                    throw BusinessException.create((Integer)baseResultDTO.getStatus(), (String)baseResultDTO.getErrorCode(), (Object)baseResultDTO.getErrorMessage(), (String)baseResultDTO.getDescription(), (String)baseResultDTO.getStatusDescription(), (String)ErrorTypeEnum.BUSINESS.getValue(), (Throwable)ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public List<PtmProjectCardRecordDTO> getProjectDataByCondition(Map condition) {
        ArrayList<PtmProjectCardRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/project/list-by-condition";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)condition, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardRecordDTO>>>(){}, condition);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardRecordDTO> getProjectDataByProcessSerialNumber(String processSerialNumber) {
        ArrayList<PtmProjectCardRecordDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "api/data/project/list-by-condition";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap condition = Maps.newHashMap();
        condition.put("process_serial_number", processSerialNumber);
        HttpEntity httpEntity = new HttpEntity((Object)condition, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardRecordDTO>>>(){}, (Map)condition);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmBacklogForProjectCardDTO> queryBacklogListForProjectCardId(Long projectCardId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/task/by-project-card?projectCardId={projectCardId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("projectCardId", projectCardId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmBacklogForProjectCardDTO>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<MobileProjectGroupDTO> getMobileDepartProjectGroup(List<String> userIds, Integer type) {
        ArrayList<MobileProjectGroupDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "v2/api/mobile/project/card/group";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIds", userIds);
        param.put("type", type);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<MobileProjectGroupDTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<MobileBacklogGroupDTO> getMobileDepartBacklogGroup(List<String> userIds, Integer type) {
        ArrayList<MobileBacklogGroupDTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "v2/api/mobile/task/card/group";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIds", userIds);
        param.put("type", type);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<MobileBacklogGroupDTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmProjectCardItemDTO> findMobileProjectCardGroupList(List<String> userIds, String projectDefCode) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/mobile/project/card/group/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            paramMap.put("userIds", userIds);
        }
        if (StringUtils.isNotBlank((String)projectDefCode)) {
            paramMap.put("projectDefCode", projectDefCode);
        }
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmProjectCardItemDTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardItemDTO> findMobileBacklogCardGroupList(List<String> userIds, String taskDefCode) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/mobile/task/card/group/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            paramMap.put("userIds", userIds);
        }
        if (StringUtils.isNotBlank((String)taskDefCode)) {
            paramMap.put("taskDefCode", taskDefCode);
        }
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardItemDTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<MobilePtmBacklogDTO> searchBacklogByParam(String queryParam, List<String> userIds) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/mobile/processing/task/by-condition";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("userIds", userIds);
        paramMap.put("queryParam", queryParam);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<MobilePtmBacklogDTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<MobilePtmBacklogDTO> searchBacklogByIdsAndUserIds(List<String> userIds, List<Long> backlogIds) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/mobile/processing/task/by-id";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        paramMap.put("userIds", userIds);
        paramMap.put("backlogIds", backlogIds);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<MobilePtmBacklogDTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmAgentPerformerDTO> queryAgentPerformerList(List<Long> backlogIds) {
        List result = Lists.newArrayList();
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/performerInfo/by/backlogIds";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        headers.add("routerKey", authoredUser.getTenantId());
        HashMap param = Maps.newHashMap();
        param.put("backlogIds", backlogIds);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmAgentPerformerDTO>>>(){}, (Map)param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Map<String, Object> getBpmDataByActivityIdAndTaskId(Long activityId, Long taskId) {
        Map result = null;
        String url = this.envProperties.getPtmUri() + "api/data/task/variables";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> rootPara = new HashMap<String, Long>();
        rootPara.put("taskId", taskId);
        rootPara.put("activityId", activityId);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, rootPara);
        result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<TaskExceptionDTO> getExceptionTaskInfo(long projectId, String taskCode) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/task/exception/activity/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        headers.add("routerKey", authoredUser.getTenantId());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap param = Maps.newHashMap();
        param.put("projectCardId", projectId);
        param.put("taskDefCode", taskCode);
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TaskExceptionDTO>>>(){}, (Map)param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Map<String, Object> handoverTask(String newPerformerId, String newPerformerName, List<Long> backlogIds) {
        HashMap<String, Object> result = new HashMap();
        String url = this.envProperties.getPtmUri() + "/v2/api/task/handover";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("backlogIds", backlogIds);
        rootPara.put("newPerformerId", newPerformerId);
        rootPara.put("newPerformerName", newPerformerName);
        log.info("reassignBacklog\uff0cdata\uff1a{}", (Object)JsonUtils.objectToString(rootPara));
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, rootPara);
        result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Map<String, Object> handoverProject(String newPerformerId, String newPerformerName, List<Long> projectCardIds) {
        String url = this.envProperties.getPtmUri() + "/v2/api/project/card/handover/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("projectCardIds", projectCardIds);
        rootPara.put("replacerUserId", newPerformerId);
        rootPara.put("replacerUserName", newPerformerName);
        log.info("reassignBacklog\uff0cdata\uff1a{}", (Object)JsonUtils.objectToString(rootPara));
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, rootPara);
        Map result = (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmWorkItemV2DTO> queryUserWorkItemListByTimeRange(Set<String> userIds, String beginDate, String endDate) {
        ArrayList<PtmWorkItemV2DTO> result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/list/by/performer";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        headers.add("routerKey", authoredUser.getTenantId());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        reqBody.put("userIds", userIds);
        reqBody.put("beginDate", beginDate);
        reqBody.put("endDate", endDate);
        HttpEntity httpEntity = new HttpEntity(reqBody, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmWorkItemV2DTO>>>(){}, new Object[0]);
        result = (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean reassignOrNot(Long backlogId) {
        Boolean result = false;
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/reassign-or-not?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, param);
        result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmRessignTrace> getReassignTrace(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/reassign/trace?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmRessignTrace>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmSolveTask> getSolveTaskListV2(Long backlogId) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/backlog/solve-task/list?backlogId={backlogId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("backlogId", backlogId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmSolveTask>>>(){}, param);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmTaskCardItemDTO> queryAllTaskCardList(List<String> userIds, String startPlanEndTime, String endPlanEndTime, List<Long> backlogIds, Boolean completed) {
        List<PtmTaskCardItemDTO> result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/backlog/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("userIds", userIds);
        rootPara.put("startPlanEndTime", startPlanEndTime);
        rootPara.put("endPlanEndTime", endPlanEndTime);
        rootPara.put("backlogIds", backlogIds);
        rootPara.put("closed", completed);
        result = this.httpAssistantService.post(new TypeReference<List<PtmTaskCardItemDTO>>(){}, url, headers, rootPara);
        if (result == null) {
            result = new ArrayList<PtmTaskCardItemDTO>();
        }
        return result;
    }

    @Override
    public List<PtmTaskWorkItemDTO> getWorkItemByTaskId(Long taskId) {
        String url = this.envProperties.getPtmUri() + "/v2/api/workitem/by-taskId?taskId={taskId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("taskId", taskId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskWorkItemDTO>>>(){}, param);
        List result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public Boolean removeBpmDataByTaskId(TerminateTaskDataDTO terminateTaskDataDTO) {
        String url = this.envProperties.getPtmUri() + "/v2/api/task/activity/remove-data";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("taskId", terminateTaskDataDTO.getTaskId());
        rootPara.put("dataVariableKey", terminateTaskDataDTO.getDataVariableKey());
        rootPara.put("data", terminateTaskDataDTO.getData());
        rootPara.put("uniKeys", terminateTaskDataDTO.getUniKeys());
        log.info("remove bpmdata by taskId \uff0cdata\uff1a{}", (Object)JsonUtils.objectToString(rootPara));
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, rootPara);
        Boolean result = (Boolean)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmActWithTaskAndProjectDTO getActivityByWorkItemId(Long workItemId) {
        PtmActWithTaskAndProjectDTO result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/project/task/activity/by-workItemId?workItemId={workItemId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("workItemId", workItemId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmActWithTaskAndProjectDTO>>(){}, param);
        result = (PtmActWithTaskAndProjectDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmProjectBusinessDTO getProjectBusinessByProcessSerNum(String processSerialNumber) {
        String url = this.envProperties.getPtmUri() + "/v2/api/project/by/serialNumber";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> rootPara = new HashMap<String, String>();
        rootPara.put("processSerialNumber", processSerialNumber);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectBusinessDTO>>(){}, rootPara);
        return (PtmProjectBusinessDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }

    @Override
    public void deleteProjectByProcessSerNum(String processSerialNumber) {
        String url = this.envProperties.getPtmUri() + "/v2/api/project/delete/by/serialNumber";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> rootPara = new HashMap<String, String>();
        rootPara.put("processSerialNumber", processSerialNumber);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmProjectBusinessDTO>>(){}, rootPara);
    }

    @Override
    public List<Long> getBacklogByCondotion(Long taskId, String bpmActivityId) {
        List result = new ArrayList();
        String url = this.envProperties.getPtmUri() + "/v2/api/backlog/ids/by-condition";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("taskId", taskId);
        rootPara.put("activityCode", bpmActivityId);
        log.info("\u6839\u636e\u4efb\u52a1id\u3001\u6d3b\u52a8code\u67e5\u8be2\u5f85\u529eid \uff0cdata\uff1a{}", (Object)JsonUtils.objectToString(rootPara));
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Long>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return (List)((BaseResultDTO)responseEntity.getBody()).getResponse();
    }

    @Override
    public BpmTaskApprovelDTO queryApproveByTaskUid(BpmTaskApproveRequestDTO requestDTO) {
        BpmTaskApprovelDTO result = null;
        String url = this.envProperties.getPtmUri() + "/v2/api/task/approve/process";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> rootPara = new HashMap<String, String>();
        rootPara.put("locale", requestDTO.getLocale());
        rootPara.put("taskUid", requestDTO.getTaskUid());
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<BpmTaskApprovelDTO>>(){}, rootPara);
        result = (BpmTaskApprovelDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmLineBacklogDTO.BacklogData> getLineBacklogs(PtmLineParamDTO ptmLineParamDTO) {
        HttpEntity httpEntity;
        ResponseEntity responseEntity;
        PtmLineBacklogDTO lineBacklogDTO;
        String url = this.envProperties.getPtmUri() + "/v2/api/decision/consult";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("data", ptmLineParamDTO.getData());
        if (ptmLineParamDTO.getBacklogId() != null) {
            rootPara.put("backlogId", ptmLineParamDTO.getBacklogId());
        }
        if (ptmLineParamDTO.getTaskUid() != null) {
            rootPara.put("taskUid", ptmLineParamDTO.getTaskUid());
        }
        if (null == (lineBacklogDTO = (PtmLineBacklogDTO)((BaseResultDTO)(responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmLineBacklogDTO>>(){}, rootPara)).getBody()).getResponseWithException(""))) {
            return new ArrayList<PtmLineBacklogDTO.BacklogData>();
        }
        return lineBacklogDTO.getData();
    }

    @Override
    public Map taskcardForceclose(Map<String, Object> map) {
        String url = this.envProperties.getPtmUri() + "/data/taskcard/forceclose";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.putAll(map);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, rootPara);
        return (Map)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }

    @Override
    public Map projectcardForceclose(Map<String, Object> map) {
        String url = this.envProperties.getPtmUri() + "/data/projectcard/forceclose";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.putAll(map);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, rootPara);
        return (Map)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }

    @Override
    public void checkTaskSupportReturn(List<PtmCheckSupportReturnReqDTO> allowRetrieveReqDTO) {
        String url = this.envProperties.getPtmUri() + "api/task/card/isTaskReturn";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<PtmCheckSupportReturnReqDTO>> paramMap = new HashMap<String, List<PtmCheckSupportReturnReqDTO>>();
        paramMap.put("params", allowRetrieveReqDTO);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Integer>>(){}, new Object[0]);
            if (HttpStatus.OK.value() != respEntity.getStatusCodeValue() || null == respEntity.getBody() || !((BaseResultDTO)respEntity.getBody()).isOK() || 10 != (Integer)((BaseResultDTO)respEntity.getBody()).getResponse()) {
                log.error("[ptm-task-return] atmc\u8bbf\u95eePTM\u5224\u65ad\u4efb\u52a1\u662f\u5426\u652f\u6301\u9000\u56de\u51fa\u73b0\u5f02\u5e38, data: {}, \u54cd\u5e94\u5185\u5bb9: {}", (Object)JsonUtils.objectToString(allowRetrieveReqDTO), (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
                String message = this.messageUtils.getMessage("exception.ptm.is.allow.return");
                BusinessException ex = BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)ErrorCodeEnum.CHECK_TASK_RETURN_ERROR.getErrCode(), (String)message);
                ex.setDescription(JsonUtils.objectToString((Object)respEntity.getBody()));
                throw ex;
            }
        }
        catch (HttpServerErrorException ex) {
            if (HttpStatus.INTERNAL_SERVER_ERROR.value() == ex.getStatusCode().value()) {
                BaseResultDTO baseResultDTO = null;
                try {
                    baseResultDTO = (BaseResultDTO)JsonUtils.jsonToObject((String)ex.getResponseBodyAsString(), (TypeReference)new TypeReference<BaseResultDTO>(){});
                }
                catch (Exception exception) {
                    baseResultDTO = null;
                }
                if (null != baseResultDTO) {
                    throw BusinessException.create((Integer)baseResultDTO.getStatus(), (String)baseResultDTO.getErrorCode(), (Object)baseResultDTO.getErrorMessage(), (String)baseResultDTO.getDescription(), (String)baseResultDTO.getStatusDescription(), (String)ErrorTypeEnum.BUSINESS.getValue(), (Throwable)ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public List<PtmTaskCardDataDTO> getTaskDataByBacklogIds(List<Map<String, Object>> backlogIds, String type, String isAllQuery) {
        return this.getTaskData(backlogIds, null, null, type, isAllQuery);
    }

    public List<PtmTaskCardDataDTO> getTaskData(List<Map<String, Object>> backlogIds, Long activityId, Long taskId, String type, String isAllQuery) {
        List result = null;
        String url = this.envProperties.getPtmUri() + "v2/api/task/card/data/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        if (Objects.nonNull(backlogIds)) {
            rootPara.put("taskDataRequireKeyModels", backlogIds);
        }
        if (Objects.nonNull(activityId)) {
            rootPara.put("activityId", activityId);
        }
        if (Objects.nonNull(taskId)) {
            rootPara.put("taskId", taskId);
        }
        rootPara.put("type", type);
        rootPara.put("isAllQuery", isAllQuery);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmTaskCardDataDTO>>>(){}, rootPara);
        result = (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public List<PtmSpecialBacklogDTO> getSpecialBacklog(List<Long> workItemIds) {
        if (CollectionUtils.isEmpty(workItemIds)) {
            return null;
        }
        String url = this.envProperties.getPtmUri() + "/api/task/card/derive-cards";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<Long>> rootPara = new HashMap<String, List<Long>>();
        rootPara.put("workItemIds", workItemIds);
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmSpecialBacklogDTO>>>(){}, rootPara);
        return (List)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponseWithException("");
    }
}

