/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.aglie.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.ExecuteContext;
import com.digiwin.athena.atmc.http.domain.action.SubmitAction;
import com.digiwin.athena.atmc.http.domain.report.ExcelParamsDTO;
import com.digiwin.athena.atmc.http.domain.task.ActivityDataDTO;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.digiwin.athena.atmc.http.restful.aglie.model.AglieDynamicFormDTO;
import com.digiwin.athena.atmc.http.restful.aglie.model.QueryActionAnalysisReq;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AglieServiceImpl
implements AglieService {
    private static final Logger log = LoggerFactory.getLogger(AglieServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public BaseResultDTO<Map<String, Object>> getProjectCardData(String tmTaskId, String tmActivityId, Long projectId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/project/card/{tmTaskId}/{tmActivityId}/{projectId}", tmTaskId, tmActivityId, projectId);
        return this.getCardData(url, activityDataDTO);
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectData(String tmTaskId, Long projectId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/project/card/{tmTaskId}/{projectId}", tmTaskId, projectId);
        return this.getCardData(url, activityDataDTO);
    }

    @Override
    public BaseResultDTO<HashMap> getTaskCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/{tmTaskId}/{tmActivityId}/data/size", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<HashMap>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<HashMap> getProjectCardDataSize(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/project/{tmTaskId}/{tmActivityId}/data/size", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<HashMap>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<AglieDynamicFormDTO> getTaskCardLayout(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, String flag) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/card/{tmTaskId}/{tmActivityId}/{backlogId}", tmTaskId, tmActivityId, backlogId);
        if (StringUtils.isNotEmpty((String)flag)) {
            url = url + "?flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<AglieDynamicFormDTO>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map> getTaskCardAbstractStr(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, Integer count) {
        return this.getTaskCardLayoutAbstract(tmTaskId, tmActivityId, backlogId, activityDataDTO, null, count);
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getTaskCardTitle(String tmTaskId, String tmActivityId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/getCardTitle/{tmTaskId}/{tmActivityId}", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        headers.add("security-token", null);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, param);
        log.info("\u8bf7\u6c42uibot\u6210\u529f");
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getProjectCardDataByProjectDataAbstract(String tmTaskId, Long projectId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/project/card/abstract/{tmTaskId}/{projectId}", tmTaskId, projectId);
        return this.getCardData(url, activityDataDTO);
    }

    @Override
    public BaseResultDTO<Map<String, Object>> getProjectCardDataAbstract(String tmTaskId, String tmActivityId, Long projectId, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/project/card/abstract/{tmTaskId}/{tmActivityId}/{projectId}", tmTaskId, tmActivityId, projectId);
        return this.getCardData(url, activityDataDTO);
    }

    @Override
    public BaseResultDTO<Map> getTaskCardLayoutAbstract(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, String flag, Integer count) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/card/abstract/{tmTaskId}/{tmActivityId}/{backlogId}", tmTaskId, tmActivityId, backlogId);
        url = url + "?count=" + (count == null ? 0 : count);
        if (StringUtils.isNotEmpty((String)flag)) {
            url = url + "&flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<Map> getTaskCardLayoutAbstractUpToDate(String tmTaskId, String tmActivityId, Long backlogId, Object activityDataDTO, String flag) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/card/abstract/up/to/date/{tmTaskId}/{tmActivityId}/{backlogId}", tmTaskId, tmActivityId, backlogId);
        if (StringUtils.isNotEmpty((String)flag)) {
            url = url + "?flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public BaseResultDTO<JSONObject> getData(ActivityDataDTO activityDataDTO) {
        return this.queryData(null, activityDataDTO);
    }

    @Override
    public BaseResultDTO<JSONObject> queryData(String token, Object activityDataDTO) {
        String url = this.envProperties.getUibotUri() + "api/ai/v1/data/query/by/activity";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (StringUtils.isNotEmpty((String)token)) {
            headers.add("digi-middleware-auth-user", token);
        }
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<JSONObject>>(){}, new Object[0]);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public List<Map<String, Object>> queryExcelInfo(ExcelParamsDTO excelParamsDTO) {
        String url = this.envProperties.getUibotUri() + "api/v1/ai/report/queryExcelInfo";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity((Object)excelParamsDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (List)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
    }

    private BaseResultDTO<Map<String, Object>> getCardData(String uri, Object activityDataDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, param);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return (BaseResultDTO)responseEntity.getBody();
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    @Override
    public BaseResultDTO<JSONObject> analysisQueryAction(ExecuteContext executeContext, Map tmAction) {
        String url = this.envProperties.getUibotUri() + "api/ai/v1/data/query/action";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        QueryActionAnalysisReq body = new QueryActionAnalysisReq(executeContext, tmAction);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<JSONObject>>(){}, new Object[0]);
        ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public Map getReportTemplatePage(String reportCode) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/template/statement/condition/show/{reportCode}", reportCode);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (Map)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<Map>(){});
    }

    @Override
    public Map getTaskPageData(String tmTaskId, String tmActivityId, Long workItemId) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("/api/ai/v1/bot/task/page-data/{tmTaskId}/{tmActivityId}/{workItemId}", tmTaskId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (Map)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<Map>(){});
    }

    @Override
    public List<Map> getTaskPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("/api/ai/v1/bot/task/submitactions/{tmTaskId}/{tmActivityId}", tmTaskId, tmActivityId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(activityData, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (List)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<List<Map>>(){});
    }

    @Override
    public List<Map> getProjectPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData, String pageCode) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/submitactions/{tmTaskId}/{tmActivityId}/{pageCode}", tmTaskId, tmActivityId, pageCode);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(activityData, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (List)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<List<Map>>(){});
    }

    @Override
    public List<SubmitAction> generateProjectReassignAction(Map queryAction) {
        String url = this.envProperties.getUibotUri() + "api/ai/v1/bot/action/project/reassign";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity((Object)queryAction, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, param);
        return (List)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<List<SubmitAction>>(){});
    }

    @Override
    public List<SubmitAction> generateTaskReassignAction(Map queryAction) {
        String url = this.envProperties.getUibotUri() + "api/ai/v1/bot/action/task/reassign";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity((Object)queryAction, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, param);
        return (List)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<List<SubmitAction>>(){});
    }

    @Override
    public void clearCache() {
        String url = this.envProperties.getUibotUri() + "api/cache/reset";
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, new Object[0]);
        if (200 != respEntity.getStatusCodeValue() || !((BaseResultDTO)respEntity.getBody()).isOK()) {
            throw ErrorCodeEnum.ATMC_REMOVE_CACHE_FAIL.getBusinessException(JsonUtils.objectToString((Object)respEntity.getBody()));
        }
    }

    @Override
    public Map<String, Object> getTmtask(String tmTaskId, String tmActivityId, String backlogId, String dataStateCode, String token) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("/api/ai/v1/data/query/task/dataByState/{tmTaskId}/{tmActivityId}/{backlogId}/{dataStateCode}", tmTaskId, tmActivityId, backlogId, dataStateCode);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, param);
        log.info("getTmtask statusCode: {},result\uff1a{}", (Object)responseEntity.getStatusCode().value(), responseEntity.getBody());
        return (Map)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)responseEntity, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public BaseResultDTO<Map> getTaskCardAbstractStrBatch(String tmTaskId, String tmActivityId, String bks, Object activityDataDTO) {
        return this.getTaskCardLayoutAbstractBatch(tmTaskId, tmActivityId, bks, activityDataDTO, null);
    }

    private BaseResultDTO<Map> getTaskCardLayoutAbstractBatch(String tmTaskId, String tmActivityId, String bkContact, Object activityDataDTO, String flag) {
        String url = this.envProperties.getUibotUri() + AtmcStrUtil.format("api/ai/v1/bot/task/card/abstract/batch/{tmTaskId}/{tmActivityId}/{bkContact}", tmTaskId, tmActivityId, bkContact);
        if (StringUtils.isNotEmpty((String)flag)) {
            url = url + "?flag=" + flag;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HashMap param = new HashMap();
        HttpEntity httpEntity = new HttpEntity(activityDataDTO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, param);
        return (BaseResultDTO)responseEntity.getBody();
    }
}

