/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.env;

import com.digiwin.athena.appcore.AppCoreProperties;
import com.digiwin.athena.appcore.config.HttpClientPoolConfig;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EnvProperties {
    private static final Logger log = LoggerFactory.getLogger(EnvProperties.class);
    @Autowired
    private HttpClientPoolConfig httpClientPoolConfig;
    @Autowired
    private AppCoreProperties appCoreProperties;
    @Value(value="${gmc.uri:}")
    private String gmcUri;
    @Value(value="${app.version:}")
    private String version;
    @Value(value="${app.build.time}")
    private String buildTime;
    @Value(value="${spring.profiles.active:dev}")
    private String active;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${web.uri:}")
    private String webUri;
    @Value(value="${smartdata.uri:}")
    private String webSmartDataUri;
    @Value(value="${smartdata.dataFootPrintUri:}")
    private String sdDataFootPrintUri;
    @Value(value="${smartdata.dataComparisonUri:}")
    private String sdDataComparisonUri;
    @Value(value="${uibot.uri:}")
    private String uibotUri;
    @Value(value="${bpm.uri:}")
    private String bpmUri;
    @Value(value="${esp.uri:}")
    private String espUri;
    @Value(value="${dap.uri:}")
    private String dapUri;
    @Value(value="${search.uri:}")
    private String searchUri;
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Value(value="${iam.uri}")
    private String iamUri;
    @Value(value="${iam.bossUri:}")
    private String iamBossUri;
    @Value(value="${iam.cacUri:}")
    private String iamCacUri;
    @Value(value="${iam.dmcUri:}")
    private String iamDmcUri;
    @Value(value="${semc.appId:}")
    private String semcAppId;
    @Value(value="${emc.uri:}")
    private String emcUri;
    @Value(value="${themeMap.knowledgeGraphUri:}")
    private String knowledgeGraphUri;
    @Value(value="${themeMap.dataMapUri:}")
    private String dataMapUri;
    @Value(value="${themeMap.supportPerson:}")
    private String webThemeMapSupportPerson;
    @Value(value="${xiaohui.uri:}")
    private String xiaohuiUri;
    @Value(value="${aim.uri:}")
    private String aimUri;
    @Value(value="${atdm.uri:}")
    private String atdmUri;
    @Value(value="${tdsc.uri:}")
    private String tdscUri;
    @Value(value="${im.uri:}")
    private String imUri;
    @Value(value="${asa.uri:}")
    private String asaUri;
    @Value(value="${taskEngine.uri:}")
    private String taskEngineUrl;
    @Value(value="${taskEngine.workflowUri:}")
    private String workflowUri;
    @Value(value="${language:}")
    private String defaultLanguage;
    @Value(value="${audc.uri:}")
    private String audcUri;
    @Value(value="${console.uri:}")
    private String consoleUri;
    @Value(value="${adsc.uri:}")
    private String webAdscUri;
    @Value(value="${abt.uri:}")
    private String abtUri;
    @Value(value="${aam.uri:}")
    private String aamUri;
    @Value(value="${mobile.uri:}")
    private String mobileUri;
    @Value(value="${mobile.webUri:}")
    private String mobileWebUri;
    @Value(value="${athena.externalCommonTenantId:}")
    private String externalCommonTenantId;
    @Value(value="${athena.mock.mockUser:}")
    private String athenaMockUser;
    @Value(value="${athena.mock.mockTenantId:}")
    private String athenaMockTenantId;
    @Value(value="${athena.mock.mockEnv:}")
    private String athenaMockEnv;
    @Value(value="${isTestEnv:false}")
    private boolean isTestEnv;
    @Value(value="${cam.uri:}")
    private String camUri;
    private int bpmMqRetryCount = 20;
    private int appExpireChangeMqRetryCount = 10;
    @Value(value="${taskEngine.ptmUri:}")
    private String ptmUri;
    private String host;
    private String ipAddress;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private String osName;
    private long pid;
    private LocalDateTime startTime;
    private String classPath;
    private String projectPath;
    private long runtime;
    private int threadCount;
    private LocalDateTime currentTime;
    private ZoneId currentZoneId;

    public String getGmcUri() {
        return this.gmcUri;
    }

    public void setGmcUri(String gmcUri) {
        this.gmcUri = gmcUri;
    }

    static long byteToM(long bytes) {
        return bytes / 1024L / 1024L;
    }

    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void refresh() {
        this.currentTime = LocalDateTime.now();
        this.currentZoneId = ZoneId.systemDefault();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(EnvProperties.byteToM(freeMemory));
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(EnvProperties.byteToM(totalMemory));
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(EnvProperties.byteToM(maxMemory));
        this.setOsName(System.getProperty("os.name"));
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (this.ipAddress == null) {
                this.ipAddress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            log.warn("UnknownHostException", (Throwable)e);
            this.setHost("\u672a\u77e5");
        }
        this.setIpAddress(this.ipAddress);
        long startTime = runtimeMXBean.getStartTime();
        LocalDateTime startDate = LocalDateTime.ofEpochSecond(startTime / 1000L, 0, ZoneOffset.ofHours(0));
        this.setStartTime(startDate);
        this.setRuntime(runtimeMXBean.getUptime());
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(EnvProperties.tryGetPid());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIamUri() {
        return this.iamUri;
    }

    public void setIamUri(String iamUri) {
        this.iamUri = iamUri;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public HttpClientPoolConfig getHttpClientPoolConfig() {
        return this.httpClientPoolConfig;
    }

    public AppCoreProperties getAppCoreProperties() {
        return this.appCoreProperties;
    }

    public String getWebUri() {
        return this.webUri;
    }

    public String getWebSmartDataUri() {
        return this.webSmartDataUri;
    }

    public String getSdDataFootPrintUri() {
        return this.sdDataFootPrintUri;
    }

    public String getSdDataComparisonUri() {
        return this.sdDataComparisonUri;
    }

    public String getUibotUri() {
        return this.uibotUri;
    }

    public String getBpmUri() {
        return this.bpmUri;
    }

    public String getEspUri() {
        return this.espUri;
    }

    public String getDapUri() {
        return this.dapUri;
    }

    public String getSearchUri() {
        return this.searchUri;
    }

    public String getEocUri() {
        return this.eocUri;
    }

    public String getIamBossUri() {
        return this.iamBossUri;
    }

    public String getIamCacUri() {
        return this.iamCacUri;
    }

    public String getIamDmcUri() {
        return this.iamDmcUri;
    }

    public String getSemcAppId() {
        return this.semcAppId;
    }

    public String getEmcUri() {
        return this.emcUri;
    }

    public String getKnowledgeGraphUri() {
        return this.knowledgeGraphUri;
    }

    public String getDataMapUri() {
        return this.dataMapUri;
    }

    public String getWebThemeMapSupportPerson() {
        return this.webThemeMapSupportPerson;
    }

    public String getXiaohuiUri() {
        return this.xiaohuiUri;
    }

    public String getAimUri() {
        return this.aimUri;
    }

    public String getAtdmUri() {
        return this.atdmUri;
    }

    public String getTdscUri() {
        return this.tdscUri;
    }

    public String getImUri() {
        return this.imUri;
    }

    public String getAsaUri() {
        return this.asaUri;
    }

    public String getTaskEngineUrl() {
        return this.taskEngineUrl;
    }

    public String getWorkflowUri() {
        return this.workflowUri;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getAudcUri() {
        return this.audcUri;
    }

    public String getConsoleUri() {
        return this.consoleUri;
    }

    public String getWebAdscUri() {
        return this.webAdscUri;
    }

    public String getAbtUri() {
        return this.abtUri;
    }

    public String getAamUri() {
        return this.aamUri;
    }

    public String getMobileUri() {
        return this.mobileUri;
    }

    public String getMobileWebUri() {
        return this.mobileWebUri;
    }

    public String getExternalCommonTenantId() {
        return this.externalCommonTenantId;
    }

    public String getAthenaMockUser() {
        return this.athenaMockUser;
    }

    public String getAthenaMockTenantId() {
        return this.athenaMockTenantId;
    }

    public String getAthenaMockEnv() {
        return this.athenaMockEnv;
    }

    public boolean isTestEnv() {
        return this.isTestEnv;
    }

    public String getCamUri() {
        return this.camUri;
    }

    public int getBpmMqRetryCount() {
        return this.bpmMqRetryCount;
    }

    public int getAppExpireChangeMqRetryCount() {
        return this.appExpireChangeMqRetryCount;
    }

    public String getPtmUri() {
        return this.ptmUri;
    }

    public LocalDateTime getCurrentTime() {
        return this.currentTime;
    }

    public ZoneId getCurrentZoneId() {
        return this.currentZoneId;
    }

    public void setHttpClientPoolConfig(HttpClientPoolConfig httpClientPoolConfig) {
        this.httpClientPoolConfig = httpClientPoolConfig;
    }

    public void setAppCoreProperties(AppCoreProperties appCoreProperties) {
        this.appCoreProperties = appCoreProperties;
    }

    public void setWebUri(String webUri) {
        this.webUri = webUri;
    }

    public void setWebSmartDataUri(String webSmartDataUri) {
        this.webSmartDataUri = webSmartDataUri;
    }

    public void setSdDataFootPrintUri(String sdDataFootPrintUri) {
        this.sdDataFootPrintUri = sdDataFootPrintUri;
    }

    public void setSdDataComparisonUri(String sdDataComparisonUri) {
        this.sdDataComparisonUri = sdDataComparisonUri;
    }

    public void setUibotUri(String uibotUri) {
        this.uibotUri = uibotUri;
    }

    public void setBpmUri(String bpmUri) {
        this.bpmUri = bpmUri;
    }

    public void setEspUri(String espUri) {
        this.espUri = espUri;
    }

    public void setDapUri(String dapUri) {
        this.dapUri = dapUri;
    }

    public void setSearchUri(String searchUri) {
        this.searchUri = searchUri;
    }

    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    public void setIamBossUri(String iamBossUri) {
        this.iamBossUri = iamBossUri;
    }

    public void setIamCacUri(String iamCacUri) {
        this.iamCacUri = iamCacUri;
    }

    public void setIamDmcUri(String iamDmcUri) {
        this.iamDmcUri = iamDmcUri;
    }

    public void setSemcAppId(String semcAppId) {
        this.semcAppId = semcAppId;
    }

    public void setEmcUri(String emcUri) {
        this.emcUri = emcUri;
    }

    public void setKnowledgeGraphUri(String knowledgeGraphUri) {
        this.knowledgeGraphUri = knowledgeGraphUri;
    }

    public void setDataMapUri(String dataMapUri) {
        this.dataMapUri = dataMapUri;
    }

    public void setWebThemeMapSupportPerson(String webThemeMapSupportPerson) {
        this.webThemeMapSupportPerson = webThemeMapSupportPerson;
    }

    public void setXiaohuiUri(String xiaohuiUri) {
        this.xiaohuiUri = xiaohuiUri;
    }

    public void setAimUri(String aimUri) {
        this.aimUri = aimUri;
    }

    public void setAtdmUri(String atdmUri) {
        this.atdmUri = atdmUri;
    }

    public void setTdscUri(String tdscUri) {
        this.tdscUri = tdscUri;
    }

    public void setImUri(String imUri) {
        this.imUri = imUri;
    }

    public void setAsaUri(String asaUri) {
        this.asaUri = asaUri;
    }

    public void setTaskEngineUrl(String taskEngineUrl) {
        this.taskEngineUrl = taskEngineUrl;
    }

    public void setWorkflowUri(String workflowUri) {
        this.workflowUri = workflowUri;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setAudcUri(String audcUri) {
        this.audcUri = audcUri;
    }

    public void setConsoleUri(String consoleUri) {
        this.consoleUri = consoleUri;
    }

    public void setWebAdscUri(String webAdscUri) {
        this.webAdscUri = webAdscUri;
    }

    public void setAbtUri(String abtUri) {
        this.abtUri = abtUri;
    }

    public void setAamUri(String aamUri) {
        this.aamUri = aamUri;
    }

    public void setMobileUri(String mobileUri) {
        this.mobileUri = mobileUri;
    }

    public void setMobileWebUri(String mobileWebUri) {
        this.mobileWebUri = mobileWebUri;
    }

    public void setExternalCommonTenantId(String externalCommonTenantId) {
        this.externalCommonTenantId = externalCommonTenantId;
    }

    public void setAthenaMockUser(String athenaMockUser) {
        this.athenaMockUser = athenaMockUser;
    }

    public void setAthenaMockTenantId(String athenaMockTenantId) {
        this.athenaMockTenantId = athenaMockTenantId;
    }

    public void setAthenaMockEnv(String athenaMockEnv) {
        this.athenaMockEnv = athenaMockEnv;
    }

    public void setTestEnv(boolean isTestEnv) {
        this.isTestEnv = isTestEnv;
    }

    public void setCamUri(String camUri) {
        this.camUri = camUri;
    }

    public void setBpmMqRetryCount(int bpmMqRetryCount) {
        this.bpmMqRetryCount = bpmMqRetryCount;
    }

    public void setAppExpireChangeMqRetryCount(int appExpireChangeMqRetryCount) {
        this.appExpireChangeMqRetryCount = appExpireChangeMqRetryCount;
    }

    public void setPtmUri(String ptmUri) {
        this.ptmUri = ptmUri;
    }

    public void setCurrentTime(LocalDateTime currentTime) {
        this.currentTime = currentTime;
    }

    public void setCurrentZoneId(ZoneId currentZoneId) {
        this.currentZoneId = currentZoneId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvProperties)) {
            return false;
        }
        EnvProperties other = (EnvProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpClientPoolConfig this$httpClientPoolConfig = this.getHttpClientPoolConfig();
        HttpClientPoolConfig other$httpClientPoolConfig = other.getHttpClientPoolConfig();
        if (this$httpClientPoolConfig == null ? other$httpClientPoolConfig != null : !this$httpClientPoolConfig.equals(other$httpClientPoolConfig)) {
            return false;
        }
        AppCoreProperties this$appCoreProperties = this.getAppCoreProperties();
        AppCoreProperties other$appCoreProperties = other.getAppCoreProperties();
        if (this$appCoreProperties == null ? other$appCoreProperties != null : !this$appCoreProperties.equals(other$appCoreProperties)) {
            return false;
        }
        String this$gmcUri = this.getGmcUri();
        String other$gmcUri = other.getGmcUri();
        if (this$gmcUri == null ? other$gmcUri != null : !this$gmcUri.equals(other$gmcUri)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$buildTime = this.getBuildTime();
        String other$buildTime = other.getBuildTime();
        if (this$buildTime == null ? other$buildTime != null : !this$buildTime.equals(other$buildTime)) {
            return false;
        }
        String this$active = this.getActive();
        String other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$webUri = this.getWebUri();
        String other$webUri = other.getWebUri();
        if (this$webUri == null ? other$webUri != null : !this$webUri.equals(other$webUri)) {
            return false;
        }
        String this$webSmartDataUri = this.getWebSmartDataUri();
        String other$webSmartDataUri = other.getWebSmartDataUri();
        if (this$webSmartDataUri == null ? other$webSmartDataUri != null : !this$webSmartDataUri.equals(other$webSmartDataUri)) {
            return false;
        }
        String this$sdDataFootPrintUri = this.getSdDataFootPrintUri();
        String other$sdDataFootPrintUri = other.getSdDataFootPrintUri();
        if (this$sdDataFootPrintUri == null ? other$sdDataFootPrintUri != null : !this$sdDataFootPrintUri.equals(other$sdDataFootPrintUri)) {
            return false;
        }
        String this$sdDataComparisonUri = this.getSdDataComparisonUri();
        String other$sdDataComparisonUri = other.getSdDataComparisonUri();
        if (this$sdDataComparisonUri == null ? other$sdDataComparisonUri != null : !this$sdDataComparisonUri.equals(other$sdDataComparisonUri)) {
            return false;
        }
        String this$uibotUri = this.getUibotUri();
        String other$uibotUri = other.getUibotUri();
        if (this$uibotUri == null ? other$uibotUri != null : !this$uibotUri.equals(other$uibotUri)) {
            return false;
        }
        String this$bpmUri = this.getBpmUri();
        String other$bpmUri = other.getBpmUri();
        if (this$bpmUri == null ? other$bpmUri != null : !this$bpmUri.equals(other$bpmUri)) {
            return false;
        }
        String this$espUri = this.getEspUri();
        String other$espUri = other.getEspUri();
        if (this$espUri == null ? other$espUri != null : !this$espUri.equals(other$espUri)) {
            return false;
        }
        String this$dapUri = this.getDapUri();
        String other$dapUri = other.getDapUri();
        if (this$dapUri == null ? other$dapUri != null : !this$dapUri.equals(other$dapUri)) {
            return false;
        }
        String this$searchUri = this.getSearchUri();
        String other$searchUri = other.getSearchUri();
        if (this$searchUri == null ? other$searchUri != null : !this$searchUri.equals(other$searchUri)) {
            return false;
        }
        String this$eocUri = this.getEocUri();
        String other$eocUri = other.getEocUri();
        if (this$eocUri == null ? other$eocUri != null : !this$eocUri.equals(other$eocUri)) {
            return false;
        }
        String this$iamUri = this.getIamUri();
        String other$iamUri = other.getIamUri();
        if (this$iamUri == null ? other$iamUri != null : !this$iamUri.equals(other$iamUri)) {
            return false;
        }
        String this$iamBossUri = this.getIamBossUri();
        String other$iamBossUri = other.getIamBossUri();
        if (this$iamBossUri == null ? other$iamBossUri != null : !this$iamBossUri.equals(other$iamBossUri)) {
            return false;
        }
        String this$iamCacUri = this.getIamCacUri();
        String other$iamCacUri = other.getIamCacUri();
        if (this$iamCacUri == null ? other$iamCacUri != null : !this$iamCacUri.equals(other$iamCacUri)) {
            return false;
        }
        String this$iamDmcUri = this.getIamDmcUri();
        String other$iamDmcUri = other.getIamDmcUri();
        if (this$iamDmcUri == null ? other$iamDmcUri != null : !this$iamDmcUri.equals(other$iamDmcUri)) {
            return false;
        }
        String this$semcAppId = this.getSemcAppId();
        String other$semcAppId = other.getSemcAppId();
        if (this$semcAppId == null ? other$semcAppId != null : !this$semcAppId.equals(other$semcAppId)) {
            return false;
        }
        String this$emcUri = this.getEmcUri();
        String other$emcUri = other.getEmcUri();
        if (this$emcUri == null ? other$emcUri != null : !this$emcUri.equals(other$emcUri)) {
            return false;
        }
        String this$knowledgeGraphUri = this.getKnowledgeGraphUri();
        String other$knowledgeGraphUri = other.getKnowledgeGraphUri();
        if (this$knowledgeGraphUri == null ? other$knowledgeGraphUri != null : !this$knowledgeGraphUri.equals(other$knowledgeGraphUri)) {
            return false;
        }
        String this$dataMapUri = this.getDataMapUri();
        String other$dataMapUri = other.getDataMapUri();
        if (this$dataMapUri == null ? other$dataMapUri != null : !this$dataMapUri.equals(other$dataMapUri)) {
            return false;
        }
        String this$webThemeMapSupportPerson = this.getWebThemeMapSupportPerson();
        String other$webThemeMapSupportPerson = other.getWebThemeMapSupportPerson();
        if (this$webThemeMapSupportPerson == null ? other$webThemeMapSupportPerson != null : !this$webThemeMapSupportPerson.equals(other$webThemeMapSupportPerson)) {
            return false;
        }
        String this$xiaohuiUri = this.getXiaohuiUri();
        String other$xiaohuiUri = other.getXiaohuiUri();
        if (this$xiaohuiUri == null ? other$xiaohuiUri != null : !this$xiaohuiUri.equals(other$xiaohuiUri)) {
            return false;
        }
        String this$aimUri = this.getAimUri();
        String other$aimUri = other.getAimUri();
        if (this$aimUri == null ? other$aimUri != null : !this$aimUri.equals(other$aimUri)) {
            return false;
        }
        String this$atdmUri = this.getAtdmUri();
        String other$atdmUri = other.getAtdmUri();
        if (this$atdmUri == null ? other$atdmUri != null : !this$atdmUri.equals(other$atdmUri)) {
            return false;
        }
        String this$tdscUri = this.getTdscUri();
        String other$tdscUri = other.getTdscUri();
        if (this$tdscUri == null ? other$tdscUri != null : !this$tdscUri.equals(other$tdscUri)) {
            return false;
        }
        String this$imUri = this.getImUri();
        String other$imUri = other.getImUri();
        if (this$imUri == null ? other$imUri != null : !this$imUri.equals(other$imUri)) {
            return false;
        }
        String this$asaUri = this.getAsaUri();
        String other$asaUri = other.getAsaUri();
        if (this$asaUri == null ? other$asaUri != null : !this$asaUri.equals(other$asaUri)) {
            return false;
        }
        String this$taskEngineUrl = this.getTaskEngineUrl();
        String other$taskEngineUrl = other.getTaskEngineUrl();
        if (this$taskEngineUrl == null ? other$taskEngineUrl != null : !this$taskEngineUrl.equals(other$taskEngineUrl)) {
            return false;
        }
        String this$workflowUri = this.getWorkflowUri();
        String other$workflowUri = other.getWorkflowUri();
        if (this$workflowUri == null ? other$workflowUri != null : !this$workflowUri.equals(other$workflowUri)) {
            return false;
        }
        String this$defaultLanguage = this.getDefaultLanguage();
        String other$defaultLanguage = other.getDefaultLanguage();
        if (this$defaultLanguage == null ? other$defaultLanguage != null : !this$defaultLanguage.equals(other$defaultLanguage)) {
            return false;
        }
        String this$audcUri = this.getAudcUri();
        String other$audcUri = other.getAudcUri();
        if (this$audcUri == null ? other$audcUri != null : !this$audcUri.equals(other$audcUri)) {
            return false;
        }
        String this$consoleUri = this.getConsoleUri();
        String other$consoleUri = other.getConsoleUri();
        if (this$consoleUri == null ? other$consoleUri != null : !this$consoleUri.equals(other$consoleUri)) {
            return false;
        }
        String this$webAdscUri = this.getWebAdscUri();
        String other$webAdscUri = other.getWebAdscUri();
        if (this$webAdscUri == null ? other$webAdscUri != null : !this$webAdscUri.equals(other$webAdscUri)) {
            return false;
        }
        String this$abtUri = this.getAbtUri();
        String other$abtUri = other.getAbtUri();
        if (this$abtUri == null ? other$abtUri != null : !this$abtUri.equals(other$abtUri)) {
            return false;
        }
        String this$aamUri = this.getAamUri();
        String other$aamUri = other.getAamUri();
        if (this$aamUri == null ? other$aamUri != null : !this$aamUri.equals(other$aamUri)) {
            return false;
        }
        String this$mobileUri = this.getMobileUri();
        String other$mobileUri = other.getMobileUri();
        if (this$mobileUri == null ? other$mobileUri != null : !this$mobileUri.equals(other$mobileUri)) {
            return false;
        }
        String this$mobileWebUri = this.getMobileWebUri();
        String other$mobileWebUri = other.getMobileWebUri();
        if (this$mobileWebUri == null ? other$mobileWebUri != null : !this$mobileWebUri.equals(other$mobileWebUri)) {
            return false;
        }
        String this$externalCommonTenantId = this.getExternalCommonTenantId();
        String other$externalCommonTenantId = other.getExternalCommonTenantId();
        if (this$externalCommonTenantId == null ? other$externalCommonTenantId != null : !this$externalCommonTenantId.equals(other$externalCommonTenantId)) {
            return false;
        }
        String this$athenaMockUser = this.getAthenaMockUser();
        String other$athenaMockUser = other.getAthenaMockUser();
        if (this$athenaMockUser == null ? other$athenaMockUser != null : !this$athenaMockUser.equals(other$athenaMockUser)) {
            return false;
        }
        String this$athenaMockTenantId = this.getAthenaMockTenantId();
        String other$athenaMockTenantId = other.getAthenaMockTenantId();
        if (this$athenaMockTenantId == null ? other$athenaMockTenantId != null : !this$athenaMockTenantId.equals(other$athenaMockTenantId)) {
            return false;
        }
        String this$athenaMockEnv = this.getAthenaMockEnv();
        String other$athenaMockEnv = other.getAthenaMockEnv();
        if (this$athenaMockEnv == null ? other$athenaMockEnv != null : !this$athenaMockEnv.equals(other$athenaMockEnv)) {
            return false;
        }
        if (this.isTestEnv() != other.isTestEnv()) {
            return false;
        }
        String this$camUri = this.getCamUri();
        String other$camUri = other.getCamUri();
        if (this$camUri == null ? other$camUri != null : !this$camUri.equals(other$camUri)) {
            return false;
        }
        if (this.getBpmMqRetryCount() != other.getBpmMqRetryCount()) {
            return false;
        }
        if (this.getAppExpireChangeMqRetryCount() != other.getAppExpireChangeMqRetryCount()) {
            return false;
        }
        String this$ptmUri = this.getPtmUri();
        String other$ptmUri = other.getPtmUri();
        if (this$ptmUri == null ? other$ptmUri != null : !this$ptmUri.equals(other$ptmUri)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        if (this.getFreeMemory() != other.getFreeMemory()) {
            return false;
        }
        if (this.getTotalMemory() != other.getTotalMemory()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$classPath = this.getClassPath();
        String other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        String this$projectPath = this.getProjectPath();
        String other$projectPath = other.getProjectPath();
        if (this$projectPath == null ? other$projectPath != null : !this$projectPath.equals(other$projectPath)) {
            return false;
        }
        if (this.getRuntime() != other.getRuntime()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        LocalDateTime this$currentTime = this.getCurrentTime();
        LocalDateTime other$currentTime = other.getCurrentTime();
        if (this$currentTime == null ? other$currentTime != null : !((Object)this$currentTime).equals(other$currentTime)) {
            return false;
        }
        ZoneId this$currentZoneId = this.getCurrentZoneId();
        ZoneId other$currentZoneId = other.getCurrentZoneId();
        return !(this$currentZoneId == null ? other$currentZoneId != null : !((Object)this$currentZoneId).equals(other$currentZoneId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnvProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpClientPoolConfig $httpClientPoolConfig = this.getHttpClientPoolConfig();
        result = result * 59 + ($httpClientPoolConfig == null ? 43 : $httpClientPoolConfig.hashCode());
        AppCoreProperties $appCoreProperties = this.getAppCoreProperties();
        result = result * 59 + ($appCoreProperties == null ? 43 : $appCoreProperties.hashCode());
        String $gmcUri = this.getGmcUri();
        result = result * 59 + ($gmcUri == null ? 43 : $gmcUri.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $buildTime = this.getBuildTime();
        result = result * 59 + ($buildTime == null ? 43 : $buildTime.hashCode());
        String $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : $active.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $webUri = this.getWebUri();
        result = result * 59 + ($webUri == null ? 43 : $webUri.hashCode());
        String $webSmartDataUri = this.getWebSmartDataUri();
        result = result * 59 + ($webSmartDataUri == null ? 43 : $webSmartDataUri.hashCode());
        String $sdDataFootPrintUri = this.getSdDataFootPrintUri();
        result = result * 59 + ($sdDataFootPrintUri == null ? 43 : $sdDataFootPrintUri.hashCode());
        String $sdDataComparisonUri = this.getSdDataComparisonUri();
        result = result * 59 + ($sdDataComparisonUri == null ? 43 : $sdDataComparisonUri.hashCode());
        String $uibotUri = this.getUibotUri();
        result = result * 59 + ($uibotUri == null ? 43 : $uibotUri.hashCode());
        String $bpmUri = this.getBpmUri();
        result = result * 59 + ($bpmUri == null ? 43 : $bpmUri.hashCode());
        String $espUri = this.getEspUri();
        result = result * 59 + ($espUri == null ? 43 : $espUri.hashCode());
        String $dapUri = this.getDapUri();
        result = result * 59 + ($dapUri == null ? 43 : $dapUri.hashCode());
        String $searchUri = this.getSearchUri();
        result = result * 59 + ($searchUri == null ? 43 : $searchUri.hashCode());
        String $eocUri = this.getEocUri();
        result = result * 59 + ($eocUri == null ? 43 : $eocUri.hashCode());
        String $iamUri = this.getIamUri();
        result = result * 59 + ($iamUri == null ? 43 : $iamUri.hashCode());
        String $iamBossUri = this.getIamBossUri();
        result = result * 59 + ($iamBossUri == null ? 43 : $iamBossUri.hashCode());
        String $iamCacUri = this.getIamCacUri();
        result = result * 59 + ($iamCacUri == null ? 43 : $iamCacUri.hashCode());
        String $iamDmcUri = this.getIamDmcUri();
        result = result * 59 + ($iamDmcUri == null ? 43 : $iamDmcUri.hashCode());
        String $semcAppId = this.getSemcAppId();
        result = result * 59 + ($semcAppId == null ? 43 : $semcAppId.hashCode());
        String $emcUri = this.getEmcUri();
        result = result * 59 + ($emcUri == null ? 43 : $emcUri.hashCode());
        String $knowledgeGraphUri = this.getKnowledgeGraphUri();
        result = result * 59 + ($knowledgeGraphUri == null ? 43 : $knowledgeGraphUri.hashCode());
        String $dataMapUri = this.getDataMapUri();
        result = result * 59 + ($dataMapUri == null ? 43 : $dataMapUri.hashCode());
        String $webThemeMapSupportPerson = this.getWebThemeMapSupportPerson();
        result = result * 59 + ($webThemeMapSupportPerson == null ? 43 : $webThemeMapSupportPerson.hashCode());
        String $xiaohuiUri = this.getXiaohuiUri();
        result = result * 59 + ($xiaohuiUri == null ? 43 : $xiaohuiUri.hashCode());
        String $aimUri = this.getAimUri();
        result = result * 59 + ($aimUri == null ? 43 : $aimUri.hashCode());
        String $atdmUri = this.getAtdmUri();
        result = result * 59 + ($atdmUri == null ? 43 : $atdmUri.hashCode());
        String $tdscUri = this.getTdscUri();
        result = result * 59 + ($tdscUri == null ? 43 : $tdscUri.hashCode());
        String $imUri = this.getImUri();
        result = result * 59 + ($imUri == null ? 43 : $imUri.hashCode());
        String $asaUri = this.getAsaUri();
        result = result * 59 + ($asaUri == null ? 43 : $asaUri.hashCode());
        String $taskEngineUrl = this.getTaskEngineUrl();
        result = result * 59 + ($taskEngineUrl == null ? 43 : $taskEngineUrl.hashCode());
        String $workflowUri = this.getWorkflowUri();
        result = result * 59 + ($workflowUri == null ? 43 : $workflowUri.hashCode());
        String $defaultLanguage = this.getDefaultLanguage();
        result = result * 59 + ($defaultLanguage == null ? 43 : $defaultLanguage.hashCode());
        String $audcUri = this.getAudcUri();
        result = result * 59 + ($audcUri == null ? 43 : $audcUri.hashCode());
        String $consoleUri = this.getConsoleUri();
        result = result * 59 + ($consoleUri == null ? 43 : $consoleUri.hashCode());
        String $webAdscUri = this.getWebAdscUri();
        result = result * 59 + ($webAdscUri == null ? 43 : $webAdscUri.hashCode());
        String $abtUri = this.getAbtUri();
        result = result * 59 + ($abtUri == null ? 43 : $abtUri.hashCode());
        String $aamUri = this.getAamUri();
        result = result * 59 + ($aamUri == null ? 43 : $aamUri.hashCode());
        String $mobileUri = this.getMobileUri();
        result = result * 59 + ($mobileUri == null ? 43 : $mobileUri.hashCode());
        String $mobileWebUri = this.getMobileWebUri();
        result = result * 59 + ($mobileWebUri == null ? 43 : $mobileWebUri.hashCode());
        String $externalCommonTenantId = this.getExternalCommonTenantId();
        result = result * 59 + ($externalCommonTenantId == null ? 43 : $externalCommonTenantId.hashCode());
        String $athenaMockUser = this.getAthenaMockUser();
        result = result * 59 + ($athenaMockUser == null ? 43 : $athenaMockUser.hashCode());
        String $athenaMockTenantId = this.getAthenaMockTenantId();
        result = result * 59 + ($athenaMockTenantId == null ? 43 : $athenaMockTenantId.hashCode());
        String $athenaMockEnv = this.getAthenaMockEnv();
        result = result * 59 + ($athenaMockEnv == null ? 43 : $athenaMockEnv.hashCode());
        result = result * 59 + (this.isTestEnv() ? 79 : 97);
        String $camUri = this.getCamUri();
        result = result * 59 + ($camUri == null ? 43 : $camUri.hashCode());
        result = result * 59 + this.getBpmMqRetryCount();
        result = result * 59 + this.getAppExpireChangeMqRetryCount();
        String $ptmUri = this.getPtmUri();
        result = result * 59 + ($ptmUri == null ? 43 : $ptmUri.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        long $freeMemory = this.getFreeMemory();
        result = result * 59 + (int)($freeMemory >>> 32 ^ $freeMemory);
        long $totalMemory = this.getTotalMemory();
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        long $pid = this.getPid();
        result = result * 59 + (int)($pid >>> 32 ^ $pid);
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        String $projectPath = this.getProjectPath();
        result = result * 59 + ($projectPath == null ? 43 : $projectPath.hashCode());
        long $runtime = this.getRuntime();
        result = result * 59 + (int)($runtime >>> 32 ^ $runtime);
        result = result * 59 + this.getThreadCount();
        LocalDateTime $currentTime = this.getCurrentTime();
        result = result * 59 + ($currentTime == null ? 43 : ((Object)$currentTime).hashCode());
        ZoneId $currentZoneId = this.getCurrentZoneId();
        result = result * 59 + ($currentZoneId == null ? 43 : ((Object)$currentZoneId).hashCode());
        return result;
    }

    public String toString() {
        return "EnvProperties(httpClientPoolConfig=" + this.getHttpClientPoolConfig() + ", appCoreProperties=" + this.getAppCoreProperties() + ", gmcUri=" + this.getGmcUri() + ", version=" + this.getVersion() + ", buildTime=" + this.getBuildTime() + ", active=" + this.getActive() + ", port=" + this.getPort() + ", webUri=" + this.getWebUri() + ", webSmartDataUri=" + this.getWebSmartDataUri() + ", sdDataFootPrintUri=" + this.getSdDataFootPrintUri() + ", sdDataComparisonUri=" + this.getSdDataComparisonUri() + ", uibotUri=" + this.getUibotUri() + ", bpmUri=" + this.getBpmUri() + ", espUri=" + this.getEspUri() + ", dapUri=" + this.getDapUri() + ", searchUri=" + this.getSearchUri() + ", eocUri=" + this.getEocUri() + ", iamUri=" + this.getIamUri() + ", iamBossUri=" + this.getIamBossUri() + ", iamCacUri=" + this.getIamCacUri() + ", iamDmcUri=" + this.getIamDmcUri() + ", semcAppId=" + this.getSemcAppId() + ", emcUri=" + this.getEmcUri() + ", knowledgeGraphUri=" + this.getKnowledgeGraphUri() + ", dataMapUri=" + this.getDataMapUri() + ", webThemeMapSupportPerson=" + this.getWebThemeMapSupportPerson() + ", xiaohuiUri=" + this.getXiaohuiUri() + ", aimUri=" + this.getAimUri() + ", atdmUri=" + this.getAtdmUri() + ", tdscUri=" + this.getTdscUri() + ", imUri=" + this.getImUri() + ", asaUri=" + this.getAsaUri() + ", taskEngineUrl=" + this.getTaskEngineUrl() + ", workflowUri=" + this.getWorkflowUri() + ", defaultLanguage=" + this.getDefaultLanguage() + ", audcUri=" + this.getAudcUri() + ", consoleUri=" + this.getConsoleUri() + ", webAdscUri=" + this.getWebAdscUri() + ", abtUri=" + this.getAbtUri() + ", aamUri=" + this.getAamUri() + ", mobileUri=" + this.getMobileUri() + ", mobileWebUri=" + this.getMobileWebUri() + ", externalCommonTenantId=" + this.getExternalCommonTenantId() + ", athenaMockUser=" + this.getAthenaMockUser() + ", athenaMockTenantId=" + this.getAthenaMockTenantId() + ", athenaMockEnv=" + this.getAthenaMockEnv() + ", isTestEnv=" + this.isTestEnv() + ", camUri=" + this.getCamUri() + ", bpmMqRetryCount=" + this.getBpmMqRetryCount() + ", appExpireChangeMqRetryCount=" + this.getAppExpireChangeMqRetryCount() + ", ptmUri=" + this.getPtmUri() + ", host=" + this.getHost() + ", ipAddress=" + this.getIpAddress() + ", freeMemory=" + this.getFreeMemory() + ", totalMemory=" + this.getTotalMemory() + ", maxMemory=" + this.getMaxMemory() + ", osName=" + this.getOsName() + ", pid=" + this.getPid() + ", startTime=" + this.getStartTime() + ", classPath=" + this.getClassPath() + ", projectPath=" + this.getProjectPath() + ", runtime=" + this.getRuntime() + ", threadCount=" + this.getThreadCount() + ", currentTime=" + this.getCurrentTime() + ", currentZoneId=" + this.getCurrentZoneId() + ")";
    }
}

