package com.digiwin.athena.atmc.http.domain.action;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.constant.BpmConstant;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

/**
 * @description: 页面提交相关上下文
 * @create: 2020-09-08 10:23
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SubmitExecuteContext implements Serializable {

    /**
     * 语言别
     */
    private String locale;

    /**
     * 客户端来源
     */
    private String clientAgent;

    /**
     * 项目名称
     */
    private String tmProjectId;

    /**
     * 关卡名称
     */
    private String tmActivityId;

    /**
     * 代办项id，一般再提交的时候用
     */
    private Long backlogId;

    /**
     * 流程序号
     */
    private String processSerialNumber;

    /**
     * 流程数据
     */
    private Map<String,Object> bpmData;

    /**
     * 登陆用户
     */
    @JsonIgnore
    private AuthoredUser authoredUser;

    /**
     * 实际操作的用户
     */
    @JsonIgnore
    private AuthoredUser operateAuthoredUser;

    /**
     * 代理用户
     */
    private String proxyToken;

    /**
     * 代理租户信息
     */
    private String tenantId;

    /**
     * 页面场景
     * [project-card,project-detail,task-card,task-detail]
     */
    private String pageCode;


    /**
     * 短地址应用的设备类型，目前仅有email
     */
    private String deviceType;

    /**
     * 活动形态分类
     */
    private String pattern;

    /**
     * 活动形态类型
     */
    private String category;


    /**
     * 营运单元
     */
    private Map<String,String> businessUnit;

    @JsonIgnore
    private SubmitAction parentAction;

    /**
     * 调用链ID
     */
    private String traceId;

    /**
     * 数据来源：PTM表示来源于PTM，其他表示ATMC
     */
    private String dataFrom;

    /**
     * PTM任务相关数据
     */
    private Map ptmData;
    /**
     * 任务类型
     */
    private Integer type;

    private Integer taskType;

    private Long abnormalWorkitemId;

    /**
     * 提交唯一键
     */
    private Integer submitId;

    /**
     * 判断是否通过adsc模块查应用数据
     */
    private Boolean fromAdsc = false;

    /**
     * 项目卡id
     */
    private Long projectCardId;

    /**
     * 是否是重试请求
     */
    private Boolean isRetry = false;

    public boolean isPTM(){
        if(Objects.equals(this.dataFrom, BpmConstant.DATA_FROM_PTM)) {
            return true;
        }else{
            return false;
        }
    }

    public SubmitExecuteContext appendHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        this.setClientAgent(clientAgent);
        this.setLocale(locale);
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        this.setAuthoredUser(authoredUser);
        if(StringUtils.isEmpty(tenantId)){
            this.setTenantId(authoredUser.getTenantId());
        }
        return this;
    }

    public SubmitExecuteContext appendExecuteContext(SubmitExecuteContext executeContext) {
        this.setClientAgent(executeContext.getClientAgent());
        this.setLocale(executeContext.getLocale());
        this.setAuthoredUser(executeContext.getAuthoredUser());
        this.setTenantId(executeContext.getTenantId());
        this.setDataFrom(executeContext.getDataFrom());
        this.setPtmData(executeContext.getPtmData());
        return this;
    }

    public static SubmitExecuteContext createByHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        SubmitExecuteContext executeContext =  SubmitExecuteContext.builder()
                .clientAgent(clientAgent)
                .locale(locale)
                .authoredUser(authoredUser)
                .tenantId(authoredUser.getTenantId())
                .build();
        return executeContext;
    }

    /**
     * 判断是否是异常排除任务
     * @return
     */
    @JsonIgnore
    public boolean isSolveTask(){
        return Objects.equals(this.getPattern(), TmTaskPatternEnum.BUSINESS.getValue())
                    && Objects.equals(this.getCategory(), TmTaskCategoryEnum.SOLVE.getValue());
    }

    @Override
    public String toString(){
        return String.format("%s-%s-%s",this.tenantId,this.tmProjectId,this.tmActivityId);
    }

}
