package com.digiwin.athena.atmc.http.restful.adsc.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.constant.AdscApiConstant;
//import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.adsc.model.SubmitDataCheckResDto;
import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import com.digiwin.athena.atmc.http.restful.adsc.AdscService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Slf4j
public class AdscServiceImpl implements AdscService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;


    @Override
    public SubmitDataCheckResDto submitDataWithCheck(SubmitActionDTO submitActionDTO) {
        String url = envProperties.getWebAdscUri() + AdscApiConstant.APPDATA_DATA_UPDATE;

        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity<>(submitActionDTO, headers);
        try {
            ResponseEntity<BaseResultDTO<SubmitDataCheckResDto>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<SubmitDataCheckResDto>>() {
                    });
            if (respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            }
        } catch (Exception e) {

            log.error("提交任务到adsc服务异常：{} ,url:{} ,请求body体：{}, 报错信息：{}", ErrorCodeEnum.ADSC_APPDATA_DATA_UPDATE_EXCEPTION.getErrCode(), url, JsonUtils.objectToString(submitActionDTO), e);
            throw ExceptionUtil.wrap(ErrorCodeEnum.ADSC_APPDATA_DATA_UPDATE_EXCEPTION.getErrCode(), e);
        }
        return null;
    }

    @Override
    public void removeData(SubmitActionDTO submitActionDTO) {
        String url = envProperties.getWebAdscUri() + AdscApiConstant.APPDATA_DATA_CLEAR;
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity<>(submitActionDTO, headers);
        try {
            restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO>() {
                    });
        } catch (Exception e) {
            log.error("删除到adsc缓存异常：{},url:{} ,请求body体：{}, 报错信息：{}", ErrorCodeEnum.ADSC_APPDATA_DATA_UPDATE_EXCEPTION.getErrCode(), url,JsonUtils.objectToString(submitActionDTO), e);
            throw ExceptionUtil.wrap(ErrorCodeEnum.ADSC_REMOVE_CACHE_EXCEPTION.getErrCode(), e);
        }
    }
}
