package com.digiwin.athena.atmc.http.restful.thememap.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
public class TmAttachmentConfig {
    /**
     * 是否启用当前附件列
     */
    private Boolean enable;

    /**
     * 附件列描述
     */
    private Description description;

    /**
     * 提示
     */
    private Hint hint;

    /**
     * TM Activity ID
     */
    private String taskId;

    /**
     * 是否启用附件上传
     */
    private Boolean uploadEnable;

    /**
     * 附件上传的目录
     */
    private String uploadCategory;

    /**
     * 是否可读附件
     */
    private Boolean readEnable;

    /**
     * 可读附件目录
     */
    private String[] readCategory;

    /**
     * 是否可以删除附件
     */
    private Boolean deleteEnable;

    /**
     * 可执行删除操作的附件目录
     */
    private String[] deleteCategory;

    /**
     * 上传文件限制
     */
    private FileUploadLimit fileUploadLimit;

    /**
     * 作用于某个字段，可为null
     */
    private String targetSchema;

    /**
     * 是否禁用aam：上传后的附件信息不会保存至aam
     * 用来区分：true：api级别附件；false：平台级附件
     */
    private Boolean disableAam;

    /**
     * dmc bucket
     */
    private String buckets;

    /**
     * 提交后才会生效附件操作：上传保存or删除附件
     */
    private EffectAfterSubmit effectAfterSubmit;

    /**
     * dmc账密信息
     */
    private DmcAccount dmcAccount;
    /**
     * 仅上传者可删除
     */
    private Boolean onlyDeleteByOwner;

    /**
     * 是否为缩略图组件
     */
    private Boolean isThumbnail;

    /**
     * 附件过滤配置（作用于表头附件列过滤）
     */
    private Filter filter;

    /**
     * 附件类型
     * DMC(文档中心)/OUTER（外链附件）/ERP（erp附件）
     */
    private String type;

    /**
     * 附件过滤配置信息
     */
    @Data
    @NoArgsConstructor
    public static class Filter {
        /**
         * 过滤Key
         */
        private String key;
    }

    /**
     * dmc账号信息
     */
    @Data
    @NoArgsConstructor
    public static class DmcAccount {
        /**
         * dmc账号
         */
        private String account;

        /**
         * dmc账号密码
         */
        private String password;

        /**
         * 密码是否已经加过密
         */
        private boolean isPasswordAlreadyEncoded;
    }

    @Data
    @NoArgsConstructor
    public static class EffectAfterSubmit {
        /**
         * 作用于的提交按钮列表
         */
        private List<String> applyToSubmitActionId;

        /**
         * 提交数据的key
         */
        private String submitVariableName;
    }

    @Data
    @NoArgsConstructor
    public static class Description {
        /**
         * title，若language存在有效值，将会根据locale将title替换为language中配置的值
         */
        private String title;

        private DescLang language;
    }

    @Data
    @NoArgsConstructor
    public static class Hint {
        private String title;

        private DescLang language;
    }

    @Data
    @NoArgsConstructor
    public static class DescLang {
        /**
         * 附件列名配置：locale : "名称"
         */
        private Map<String, String> title;
    }

    @Data
    @NoArgsConstructor
    public static class FileUploadLimit {
        /**
         * 允许上传的文件扩展名列表
         */
        private String[] extensions;

        /**
         * 允许上传的文件数量
         */
        private Integer count;

        /**
         * 允许上传的文件大小
         */
        private Integer size;
    }
}
