package com.digiwin.athena.atmc.http.constant;

/**
 * @Author wuzq
 * @Date 2023/6/8 13:45
 * @Description: kg API
 * @Version 1.0
 */
public class KgApiConstant {
    private KgApiConstant() {
    }

    /**
     * 获取指定任务的任务定义（项目卡定义）
     */
    public static final String TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID = "knowledgegraph/task/definitionWithMultiLanguage?taskId={taskId}";

    /**
     * 获取指定任务的活动定义
     */
    public static final String TASK_ACTIVITIES_WITH_MULTI_LANGUAGE_TASK_ID_COMPOSITION_ID = "knowledgegraph/task/activitiesWithMultiLanguage?taskId={taskId}&compositionId={compositionId}";

    /**
     * 获取指定任务的活动定义
     */
    public static final String TASK_ACTIVITIES_WITH_MULTI_LANGUAGE_TASK_ID = "knowledgegraph/task/activitiesWithMultiLanguage?taskId={taskId}";

    /**
     * 根据活动id获取活动定义2（任务卡定义）
     */
    public static final String TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE = "knowledgegraph/task/activityDefinition?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";

    /**
     * 根据活动id获取活动定义（任务卡定义）
     */
    public static final String TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE = "knowledgegraph/task/activityDefinition?activityId={activityId}&pageCode={pageCode}";

    /**
     * 执行公式
     */
    public static final String TENANT_SETTINGS_FORMULA = "knowledgegraph/tenantSettings/formula?formulaId={formulaId}";

    /**
     * 待办工作台配置
     */
    public static final String WORKBENCH_SETTING = "knowledgegraph/workbenchSetting/workbenchSetting?pageCode={pageCode}&configType={configType}&appCondition={appCondition}";

    /**
     *
     */
    public static final String ACTIVITY_QUERY_COMPOSITION_BY_SOLVE_PLAN = "knowledgegraph/activity/queryCompositionBySolvePlan";

    /**
     * 根据项目/任务code 获取挂载的报表概要信息列表
     */
    public static final String TASK_REPORTS_BY_BIZ_CODE_NTYPE = "knowledgegraph/task/reportsByBizCodeNType";

    /**
     * 获取报表附属的任务或者项目作业列表
     */
    public static final String TASK_BIZS_BY_REPORT_CODE_NTYPE = "knowledgegraph/task/bizsByReportCodeNType";

    /**
     * 根据项目/任务code、报表code获取报表详情信息
     */
    public static final String TASK_REPORT_BY_BIZ_CODE_NTYPE_NREPORT_CODE = "knowledgegraph/task/reportByBizCodeNTypeNReportCode";

    /**
     * 任务引擎-查询themeMap项目所属的应用列表
     */
    public static final String RESTFUL_STANDARD_DATAMAP_APP_PROJECT_APPS = "/restful/standard/datamap/app/projectApps";

    public static final String view_taskCardField = "knowledgegraph/task/viewTaskCardField";

    /**
     * 流程引擎-查询themeMap项目所属的应用列表
     */
    public static final String RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_APP_CODE_BY_TASK_CODE = "knowledgegraph/app/appCodeByTaskCode?code={code}";

    /**
     * 获取任务的关联任务code
     */
    public static final String TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE = "knowledgegraph/task/activityStartTargetCode?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";

    /**
     * 根据emailCode和语言别，获取邮件模板ID
     */
    public static final String VIEW_EMAIL = "knowledgegraph/view/email";

    /**
     * 获取项目/任务的业务主键
     */
    public static final String VIEW_BK = "knowledgegraph/view/bk";

    /**
     * 根据 应用code 获取其包含的项目code列表
     */
    public static final String RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_TASK_CODE_APP_CODE = "knowledgegraph/app/taskCode?appCode={appCode}";

    /**
     * 批量获取项目的转派定义
     */
    public static final String BATCH_TASK_BASIC = "knowledgegraph/batch/taskBasic";

    /**
     * 批量获取任务的转派定义
     */
    public static final String BATCH_ACTIVITY_BASIC = "knowledgegraph/batch/activityBasic";

    /**
     * 获取报表resId
     */
    public static final String STATEMENT_RES_ID = "/knowledgegraph/statement/resId";

    /**
     * 获取作业inputData数据定义
     */
    public static final String ACTIVITY_INPUT_DATA_ACTIVITY_ID = "/knowledgegraph/activity/inputData?activityId={tmActivityId}";

    /**
     * 获取过期应用的组件列表（项目、任务、基础资料录入、报表等）
     */
    public static final String COMPONENT_QUERY_COMPONENT = "knowledgegraph/Component/QueryComponent";

    /**
     * 用appCode获取应用信息
     */
    public static final String APP_APPLICATION_BY_CODE = "knowledgegraph/app/applicationByCode?code={code}";

    /**
     * 根据themMap中的taskCode查询appId
     */
    public static final String TASK_APP_SUBSCRIPTION_TASK_ID = "knowledgegraph/task/appSubscription?taskId={taskId}";

    /**
     * 根据code获取所有应用
     */
    public static final String APP_APP_CODE_BY_TASK_CODE = "knowledgegraph/app/appCodeByTaskCode?code={code}";

    /**
     * 获取租户购买的对应应用
     */
    public static final String TASK_QUERY_RELATED_TASK = "knowledgegraph/task/queryRelatedTask";

    /**
     * 调用km的接口获取基础资料，报表以及手动发起项目的的信息
     * 2:手动发起项目  3：基础资料 4：报表
     */
    public static final String TASK_QUERY_ITEM_CONDITION_ITEM_NAME = "knowledgegraph/task/queryItem?condition={itemName}";

    /**
     * 用appCode获取应用信息
     */
    public static final String TASK_APPLICATION_RELATION = "knowledgegraph/task/applicationRelation";

    /**
     * 查询规则
     */
    public static final String TASK_CARD_OPTIMIZE_RULES = "knowledgegraph/task/cardConfig";
}
