package com.digiwin.athena.atmc.http.restful.dap.impl;

import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.http.constant.DapApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.util.AppTimeUtil;
import com.digiwin.athena.atmc.http.domain.eventlog.EventLogDTO;
import com.digiwin.athena.atmc.http.restful.dap.EventLogService;
import com.digiwin.athena.atmc.http.domain.task.SearchReqDTO;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


@Slf4j
@Service
public class EventLogServiceImpl implements EventLogService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    /**
     * 记录事件
     *
     * @param dto
     */
    @Override
    public void addEventLog(EventLogDTO dto) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //post body
        JSONObject req = new JSONObject();
        JSONObject params = new JSONObject();
        params.put("database", "event_log");
        params.put("table", "athena_atmc_event_log");
        JSONArray datas = new JSONArray();
        datas.add(dto);
        params.put("datas", datas);
        req.put("params", params);
        HttpEntity<?> httpEntity = new HttpEntity<>(req, headers);
        String url = envProperties.getDapUri() + DapApiConstant.DWEVENT_IEVENT_SERVICE_POST_BY_CONDITION;
        restTemplate.postForObject(url, httpEntity, String.class);
    }

    /**
     * 查询事件
     *
     * @param reqDTO
     */
    @Override
    public JSONObject getEventLog(SearchReqDTO reqDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //post body
        JSONObject req = new JSONObject();
        JSONObject queryInfo = new JSONObject();
        queryInfo.put("pageSize", reqDTO.getPageSize());
        queryInfo.put("pageNumber", reqDTO.getPageNumber());
        JSONObject condition = new JSONObject();
        condition.put("database", "event_log");
        condition.put("table", "athena_atmc_event_log");
        condition.put("searchColumns", "createTime,eventContent");
        condition.put("searchText", reqDTO.getParam());
        condition.put("tenantId", reqDTO.getTenantId());
        queryInfo.put("condition", condition);
        JSONObject order = new JSONObject();
        order.put("createTime", "desc");
        queryInfo.put("order", order);
        req.put("queryInfo", queryInfo);
        HttpEntity<?> httpEntity = new HttpEntity<>(req, headers);
        String url = envProperties.getDapUri() + DapApiConstant.DWEVENT_IEVENT_SERVICE_GET_BY_CONDITION;
        JSONObject response = restTemplate.postForObject(url, httpEntity, JSONObject.class);
        JSONObject result = new JSONObject();
        result.put("code", 0);
        result.put("message", "ok");
        result.put("total", response.getJSONObject("response").getString("count"));

        JSONArray resultDataList = convert(response.getJSONObject("response").getJSONArray("datas"));
        result.put("data", resultDataList);
        return result;
    }

    private JSONArray convert(JSONArray jsonArray) {
        if (null == jsonArray || jsonArray.isEmpty()) {
            return jsonArray;
        }

        for (int idx = 0; idx < jsonArray.size(); idx++) {
            JSONObject jsonObj = jsonArray.getJSONObject(idx);
            if (null != jsonObj) {
                // UTC（如：2021-10-13T06:42:01.268Z） --> 本地时区
                if (needConvertCreateTime(jsonObj)) {
                    jsonObj.put("createTime", AppTimeUtil.utcZone0ToLocal(jsonObj.getString("createTime"), AppTimeUtil.UTC_TIME_PATTERN, TimeUtils.DEFAULT_FORMAT));
                }
            }
        }
        return jsonArray;
    }

    private boolean needConvertCreateTime(JSONObject doc) {
        if (doc.containsKey("createTime") && StringUtils.isNotBlank(doc.getString("createTime"))) {
            String createTime = doc.getString("createTime");
            return StringUtils.contains(createTime, "T");
        }
        return false;
    }
}
