package com.digiwin.athena.atmc.http.restful.emc.impl;

import com.alibaba.druid.util.StringUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.constant.EmcApiConstant;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.message.MessageDO;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.emc.SendEmailService;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class SendEmailServiceImpl implements SendEmailService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * {@inheritDoc}
     */
    @Override
    public void sendEmail(JSONObject content) {
        AuthoredUser authoredUser = getContextAuthoredUser();
        log.info("[SendEmail] SendEmailService start: {}", content);
        log.info("[SendEmail] userId: {}, tenantId: {}, token: {}", authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());

        String url = envProperties.getEmcUri() + EmcApiConstant.SEND_EMAIL_URL;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(content, headers);

        ResponseEntity<HashMap> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class);
        Object code = respEntity.getBody().get("code");
        Object success = respEntity.getBody().get("success");
        try {
            if (!requestSuccess(code, success)) {
                log.error("{}, 调用emc发送邮件失败，{}, {}", ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrCode(), ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrMsg(), "status code: " + HttpStatus.SC_OK + ", code: " + code + ", message: " + JsonUtils.objectToString(respEntity.getBody().get("message")));
                throw ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getBusinessException();
            }
        } catch (Exception ex) {
            throw ExceptionUtil.wrap(ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrCode(), ex);
        }
    }

    private AuthoredUser getContextAuthoredUser() {
        if (null != AppAuthContextHolder.getContext().getAuthoredUser()) {
            return AppAuthContextHolder.getContext().getAuthoredUser();
        } else {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void sendEmailWithTemplate(String templateId, String contacts, Map emailData, MessageDO message) {
        JSONObject emailJson = new JSONObject();
        emailJson.put("eventId", templateId);

        JSONObject emailMsg = new JSONObject();
        emailMsg.put("data", emailData);
        emailJson.put("message", emailMsg);
        emailJson.put("contacts", contacts);
        if (ObjectUtils.isNotEmpty(message) && !StringUtils.isEmpty(message.getFileId())) {
            emailJson.put("dmcAttachments", Collections.singletonList(message.getFileId()));
            emailJson.put("dmcBucket", message.getDmcBucket());
        }
        log.info("[sendEmailWithTemplate emailJson]:{}", emailJson);
        LogDto logDto = new LogDto("开始发送邮件，模板id：" + templateId, templateId);
        log.info(logDto.toString());
        sendEmail(emailJson);
    }

    private boolean requestSuccess(Object code, Object success) {
        if (null == code || null == success) {
            return false;
        }

        return StringUtils.equals(String.valueOf(code), String.valueOf(HttpStatus.SC_OK)) && Boolean.valueOf(String.valueOf(success));
    }
}
