package com.digiwin.athena.atmc.http.restful.iam;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamAddUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamCheckUserResultDTO;

import java.util.Map;

/**
 * 企业用户管理
 */
public interface BossIamService {

    /**
     * 检查
     * @param tenantId
     * @param appId
     * @param email
     * @return
     */
    BossIamCheckUserResultDTO checkTenantUser(String tenantId, String appId, String email);

    /**
     * 将用户添加到企业用户中
     * @param tenantId
     * @param email
     */
    BossIamAddUserResultDTO addTenantUser(String tenantId, String email, String pwd, String appId);

    /**
     * 根据邮箱获取个人租户
     * -1 调用接口失败
     * 0 没有个人租户
     * 1 没有授权
     * 2 有个人租户并且有授权
     * @Author：SYQ
     * @Date：2021/11/24 14:20
     */
    Map<String,Object> getTenantAuth(AuthoredUser authoredUser,String email, String telephone, String appId, Integer tenantType);

    /**
     * 创建个人租户并且自动授权应用
     * @Author：SYQ
     * @Date：2021/11/24 15:33
     */
    Map<String,String> registerTenant(AuthoredUser authoredUser,String email,String telephone,String appId,String strategySid,String strategyCode);

    /**
     * 给指定租户下的用户授权指定应用
     * @Author：SYQ
     * @Date：2021/11/24 15:50
     */
    Boolean authorizeUser(AuthoredUser authoredUser,String tenantId,String email,String telephone,String appId,
                          String strategySid,String strategyCode,Boolean isTenantAuth);

}
