package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.GmcApiConstant;
import com.digiwin.athena.atmc.http.constant.IamApiConstant;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.iam.model.IamTenantSimpleDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.digiwin.athena.atmc.http.restful.iam.TenantService;
import com.digiwin.athena.atmc.http.domain.tenant.TenantBaseRespDto;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Service
@Slf4j
public class TenantServiceImpl implements TenantService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public boolean isTest(String token, String id) {
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", token);
        headers.setContentType(MediaType.APPLICATION_JSON);
        //post body
        Map<String, String> param = new HashMap<>();
        param.put("id", id);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        String url = envProperties.getIamUri() + IamApiConstant.TENANT_SIMPLE;
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url, httpEntity, Map.class);
        Map result = responseEntity.getBody();
        if (null == result || !result.containsKey("testTenant")) {
            return false;
        }
        return (boolean) result.get("testTenant");
    }


    /**
     * 根据租户id，名称或者统编号查询租户信息
     *
     * @param content 租户id或者名称
     * @param taxNo   统编号码
     * @return 租户信息集合
     */
    public List<TenantBaseRespDto> queryTenant(String content, String taxNo, AuthoredUser user) {
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", user.getToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
//        //post body
//        Map<String, String> param = new HashMap<>();
//        param.put("tenantContent", content);
//        param.put("unifiedTaxationCode", taxNo);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        String url = envProperties.getIamUri() +
                AtmcStrUtil.format(IamApiConstant.TENANT_RELEVANTINFO, content, taxNo);

        ResponseEntity<JSONArray> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONArray.class);
        if (null == responseEntity.getBody()) {
            return new ArrayList<>();
        }
        JSONArray arrs = responseEntity.getBody();
        return (List<TenantBaseRespDto>) JSONArray.toCollection(arrs, TenantBaseRespDto.class);
    }

    /**
     * 获取租户简单信息
     *
     * @param tenantId
     * @return
     */
    public IamTenantSimpleDTO getTenantSimple(String tenantId) {

        // http://172.16.2.141:22694/html/web/controller/console/console.html

        String uri = envProperties.getIamUri() + IamApiConstant.TENANT_SIMPLES;

        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        List<String> param = new ArrayList<>();
        param.add(tenantId);

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        ResponseEntity<List<IamTenantSimpleDTO>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<List<IamTenantSimpleDTO>>() {
                }, new HashMap<>());

        List<IamTenantSimpleDTO> resultList = responseEntity.getBody();
        if (CollectionUtils.isNotEmpty(resultList)) {
            return resultList.get(0);
        }

        return null;
    }

    /**
     * 从api中获取租户的虚拟token
     *
     * @param tenantId 租户id
     * @return token信息
     */
    public JSONObject queryApiVirtualToken(String tenantId) {
        //查询租户虚拟tokenUrl
        String uri = envProperties.getIamUri() + IamApiConstant.IDENTITY_LOGIN_INTERNAL;

        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("tenantId", tenantId);
        param.put("userId", "integration");
        param.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        ResponseEntity<JSONObject> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<JSONObject>() {
                }, param);


        JSONObject result = responseEntity.getBody();
        if (null == result) {
            log.error("this tenant :{}return none virtual token.", tenantId);
            return new JSONObject();
        }
        return result;

    }

    @Override
    public JSONObject queryAppAuthInfo(AuthoredUser user, String appCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.set(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        headers.set(GlobalConstant.IAM_APP_TOKEN, com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        //headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        String url = envProperties.getGmcUri() +
                AtmcStrUtil.format(GmcApiConstant.GMC_GOODS_MAPPINGS, appCode);
        ResponseEntity<JSONObject> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class);
        log.info("[deleteDingDingTodo] 通过appcode获取钉钉suiteKey req:{}, result:{}",  JsonUtils.objectToString(httpEntity),JsonUtils.objectToString(responseEntity));
        if (null == responseEntity.getBody()) {
            return new JSONObject();
        }
        JSONObject jsonObject = responseEntity.getBody();
        return jsonObject;
    }

    @Override
    public JSONObject queryAppUser(long sid,String token,String identityId) {
        String url = envProperties.getIamUri() + IamApiConstant.GMC_V_2_MAPPING_QUERY;

        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(GlobalConstant.IAM_USER_TOKEN, token);
        headers.set(GlobalConstant.IAM_APP_TOKEN, com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        JSONObject object = new JSONObject();
        object.put("userSid",sid);
        object.put("identityId",identityId);
        HttpEntity<?> httpEntity = new HttpEntity<>(object, headers);
        ResponseEntity<List<JSONObject>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<List<JSONObject>>() {
                }, new HashMap<>());
        log.info("queryAppUser httpEntity:{},result:{}", JsonUtils.objectToString(httpEntity) ,JsonUtils.objectToString(responseEntity));
        List<JSONObject> resultList = responseEntity.getBody();
        if (CollectionUtils.isNotEmpty(resultList)) {
            for (JSONObject jsonObject : resultList){
                //只用一次，先不定义成常量
                if ("dingding".equals(jsonObject.getString("account"))){
                    return jsonObject;
                }
            }
        }
        return null;
    }
}
