package com.digiwin.athena.atmc.http.restful.ptm.model;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class ReassignTrace extends BaseEntity<ReassignTrace> {

    @TableId()
    private Long id;

    /**
     * 转派类型，0-任务转派；1-项目转派
     */
    private Integer category;

    /**
     * 来源ID，根据转派类型，可能是backlog.id，也可能是task.id
     */
    private Long sourceId;

    /**
     * 操作人ID
     */
    private String operatorId;

    /**
     * 操作人name
     */
    private String operatorName;

    /**
     * 原执行人Id
     */
    private String oldPerformerId;

    /**
     * 原执行人name
     */
    private String oldPerformerName;

    /**
     * 新执行人id
     */
    private String newPerformerId;

    /**
     * 新执行人name
     */
    private String newPerformerName;

    /**
     * 转派意见
     */
    private String comment;

}