package com.digiwin.athena.atmc.http.restful.thememap.model;

import com.baomidou.mybatisplus.core.enums.IEnum;

/**
 * themeMap 任务定义中 category 的枚举值
 */
public enum TmTaskCategory implements IEnum<String> {

    /**
     * 未定义
     */
    NONE("NONE"),

    /**
     * 签核型-任务
     */
    APPROVAL("APPROVAL"),

    /**
     * 回复型-任务
     */
    REPLY("REPLY"),

    /**
     * 手动发起项目
     */
    START_PROJECT("StartProject"),

    /**
     * 异常排除型-任务
     */
    SOLVE("SOLVE");

    private String category;

    TmTaskCategory(String category){
        this.category = category;
    }

    public String getCategory(){
        return getValue();
    }

    @Override
    public String getValue() {
        return category;
    }

}
