package com.digiwin.athena.atmc.http.restful.thememap.model;

import com.baomidou.mybatisplus.core.enums.IEnum;

/**
 * themeMap 任务定义中 pattern 的枚举值
 */
public enum TmTaskPattern implements IEnum<String> {

    /**
     * 未定义
     */
    NONE("NONE"),

    /**
     * 报表
     */
    STATEMENT("STATEMENT"),

    /**
     * 基础资料录入
     */
    BASE_DATA("DATA_ENTRY"),

    /**
     * 业务
     */
    BUSINESS("BUSINESS");

    private String pattern;

    TmTaskPattern(String pattern){
        this.pattern = pattern;
    }

    public String getPattern(){
        return getValue();
    }

    @Override
    public String getValue() {
        return pattern;
    }
}
