/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.domain;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.domain.RelationTag;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.util.StringUtils;

public class ExecuteContext {
    private String locale;
    private String clientAgent;
    private String identity;
    private String tmProjectId;
    private String tmActivityId;
    private String tmActivityName;
    private String proxyToken;
    @JsonIgnore
    private AuthoredUser authoredUser;
    private String pageCode;
    private String deviceType;
    private String deviceValue;
    private String pattern;
    private String category;
    private RelationTag relationTag;
    private String tenantId;
    private Map<String, String> businessUnit;
    private Boolean openWindow;
    private Boolean isShared;
    private Map<String, Object> activityParameter;

    @JsonIgnore
    public boolean isNotShared() {
        return null == this.isShared || false == this.isShared;
    }

    @JsonGetter(value="isShared")
    public boolean isShared() {
        return BooleanUtils.isTrue((Boolean)this.isShared);
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request, String pageCode, String tmProjectId, String tmActivityId, Boolean isShared) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        ExecuteContext executeContext = ExecuteContext.builder().clientAgent(clientAgent).locale(locale).authoredUser(authoredUser).tenantId(authoredUser.getTenantId()).pageCode(pageCode).tmActivityId(tmActivityId).tmProjectId(tmProjectId).isShared(isShared).build();
        return executeContext;
    }

    public static ExecuteContextBuilder builder() {
        return new ExecuteContextBuilder();
    }

    public String getLocale() {
        return this.locale;
    }

    public String getClientAgent() {
        return this.clientAgent;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getTmProjectId() {
        return this.tmProjectId;
    }

    public String getTmActivityId() {
        return this.tmActivityId;
    }

    public String getTmActivityName() {
        return this.tmActivityName;
    }

    public String getProxyToken() {
        return this.proxyToken;
    }

    public AuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    public String getPageCode() {
        return this.pageCode;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceValue() {
        return this.deviceValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCategory() {
        return this.category;
    }

    public RelationTag getRelationTag() {
        return this.relationTag;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Map<String, String> getBusinessUnit() {
        return this.businessUnit;
    }

    public Boolean getOpenWindow() {
        return this.openWindow;
    }

    public Boolean getIsShared() {
        return this.isShared;
    }

    public Map<String, Object> getActivityParameter() {
        return this.activityParameter;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setTmProjectId(String tmProjectId) {
        this.tmProjectId = tmProjectId;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public void setTmActivityName(String tmActivityName) {
        this.tmActivityName = tmActivityName;
    }

    public void setProxyToken(String proxyToken) {
        this.proxyToken = proxyToken;
    }

    @JsonIgnore
    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceValue(String deviceValue) {
        this.deviceValue = deviceValue;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setRelationTag(RelationTag relationTag) {
        this.relationTag = relationTag;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setBusinessUnit(Map<String, String> businessUnit) {
        this.businessUnit = businessUnit;
    }

    public void setOpenWindow(Boolean openWindow) {
        this.openWindow = openWindow;
    }

    public void setIsShared(Boolean isShared) {
        this.isShared = isShared;
    }

    public void setActivityParameter(Map<String, Object> activityParameter) {
        this.activityParameter = activityParameter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecuteContext)) {
            return false;
        }
        ExecuteContext other = (ExecuteContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$openWindow = this.getOpenWindow();
        Boolean other$openWindow = other.getOpenWindow();
        if (this$openWindow == null ? other$openWindow != null : !((Object)this$openWindow).equals(other$openWindow)) {
            return false;
        }
        Boolean this$isShared = this.getIsShared();
        Boolean other$isShared = other.getIsShared();
        if (this$isShared == null ? other$isShared != null : !((Object)this$isShared).equals(other$isShared)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$clientAgent = this.getClientAgent();
        String other$clientAgent = other.getClientAgent();
        if (this$clientAgent == null ? other$clientAgent != null : !this$clientAgent.equals(other$clientAgent)) {
            return false;
        }
        String this$identity = this.getIdentity();
        String other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        String this$tmProjectId = this.getTmProjectId();
        String other$tmProjectId = other.getTmProjectId();
        if (this$tmProjectId == null ? other$tmProjectId != null : !this$tmProjectId.equals(other$tmProjectId)) {
            return false;
        }
        String this$tmActivityId = this.getTmActivityId();
        String other$tmActivityId = other.getTmActivityId();
        if (this$tmActivityId == null ? other$tmActivityId != null : !this$tmActivityId.equals(other$tmActivityId)) {
            return false;
        }
        String this$tmActivityName = this.getTmActivityName();
        String other$tmActivityName = other.getTmActivityName();
        if (this$tmActivityName == null ? other$tmActivityName != null : !this$tmActivityName.equals(other$tmActivityName)) {
            return false;
        }
        String this$proxyToken = this.getProxyToken();
        String other$proxyToken = other.getProxyToken();
        if (this$proxyToken == null ? other$proxyToken != null : !this$proxyToken.equals(other$proxyToken)) {
            return false;
        }
        AuthoredUser this$authoredUser = this.getAuthoredUser();
        AuthoredUser other$authoredUser = other.getAuthoredUser();
        if (this$authoredUser == null ? other$authoredUser != null : !this$authoredUser.equals(other$authoredUser)) {
            return false;
        }
        String this$pageCode = this.getPageCode();
        String other$pageCode = other.getPageCode();
        if (this$pageCode == null ? other$pageCode != null : !this$pageCode.equals(other$pageCode)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$deviceValue = this.getDeviceValue();
        String other$deviceValue = other.getDeviceValue();
        if (this$deviceValue == null ? other$deviceValue != null : !this$deviceValue.equals(other$deviceValue)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        RelationTag this$relationTag = this.getRelationTag();
        RelationTag other$relationTag = other.getRelationTag();
        if (this$relationTag == null ? other$relationTag != null : !this$relationTag.equals(other$relationTag)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Map<String, String> this$businessUnit = this.getBusinessUnit();
        Map<String, String> other$businessUnit = other.getBusinessUnit();
        if (this$businessUnit == null ? other$businessUnit != null : !((Object)this$businessUnit).equals(other$businessUnit)) {
            return false;
        }
        Map<String, Object> this$activityParameter = this.getActivityParameter();
        Map<String, Object> other$activityParameter = other.getActivityParameter();
        return !(this$activityParameter == null ? other$activityParameter != null : !((Object)this$activityParameter).equals(other$activityParameter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecuteContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $openWindow = this.getOpenWindow();
        result = result * 59 + ($openWindow == null ? 43 : ((Object)$openWindow).hashCode());
        Boolean $isShared = this.getIsShared();
        result = result * 59 + ($isShared == null ? 43 : ((Object)$isShared).hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $clientAgent = this.getClientAgent();
        result = result * 59 + ($clientAgent == null ? 43 : $clientAgent.hashCode());
        String $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        String $tmProjectId = this.getTmProjectId();
        result = result * 59 + ($tmProjectId == null ? 43 : $tmProjectId.hashCode());
        String $tmActivityId = this.getTmActivityId();
        result = result * 59 + ($tmActivityId == null ? 43 : $tmActivityId.hashCode());
        String $tmActivityName = this.getTmActivityName();
        result = result * 59 + ($tmActivityName == null ? 43 : $tmActivityName.hashCode());
        String $proxyToken = this.getProxyToken();
        result = result * 59 + ($proxyToken == null ? 43 : $proxyToken.hashCode());
        AuthoredUser $authoredUser = this.getAuthoredUser();
        result = result * 59 + ($authoredUser == null ? 43 : $authoredUser.hashCode());
        String $pageCode = this.getPageCode();
        result = result * 59 + ($pageCode == null ? 43 : $pageCode.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $deviceValue = this.getDeviceValue();
        result = result * 59 + ($deviceValue == null ? 43 : $deviceValue.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        RelationTag $relationTag = this.getRelationTag();
        result = result * 59 + ($relationTag == null ? 43 : $relationTag.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Map<String, String> $businessUnit = this.getBusinessUnit();
        result = result * 59 + ($businessUnit == null ? 43 : ((Object)$businessUnit).hashCode());
        Map<String, Object> $activityParameter = this.getActivityParameter();
        result = result * 59 + ($activityParameter == null ? 43 : ((Object)$activityParameter).hashCode());
        return result;
    }

    public String toString() {
        return "ExecuteContext(locale=" + this.getLocale() + ", clientAgent=" + this.getClientAgent() + ", identity=" + this.getIdentity() + ", tmProjectId=" + this.getTmProjectId() + ", tmActivityId=" + this.getTmActivityId() + ", tmActivityName=" + this.getTmActivityName() + ", proxyToken=" + this.getProxyToken() + ", authoredUser=" + this.getAuthoredUser() + ", pageCode=" + this.getPageCode() + ", deviceType=" + this.getDeviceType() + ", deviceValue=" + this.getDeviceValue() + ", pattern=" + this.getPattern() + ", category=" + this.getCategory() + ", relationTag=" + this.getRelationTag() + ", tenantId=" + this.getTenantId() + ", businessUnit=" + this.getBusinessUnit() + ", openWindow=" + this.getOpenWindow() + ", isShared=" + this.getIsShared() + ", activityParameter=" + this.getActivityParameter() + ")";
    }

    public ExecuteContext(String locale, String clientAgent, String identity, String tmProjectId, String tmActivityId, String tmActivityName, String proxyToken, AuthoredUser authoredUser, String pageCode, String deviceType, String deviceValue, String pattern, String category, RelationTag relationTag, String tenantId, Map<String, String> businessUnit, Boolean openWindow, Boolean isShared, Map<String, Object> activityParameter) {
        this.locale = locale;
        this.clientAgent = clientAgent;
        this.identity = identity;
        this.tmProjectId = tmProjectId;
        this.tmActivityId = tmActivityId;
        this.tmActivityName = tmActivityName;
        this.proxyToken = proxyToken;
        this.authoredUser = authoredUser;
        this.pageCode = pageCode;
        this.deviceType = deviceType;
        this.deviceValue = deviceValue;
        this.pattern = pattern;
        this.category = category;
        this.relationTag = relationTag;
        this.tenantId = tenantId;
        this.businessUnit = businessUnit;
        this.openWindow = openWindow;
        this.isShared = isShared;
        this.activityParameter = activityParameter;
    }

    public ExecuteContext() {
    }

    public static class ExecuteContextBuilder {
        private String locale;
        private String clientAgent;
        private String identity;
        private String tmProjectId;
        private String tmActivityId;
        private String tmActivityName;
        private String proxyToken;
        private AuthoredUser authoredUser;
        private String pageCode;
        private String deviceType;
        private String deviceValue;
        private String pattern;
        private String category;
        private RelationTag relationTag;
        private String tenantId;
        private Map<String, String> businessUnit;
        private Boolean openWindow;
        private Boolean isShared;
        private Map<String, Object> activityParameter;

        ExecuteContextBuilder() {
        }

        public ExecuteContextBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public ExecuteContextBuilder clientAgent(String clientAgent) {
            this.clientAgent = clientAgent;
            return this;
        }

        public ExecuteContextBuilder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public ExecuteContextBuilder tmProjectId(String tmProjectId) {
            this.tmProjectId = tmProjectId;
            return this;
        }

        public ExecuteContextBuilder tmActivityId(String tmActivityId) {
            this.tmActivityId = tmActivityId;
            return this;
        }

        public ExecuteContextBuilder tmActivityName(String tmActivityName) {
            this.tmActivityName = tmActivityName;
            return this;
        }

        public ExecuteContextBuilder proxyToken(String proxyToken) {
            this.proxyToken = proxyToken;
            return this;
        }

        @JsonIgnore
        public ExecuteContextBuilder authoredUser(AuthoredUser authoredUser) {
            this.authoredUser = authoredUser;
            return this;
        }

        public ExecuteContextBuilder pageCode(String pageCode) {
            this.pageCode = pageCode;
            return this;
        }

        public ExecuteContextBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public ExecuteContextBuilder deviceValue(String deviceValue) {
            this.deviceValue = deviceValue;
            return this;
        }

        public ExecuteContextBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public ExecuteContextBuilder category(String category) {
            this.category = category;
            return this;
        }

        public ExecuteContextBuilder relationTag(RelationTag relationTag) {
            this.relationTag = relationTag;
            return this;
        }

        public ExecuteContextBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ExecuteContextBuilder businessUnit(Map<String, String> businessUnit) {
            this.businessUnit = businessUnit;
            return this;
        }

        public ExecuteContextBuilder openWindow(Boolean openWindow) {
            this.openWindow = openWindow;
            return this;
        }

        public ExecuteContextBuilder isShared(Boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public ExecuteContextBuilder activityParameter(Map<String, Object> activityParameter) {
            this.activityParameter = activityParameter;
            return this;
        }

        public ExecuteContext build() {
            return new ExecuteContext(this.locale, this.clientAgent, this.identity, this.tmProjectId, this.tmActivityId, this.tmActivityName, this.proxyToken, this.authoredUser, this.pageCode, this.deviceType, this.deviceValue, this.pattern, this.category, this.relationTag, this.tenantId, this.businessUnit, this.openWindow, this.isShared, this.activityParameter);
        }

        public String toString() {
            return "ExecuteContext.ExecuteContextBuilder(locale=" + this.locale + ", clientAgent=" + this.clientAgent + ", identity=" + this.identity + ", tmProjectId=" + this.tmProjectId + ", tmActivityId=" + this.tmActivityId + ", tmActivityName=" + this.tmActivityName + ", proxyToken=" + this.proxyToken + ", authoredUser=" + this.authoredUser + ", pageCode=" + this.pageCode + ", deviceType=" + this.deviceType + ", deviceValue=" + this.deviceValue + ", pattern=" + this.pattern + ", category=" + this.category + ", relationTag=" + this.relationTag + ", tenantId=" + this.tenantId + ", businessUnit=" + this.businessUnit + ", openWindow=" + this.openWindow + ", isShared=" + this.isShared + ", activityParameter=" + this.activityParameter + ")";
        }
    }
}

