package com.digiwin.athena.atmc.http.env;

import com.digiwin.athena.appcore.AppCoreProperties;
import com.digiwin.athena.appcore.config.HttpClientPoolConfig;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

/**
 * 配置信息
 *
 * @author chenxsa
 */
@Component
@Data
@Slf4j
public class EnvProperties {
    @Autowired
    private HttpClientPoolConfig httpClientPoolConfig;
    @Autowired
    private AppCoreProperties appCoreProperties;

    @Value("${gmc.uri:}")
    private String gmcUri;

    @Value("${spring.profiles.active:dev}")
    private String active;
    @Value("${server.port}")
    private String port;

    @Value("${web.uri:}")
    private String webUri;

    @Value("${smartdata.uri:}")
    private String webSmartDataUri;

    @Value("${smartdata.dataFootPrintUri:}")
    private String sdDataFootPrintUri;

    @Value("${smartdata.dataComparisonUri:}")
    private String sdDataComparisonUri;


    @Value("${uibot.uri:}")
    private String uibotUri;

    @Value("${bpm.uri:}")
    private String bpmUri;

    @Value("${esp.uri:}")
    private String espUri;

    @Value("${dap.uri:}")
    private String dapUri;

    @Value("${search.uri:}")
    private String searchUri;

    @Value("${eoc.uri:}")
    private String eocUri;

    /**
     * dap中间件
     */
    @Value("${iam.uri}")
    private String iamUri;

    @Value("${iam.bossUri:}")
    private String iamBossUri;

    /**
     * 中间件授权
     */
    @Value("${iam.cacUri:}")
    private String iamCacUri;

    /**
     * dmc文档中心
     */
    @Value("${iam.dmcUri:}")
    private String iamDmcUri;

    /**
     * 智能入口appId
     */
    @Value("${semc.appId:}")
    private String semcAppId;

    /**
     * dap中间件
     */
    @Value("${emc.uri:}")
    private String emcUri;

    @Value("${themeMap.knowledgeGraphUri:}")
    private String knowledgeGraphUri;

    @Value("${themeMap.dataMapUri:}")
    private String dataMapUri;


    @Value("${themeMap.supportPerson:}")
    private String webThemeMapSupportPerson;

    @Value("${xiaohui.uri:}")
    private String xiaohuiUri;

    @Value("${aim.uri:}")
    private String aimUri;

    @Value("${atdm.uri:}")
    private String atdmUri;

    @Value("${tdsc.uri:}")
    private String tdscUri;

    @Value("${im.uri:}")
    private String imUri;

    @Value("${asa.uri:}")
    private String asaUri;

    @Value("${taskEngine.uri:}")
    private String taskEngineUrl;

    @Value("${taskEngine.workflowUri:}")
    private String workflowUri;

    @Value("${language:}")
    private String defaultLanguage;

    @Value("${audc.uri:}")
    private String audcUri;

    @Value("${console.uri:}")
    private String consoleUri;

    @Value("${adsc.uri:}")
    private String webAdscUri;

    @Value("${abt.uri:}")
    private String abtUri;

    @Value("${aam.uri:}")
    private String aamUri;

    @Value("${mobile.uri:}")
    private String mobileUri;

    /**
     * 移动端 Web h5
     */
    @Value("${mobile.webUri:}")
    private String mobileWebUri;

    /**
     * 默认外部公共租户ID
     */
    @Value("${athena.externalCommonTenantId:}")
    private String externalCommonTenantId;

    @Value("${athena.mock.mockUser:}")
    private String athenaMockUser;

    @Value("${athena.mock.mockTenantId:}")
    private String athenaMockTenantId;

    @Value("${athena.mock.mockEnv:}")
    private String athenaMockEnv;

    /**
     * 是否为测试环境
     */
    @Value("${isTestEnv:false}")
    private boolean isTestEnv;

    /**
     * cam
     */
    @Value("${cam.uri:}")
    private String camUri;


    /**
     * 默认外部公共租户ID
     */
    //@Value("${athena.bpmMqRetryCount:100}")
    private int bpmMqRetryCount = 20;

    /**
     * 应用过期MQ消费失败重试次数
     */
    private int appExpireChangeMqRetryCount = 10;

    /**
     * PTM 地址
     * <p>只能配置paas区，其他环境不能配置</p>
     */
    @Value("${taskEngine.ptmUri:}")
    private String ptmUri;

    /**
     * 当前进程运行的主机名
     */
    private String host;
    /**
     * 当前进程所在的IP地址
     */
    private String ipAddress;
    /**
     * 空闲内存
     */
    private long freeMemory;
    /**
     * 内存总量
     */
    private long totalMemory;
    /**
     * java虚拟机允许开启的最大的内存
     */
    private long maxMemory;
    /**
     * 操作系统名称
     */
    private String osName;
    /**
     * 进程号
     */
    private long pid;
    /**
     * 程序启动时间
     */
    private LocalDateTime startTime;
    /**
     * 类所在路径
     */
    private String classPath;
    private String projectPath;

    public String getGmcUri() {
        return gmcUri;
    }

    public void setGmcUri(String gmcUri) {
        this.gmcUri = gmcUri;
    }

    /**
     * 程序运行时间，单位毫秒
     */
    private long runtime;
    /**
     * 线程总量
     */
    private int threadCount;

    private LocalDateTime currentTime;

    private ZoneId currentZoneId;

    public EnvProperties() {
    }

    /**
     * 把byte转换成M
     *
     * @param bytes
     * @return
     */
    static long byteToM(long bytes) {
        return (bytes / 1024 / 1024);
    }

    /**
     * 获取进程号，适用于windows与linux
     *
     * @return
     */
    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    public void refresh() {
        this.currentTime = LocalDateTime.now();
        this.currentZoneId = ZoneId.systemDefault();

        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        //空闲内存
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(byteToM(freeMemory));
        //内存总量
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(byteToM(totalMemory));
        //最大允许使用的内存
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(byteToM(maxMemory));
        //操作系统
        this.setOsName(System.getProperty("os.name"));
        InetAddress localHost;
        try {
            localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (ipAddress == null) {
                ipAddress = localHost.getHostAddress();
            }
        } catch (UnknownHostException e) {
            log.warn("UnknownHostException", e);
            this.setHost("未知");
        }
        //ip
        this.setIpAddress(ipAddress);

        //程序启动时间
        long startTime = runtimeMXBean.getStartTime();

        LocalDateTime startDate = LocalDateTime.ofEpochSecond(startTime / 1000, 0, ZoneOffset.ofHours(0));
        this.setStartTime(startDate);
        //类所在路径
        this.setRuntime(runtimeMXBean.getUptime());
        //线程总数
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(tryGetPid());
    }

    public String getActive() {
        return active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIamUri() {
        return iamUri;
    }

    public void setIamUri(String iamUri) {
        this.iamUri = iamUri;
    }


    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getMaxMemory() {
        return maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public String getOsName() {
        return osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public long getPid() {
        return pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public String getClassPath() {
        return classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getProjectPath() {
        return projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public long getRuntime() {
        return runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public int getThreadCount() {
        return threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

}
